/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;

public abstract class BarcodeGenerator {
    private boolean mShowHRI;
    private byte[] mBarcodeData;
    private String mHRIText;
    protected int mResolution;
    private float mWidthRatio;
    private int mBarcodeSize;
    private float mTextSize;
    protected int mHeight;
    protected int mBarcodeWidth;

    public final boolean setParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDigit, int height, int resolution) {
        if (!this.checkParameters(code, width, ratio, showHRIText, useCheckDigit, height, resolution)) {
            return false;
        }
        code = this.fillCheckDigit(code, useCheckDigit);
        this.mHRIText = new String(code);
        this.mHeight = height;
        this.mShowHRI = showHRIText;
        this.mResolution = resolution;
        this.mWidthRatio = (float)this.mResolution / 400.0f;
        if (width == TepraPrintBarcode.Width.Standard) {
            this.mWidthRatio = (float)((double)this.mWidthRatio * 1.5);
            this.mTextSize = (float)this.mHeight * 0.2f;
        } else if (width == TepraPrintBarcode.Width.Large) {
            this.mWidthRatio = (float)((double)this.mWidthRatio * 2.0);
            this.mTextSize = (float)this.mHeight * 0.2f;
        } else if (width == TepraPrintBarcode.Width.Small) {
            this.mWidthRatio = 1.0f;
            this.mTextSize = (float)this.mHeight * 0.15f;
        }
        if (this.mTextSize / (float)this.mResolution * 72.0f > 12.0f) {
            this.mTextSize = 0.16666667f * (float)this.mResolution;
        }
        this.mBarcodeWidth = this.getWidthIndex(width);
        int ratioIndex = this.getRatioIndex(ratio);
        int typeIndex = this.getTypeIndex(this.getType());
        this.mBarcodeData = this.getBarcodeData(code, typeIndex, ratioIndex, useCheckDigit);
        return true;
    }

    public final Bitmap makeImage() {
        if (this.mBarcodeData == null) {
            return null;
        }
        float barcodeWidth = (float)this.mBarcodeSize * this.mWidthRatio;
        float moduleWidth = 4.0f * this.mWidthRatio;
        float leftMargin = this.getLeftMargin(moduleWidth);
        float totalWidth = barcodeWidth + leftMargin + this.getRightMargin(moduleWidth);
        int bitmapWidth = (int)((double)totalWidth + 0.5);
        Bitmap barcodeBitmap = Bitmap.createBitmap((int)bitmapWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(barcodeBitmap);
        canvas.drawColor(-1);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setStyle(Paint.Style.FILL);
        paint.setDither(true);
        float drawUnit = this.mWidthRatio;
        int drawUnitCount = 0;
        for (int unitIndex = 0; unitIndex < this.mBarcodeSize + 1; ++unitIndex) {
            int byteIndex = unitIndex / 8;
            int bitIndex = unitIndex % 8;
            int check = 128 >> bitIndex;
            if (unitIndex != this.mBarcodeSize && (this.mBarcodeData[byteIndex] & check) != 0) {
                ++drawUnitCount;
                continue;
            }
            if (drawUnitCount == 0) continue;
            float left = leftMargin + drawUnit * (float)(unitIndex - drawUnitCount);
            RectF rect = new RectF(left, 0.0f, left + drawUnit * (float)drawUnitCount, (float)this.mHeight);
            canvas.drawRect(rect, paint);
            drawUnitCount = 0;
        }
        if (this.mShowHRI) {
            this.drawHRIText(canvas, this.mHRIText, this.mTextSize, barcodeWidth, moduleWidth);
        }
        return barcodeBitmap;
    }

    protected final int getTypeIndex(TepraPrintBarcode.Type type) {
        return Arrays.asList(TepraPrintBarcode.Type.values()).indexOf((Object)type);
    }

    protected final int getRatioIndex(TepraPrintBarcode.Ratio ratio) {
        int ratioValue = 0;
        switch (ratio) {
            case Small: {
                ratioValue = 1;
                break;
            }
            case Medium: {
                ratioValue = 0;
                break;
            }
            case Large: {
                ratioValue = 2;
            }
        }
        return ratioValue;
    }

    protected final int getWidthIndex(TepraPrintBarcode.Width width) {
        int widthValue = 1;
        switch (width) {
            case Small: {
                widthValue = 0;
                break;
            }
            case Standard: {
                widthValue = 1;
                break;
            }
            case Large: {
                widthValue = 2;
            }
        }
        return widthValue;
    }

    protected final void drawTextAtEqualSpaces(Canvas canvas, String text, float textSize, RectF rect) {
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(-1);
        canvas.drawRect(rect, backgroundPaint);
        Paint paint = new Paint();
        paint.setTextSize(textSize);
        paint.setTextAlign(Paint.Align.CENTER);
        int textLength = text.length();
        float spaceWidth = rect.width() / (float)textLength;
        for (int charIndex = 0; charIndex < textLength; ++charIndex) {
            float left = rect.left + spaceWidth * (float)charIndex;
            float offset = spaceWidth / 2.0f;
            String singleChar = text.substring(charIndex, charIndex + 1);
            canvas.drawText(singleChar, left + offset, rect.bottom - paint.descent(), paint);
        }
    }

    protected final float getTextSize() {
        return this.mTextSize;
    }

    protected final float getActualTextHeight(float textSize) {
        Paint paint = new Paint();
        paint.setTextSize(textSize);
        return paint.descent() - paint.ascent();
    }

    protected abstract boolean checkParameters(byte[] var1, TepraPrintBarcode.Width var2, TepraPrintBarcode.Ratio var3, boolean var4, boolean var5, int var6, int var7);

    protected abstract TepraPrintBarcode.Type getType();

    protected abstract byte[] fillCheckDigit(byte[] var1, boolean var2);

    protected float getLeftMargin(float moduleWidth) {
        return Math.max(moduleWidth * 10.0f, (float)(this.mResolution / 10));
    }

    protected float getRightMargin(float moduleWidth) {
        return this.getLeftMargin(moduleWidth);
    }

    protected void drawHRIText(Canvas canvas, String HRIText, float textSize, float barcodeWidth, float moduleWidth) {
        float margin = this.getLeftMargin(moduleWidth);
        float textHeight = this.getActualTextHeight(textSize);
        RectF strRect = new RectF(margin, (float)this.mHeight - textHeight, margin + barcodeWidth, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, HRIText, textSize, strRect);
    }

    protected byte getCheckDigit(byte[] code, int type) {
        return this.nativeGetCheckDigit(code, type);
    }

    protected byte[] getBarcodeData(byte[] code, int type, int ratio, boolean useCheckDigit) {
        return this.nativeGetBarcodeData(code, type, ratio, useCheckDigit);
    }

    protected boolean checkCompositionOfCode(byte[] code, String allowedChars) {
        boolean ret = true;
        try {
            String codeStr = new String(code, "UTF-8");
            for (int charIndex = 0; charIndex < codeStr.length(); ++charIndex) {
                if (allowedChars.indexOf(codeStr.codePointAt(charIndex)) != -1) continue;
                ret = false;
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    protected native byte nativeGetCheckDigit(byte[] var1, int var2);

    private native byte[] nativeGetBarcodeData(byte[] var1, int var2, int var3, boolean var4);

    static {
        System.loadLibrary("TepraPrint");
    }
}

