/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.text.format.Formatter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.kingjim.tepraprint.sdk.TepraPrint;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBitmapBinarizer;
import jp.co.kingjim.tepraprint.sdk.TepraPrintCallback;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDraw;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintObjectType;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManager;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceAccessStatus;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionBLE;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionBluetooth;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionPort9100TCP;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionWifiDirect;
import jp.co.kingjim.tepraprint.sdk.core.command.CommandFilter;
import jp.co.kingjim.tepraprint.sdk.core.command.DemandOperation;
import jp.co.kingjim.tepraprint.sdk.core.command.DevicePhase;
import jp.co.kingjim.tepraprint.sdk.core.command.OperationMode;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreDeviceStatus;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreErrorStatus;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreModelNumber;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreStatus;

public class PrintController {
    private final String TAG = this.getClass().getSimpleName();
    public static final int PRINT_CONTROLLER_BANDING_SIZE = 1024;
    private static final byte[] OPERATION_SEND_PRINT_END = new byte[]{27, 123, 3, 64, 64, 125};
    private static final byte[] OPERATION_SEND_AND_CUT = new byte[]{27, 123, 4, 43, 1, 44, 125};
    private static final byte[] OPERATION_SEND = new byte[]{27, 123, 4, 43, 0, 43, 125};
    public static final String LabelWriterStatusKeyStatus = "ST";
    public static final String LabelWriterStatusKeyError = "ER";
    public static final String LabelWriterStatusKeyTapeWidth = "TW";
    public static final String LabelWriterStatusKeyTapeKind = "TR";
    public static final String LabelWriterStatusKeyErrorDetail = "EI";
    public static final String LabelWriterStatusKeyTapeOption = "TO";
    public static final String LabelWriterStatusKeyInkRibbon = "IR";
    public static final String LabelWriterStatusKeyRibbonRest = "RR";
    public static final String LabelWriterStatusKeyErrorDetail2 = "EJ";
    public static final String LabelWriterStatusKeyPrintPage = "PP";
    public static final String LabelWriterStatusKeyErrorRemain = "ER2";
    public static final String LabelWriterStatusKeyErrorDetailRemain = "EI2";
    public static final String LabelWriterStatusKeyErrorDetail2Remain = "EJ2";
    public static final String LabelWriterStatusKeyOperationStatus = "Operation";
    public static final String LabelWriterStatusKeyTapeColor = "TC";
    public static final String LabelWriterStatusKeyRibbonColor = "RC";
    public static final String LabelWriterStatusKeyJobID = "JI";
    public static final String LabelWriterStatusKeyTapeSw = "TS";
    public static final String LabelWriterStatusKeyT8Sw = "T8S";
    public static final String LabelWriterStatusKeyT8Option = "T8O";
    public static final String LabelWriterStatusKeyT8IsTape = "T8T";
    public static final String LabelWriterStatusKeyTape8bit = "T8B";
    public static final String LabelWriterStatusKeyReceiveBuffer = "RB";
    public static final String LabelWriterStatusKeyWarning = "WA";
    public static final String LabelWriterStatusKeyPrintingPage = "PPN";
    public static final String LabelWriterStatusKeyTapeWinder = "TWS";
    public static final String LabelWriterStatusKeyBigroll = "BR";
    public static final String LabelWriterStatusKeyBrTapeLength_mm = "BTLM";
    public static final String LabelWriterStatusKeyBrTapeLength_inch = "BTLI";
    public static final String LabelWriterStatusKeyBrTapeUsageLength_mm = "BTUL";
    public static final String LabelWriterStatusKeyBrLabelTotal = "BLT";
    public static final String LabelWriterStatusKeyBrLabelCount = "BLC";
    public static final String LabelWriterStatusKeyBrTapeRGBA = "BTR";
    public static final String LabelWriterStatusKeyBrRibbonRGBA = "BRR";
    public static final String LabelWriterStatusKeyBrTapeWidth = "BTW";
    public static final String LabelWriterStatusKeyBrTapeKind = "BTK";
    public static final String LabelWriterStatusKeyBrPrintSpeed = "BPS";
    public static final String LabelWriterStatusKeyBrOption = "BO";
    public static final String LabelWriterStatusKeyBrPrintDensity = "BPD";
    public static final String LabelWriterStatusKeyBrHcutDepth = "BHD";
    public static final String LabelWriterStatusKeyReserved = "RES";
    public static final String LabelWriterStatusKeyReserved3 = "RES3";
    public static final String LabelWriterStatusKeyVersion = "VER";
    public static final String LabelWriterStatusKeyBrSerialNumber = "BSN";
    private static final int STATUS_WAIT_TIMEOUT = 10000;
    private static final int RESET_PRINTER_TIMEOUT = 10000;
    private static final int WAIT_FOR_STATUS_PROCESS_TIMEOUT = 30000;
    private static final String CommandFilterParameterKeyObjectType = "ParameterKeyObjectType";
    TepraPrint tepraPrint;
    TepraPrintCallback delegate;
    TepraPrintDraw _drawCallback;
    Map<String, String> _printerInfo = null;
    DeviceConnection _connection;
    DeviceConnection _connectionDatagram = null;
    Map<String, Object> _printParam;
    AccessManager _accessManager;
    Map<String, Integer> _LWStatus = null;
    Set<TepraPrintObjectType> _objectType;
    private boolean _printing = false;
    private boolean _feeding = false;
    private volatile boolean _cancelRequest = false;
    private boolean _resumeRequest = false;
    private boolean _resumeJob = false;
    private int _printJobPhase = 4;
    private int _feedJobPhase = 4;
    private volatile float _jobProgress = 0.0f;
    private int _commandLevel = 1;
    private boolean _resumeJobSupport = false;
    private int _pageNumber;
    private int _copies;
    private int _printingPage;
    private int _copiesParam;
    private int _resumePageNumber;
    private int _resumeCopiesNumber;
    private int _totalPrintingPage;
    private int _modelNumber = 4;
    CommandFilter _commandFilter;
    private int _lastSuspendJobStatusError;
    boolean _statusFetching = false;
    boolean _printStart;
    ExecutorService executorService;
    private Object lock = new Object();

    public PrintController() {
        this._commandFilter = new CommandFilter();
        this.executorService = Executors.newSingleThreadExecutor();
        this._objectType = new HashSet<TepraPrintObjectType>();
    }

    public boolean isPrinting() {
        return this._printing;
    }

    public TepraPrintDraw getDrawCallback() {
        return this._drawCallback;
    }

    public void setDrawCallback(TepraPrintDraw draw) {
        this._drawCallback = draw;
    }

    public TepraPrint getCaller() {
        return this.tepraPrint;
    }

    public void setCaller(TepraPrint tepraPrint) {
        this.tepraPrint = tepraPrint;
    }

    public TepraPrintCallback getDelegate() {
        return this.delegate;
    }

    public void setDelegate(TepraPrintCallback delegate) {
        this.delegate = delegate;
    }

    public Map<String, String> getPrinterInformation() {
        return this._printerInfo;
    }

    public void setPrinterInformation(Map<String, String> printerInformation) {
        String type = printerInformation.get("type");
        if (this._printerInfo != null && (type != null && type.toLowerCase().indexOf("_pdl-datastream._bluetooth.") != -1 ? printerInformation.get("name").equals(this._printerInfo.get("name")) && printerInformation.get("Serial Number").equals(this._printerInfo.get("Serial Number")) : (type != null && type.toLowerCase().indexOf("_pdl-datastream._ble.") != -1 ? printerInformation.get("name").equals(this._printerInfo.get("name")) && printerInformation.get("Serial Number").equals(this._printerInfo.get("Serial Number")) : (type != null && type.toLowerCase().indexOf("_pdl-datastream._wifidirect.") != -1 ? printerInformation.get("name").equals(this._printerInfo.get("name")) && printerInformation.get("host").equals(this._printerInfo.get("host")) && printerInformation.get("Serial Number").equals(this._printerInfo.get("Serial Number")) : printerInformation.get("name").equals(this._printerInfo.get("name")) && printerInformation.get("host").equals(this._printerInfo.get("host")) && printerInformation.get("domain").equals(this._printerInfo.get("domain")) && type != null && type.endsWith(this._printerInfo.get("type")))))) {
            return;
        }
        boolean isBluetooth = false;
        String macAddress = printerInformation.get("Serial Number");
        if (type != null && type.toLowerCase().indexOf("_pdl-datastream._tcp.") != -1) {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: TCP Port9100");
            this._connection = new DeviceConnectionPort9100TCP(printerInformation);
        } else if (type != null && type.toLowerCase().indexOf("_pdl-datastream._bluetooth.") != -1) {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: Bluetooth");
            this._connection = new DeviceConnectionBluetooth(printerInformation);
            isBluetooth = true;
        } else if (type != null && type.toLowerCase().indexOf("_pdl-datastream._ble.") != -1) {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: BLE");
            this._connection = new DeviceConnectionBLE(printerInformation);
            isBluetooth = true;
        } else if (type != null && type.toLowerCase().indexOf("_pdl-datastream._wifidirect.") != -1) {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: Wi-Fi Direct");
            this._connection = new DeviceConnectionWifiDirect(printerInformation);
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: Wi-Fi Direct Group Owner IP=" + printerInformation.get("host") + ", MAC address=" + macAddress);
        } else {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: offline");
            this._connection = new DeviceConnection(printerInformation);
        }
        this._accessManager = this._connection.accessManager;
        this._accessManager.processing = false;
        this._printerInfo = this._connection.printerInfo;
        if (isBluetooth) {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: MAC address=" + macAddress);
        } else {
            WifiManager wifi = (WifiManager)this.tepraPrint.getContext().getSystemService("wifi");
            WifiInfo wifiinfo = wifi.getConnectionInfo();
            this._accessManager.ipaddress = wifiinfo.getIpAddress();
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: IP address=" + Formatter.formatIpAddress((int)wifiinfo.getIpAddress()));
        }
        String mdl = this._printerInfo.get("usbmdl");
        Map<String, String> productInfo = new TepraPrintProductInformation().getInformation(mdl);
        if (productInfo != null && productInfo.size() != 0) {
            String productResumeJob;
            String productCommandLevel = productInfo.get("Command Level");
            if (productCommandLevel != null) {
                try {
                    this._commandLevel = Integer.parseInt(productCommandLevel);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((productResumeJob = productInfo.get("Resume Job")) != null) {
                this._resumeJobSupport = "YES".equals(productResumeJob);
            }
            String productModelNumber = productInfo.get("Model Number");
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: productModelNumber=" + productModelNumber);
            if (productModelNumber != null) {
                try {
                    this._modelNumber = Integer.parseInt(productModelNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void doPrint(Map<String, Object> printParameter) {
        if (this._printing || this._feeding) {
            return;
        }
        this._printing = true;
        this._accessManager.processing = true;
        this._cancelRequest = false;
        this._resumeRequest = false;
        this._resumeJob = false;
        this._printParam = printParameter;
        Object obj = null;
        this._copiesParam = -1;
        if (this._printParam.containsKey("ParameterKeyCopies")) {
            obj = this._printParam.get("ParameterKeyCopies");
            if (obj instanceof Integer) {
                this._copiesParam = (Integer)obj;
            } else if (obj instanceof Byte) {
                this._copiesParam = ((Byte)obj).intValue();
            } else if (obj instanceof Long) {
                this._copiesParam = ((Long)obj).intValue();
            } else if (obj instanceof Short) {
                this._copiesParam = ((Short)obj).intValue();
            } else if (obj instanceof Float) {
                this._copiesParam = ((Float)obj).intValue();
            } else if (obj instanceof Double) {
                this._copiesParam = ((Double)obj).intValue();
            }
        }
        if (this._copiesParam <= 0 || this._copiesParam > 99) {
            this._copiesParam = 1;
            this._printParam.put("ParameterKeyCopies", 1);
        }
        int density = -100;
        if (this._printParam.containsKey("ParameterKeyDensity")) {
            obj = this._printParam.get("ParameterKeyDensity");
            if (obj instanceof Integer) {
                density = (Integer)obj;
            } else if (obj instanceof Byte) {
                density = ((Byte)obj).intValue();
            } else if (obj instanceof Long) {
                density = ((Long)obj).intValue();
            } else if (obj instanceof Short) {
                density = ((Short)obj).intValue();
            } else if (obj instanceof Float) {
                density = ((Float)obj).intValue();
            } else if (obj instanceof Double) {
                density = ((Double)obj).intValue();
            }
        }
        if (density < -5 || density > 5) {
            this._printParam.put("ParameterKeyDensity", 0);
        }
        int tapeCut = -1;
        if (this._printParam.containsKey("ParameterKeyTapeCut")) {
            obj = this._printParam.get("ParameterKeyTapeCut");
            if (obj instanceof Integer) {
                tapeCut = (Integer)obj;
            } else if (obj instanceof Byte) {
                tapeCut = ((Byte)obj).intValue();
            } else if (obj instanceof Long) {
                tapeCut = ((Long)obj).intValue();
            } else if (obj instanceof Short) {
                tapeCut = ((Short)obj).intValue();
            } else if (obj instanceof Float) {
                tapeCut = ((Float)obj).intValue();
            } else if (obj instanceof Double) {
                tapeCut = ((Double)obj).intValue();
            }
        }
        if (tapeCut < 0 || tapeCut > 2) {
            this._printParam.put("ParameterKeyTapeCut", 0);
        }
        int halfCut = -1;
        if (this._printParam.containsKey("ParameterKeyHalfCut")) {
            obj = this._printParam.get("ParameterKeyHalfCut");
            if (obj instanceof Integer) {
                halfCut = (Integer)obj;
            } else if (obj instanceof Boolean) {
                int n = halfCut = (Boolean)obj != false ? 1 : 0;
            }
        }
        if (halfCut < 0 || halfCut > 1) {
            this._printParam.put("ParameterKeyHalfCut", true);
        }
        int printSpeed = -1;
        if (this._printParam.containsKey("ParameterKeyPrintSpeed")) {
            obj = this._printParam.get("ParameterKeyPrintSpeed");
            if (obj instanceof Integer) {
                printSpeed = (Integer)obj;
            } else if (obj instanceof Boolean) {
                int n = printSpeed = (Boolean)obj != false ? 1 : 0;
            }
        }
        if (printSpeed < 0 || printSpeed > 2) {
            this._printParam.put("ParameterKeyPrintSpeed", 0);
        } else {
            this._printParam.put("ParameterKeyPrintSpeed", printSpeed);
        }
        int tapeWidth = -1;
        if (this._printParam.containsKey("ParameterKeyTapeWidth") && (obj = this._printParam.get("ParameterKeyTapeWidth")) instanceof Integer) {
            tapeWidth = (Integer)obj;
        }
        if (tapeWidth < 1 || tapeWidth > 12) {
            this._printParam.put("ParameterKeyTapeWidth", 5);
        }
        int priority = -1;
        if (this._printParam.containsKey("ParameterKeyPriorityPrintSetting")) {
            obj = this._printParam.get("ParameterKeyPriorityPrintSetting");
            if (obj instanceof Integer) {
                priority = (Integer)obj;
            } else if (obj instanceof Boolean) {
                int n = priority = (Boolean)obj != false ? 1 : 0;
            }
        }
        if (priority < 0 || priority > 1) {
            this._printParam.put("ParameterKeyPriorityPrintSetting", false);
        }
        int continuous = -1;
        if (this._printParam.containsKey("ParameterKeyHalfCutContinuous")) {
            obj = this._printParam.get("ParameterKeyHalfCutContinuous");
            if (obj instanceof Integer) {
                continuous = (Integer)obj;
            } else if (obj instanceof Boolean) {
                int n = continuous = (Boolean)obj != false ? 1 : 0;
            }
        }
        if (continuous < 0 || continuous > 1) {
            this._printParam.put("ParameterKeyHalfCutContinuous", false);
        }
        int type = 0;
        if (this._objectType.contains((Object)TepraPrintObjectType.Barcode1D)) {
            type |= 1;
        }
        if (this._objectType.contains((Object)TepraPrintObjectType.Barcode2D)) {
            type |= 2;
        }
        this._printParam.put(CommandFilterParameterKeyObjectType, type);
        new AsyncTask<Object, Object, Object>(){

            protected Object doInBackground(Object ... params) {
                block3: {
                    PrintController.this._printing = true;
                    PrintController.this._cancelRequest = false;
                    PrintController.this._resumeRequest = false;
                    PrintController.this._resumeJob = false;
                    PrintController.this._jobProgress = 0.0f;
                    PrintController.this._pageNumber = 0;
                    PrintController.this._resumePageNumber = 1;
                    PrintController.this._resumeCopiesNumber = 0;
                    PrintController.this._totalPrintingPage = 0;
                    PrintController.this._printingPage = 0;
                    PrintController.this._printStart = false;
                    boolean previousResumeJobStatus = false;
                    while (true) {
                        int connectionStatus = PrintController.this.executePrint(!previousResumeJobStatus);
                        TepraPrintLogger.d("PrintController.doPrint", "connectionStatus: " + connectionStatus);
                        if (PrintController.this._LWStatus == null) {
                            TepraPrintLogger.d("PrintController.doPrint", "Printer status is null.");
                            return null;
                        }
                        int deviceStatus = PrintController.this._LWStatus.containsKey(PrintController.LabelWriterStatusKeyError) ? PrintController.this._LWStatus.get(PrintController.LabelWriterStatusKeyError) : 0;
                        TepraPrintLogger.d("PrintController.doPrint", "deviceStatus: " + deviceStatus);
                        if (deviceStatus == 0 && connectionStatus == 0) break block3;
                        if (!previousResumeJobStatus && !PrintController.this.isResumeJobStatus(connectionStatus)) break;
                        PrintController.this._resumeJob = true;
                        TepraPrintLogger.d("PrintController.doPrint", "isResumeJobStatus: true");
                        if (!PrintController.this.waitForUserRequest(connectionStatus)) {
                            TepraPrintLogger.d("PrintController.doPrint", "waitForUserRequest: false");
                            break block3;
                        }
                        TepraPrintLogger.d("PrintController.doPrint", "waitForUserRequest: true, _totalPrintingPage: " + PrintController.this._totalPrintingPage + ", _resumeCopiesNumber: " + PrintController.this._resumeCopiesNumber + ", _resumePageNumber: " + PrintController.this._resumePageNumber);
                        PrintController.this._printingPage = 0;
                        PrintController.this._printStart = false;
                        previousResumeJobStatus = true;
                    }
                    TepraPrintLogger.d("PrintController.doPrint", "isResumeJobStatus: false");
                }
                return null;
            }

            protected void onPostExecute(Object result) {
                PrintController.this._drawCallback = null;
                PrintController.this._printing = false;
                PrintController.this._accessManager.processing = false;
                PrintController.this.notifyChangePrintJobPhase(4);
            }
        }.execute(new Object[]{printParameter});
    }

    public void doTapeFeed(int mode) {
        if (this._printing || this._feeding) {
            return;
        }
        this._feeding = true;
        this._accessManager.processing = true;
        this._cancelRequest = false;
        new AsyncTask<Integer, Object, Object>(){

            protected Object doInBackground(Integer ... params) {
                PrintController.this._feeding = true;
                PrintController.this._cancelRequest = false;
                int opMode = params[0];
                int deviceStatus = 0;
                PrintController.this.notifyChangeTapeFeedJobPhase(1);
                PrintController.this._connection.printProcessing = true;
                deviceStatus = PrintController.this.checkStatusForBeforePrint(DemandOperation.DemandOperationTapeFeed);
                TepraPrintLogger.d("PrintController.doTapeFeed", "device status: " + deviceStatus);
                if (deviceStatus != 0) {
                    PrintController.this._feeding = false;
                    PrintController.this._accessManager.processing = false;
                    if (PrintController.this._LWStatus == null || PrintController.this._LWStatus.get(PrintController.LabelWriterStatusKeyStatus) == null) {
                        PrintController.this._connection.compulsionClose();
                        if (deviceStatus == -6) {
                            PrintController.this.notifyAbortTapeFeedJob(PrintCoreErrorStatus.PrintCoreErrorStatusOtherUsing.getIntValue(), -6);
                        } else {
                            PrintController.this.notifyAbortTapeFeedJob(-6, 0);
                        }
                    } else {
                        PrintController.this._connection.compulsionClose();
                        PrintController.this.notifyAbortTapeFeedJob(-5, deviceStatus);
                    }
                    PrintController.this.notifyChangeTapeFeedJobPhase(4);
                    return null;
                }
                if (PrintController.this._accessManager.isCancelRequest(PrintController.this._cancelRequest, PrintController.this._LWStatus)) {
                    PrintController.this._connection.compulsionClose();
                    PrintController.this.notifyChangeTapeFeedJobPhase(4);
                    PrintController.this._feeding = false;
                    PrintController.this._accessManager.processing = false;
                    return null;
                }
                if (PrintController.this._accessManager.requestAccess() != DeviceAccessStatus.DeviceAccessStatusConnectionSuccess) {
                    TepraPrintLogger.d("PrintController.doTapeFeed", "DeviceAccessStatusConnectionFailure");
                    int status = PrintController.this._LWStatus.containsKey(PrintController.LabelWriterStatusKeyStatus) ? PrintController.this._LWStatus.get(PrintController.LabelWriterStatusKeyStatus) : 0;
                    int errCode = PrintController.this._LWStatus.containsKey(PrintController.LabelWriterStatusKeyError) ? PrintController.this._LWStatus.get(PrintController.LabelWriterStatusKeyError) : 0;
                    PrintCoreModelNumber printCoreModelNumber = PrintCoreModelNumber.valueOf(PrintController.this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(PrintController.this._modelNumber);
                    OperationMode mode = PrintController.this._commandFilter.getOperationFromStatus(DemandOperation.DemandOperationTapeFeed, DevicePhase.DevicePhaseOccupation, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
                    PrintController.this._LWStatus.put(PrintController.LabelWriterStatusKeyOperationStatus, mode.getValue());
                    PrintController.this.notifyAbortTapeFeedJob(0, mode.getValue());
                    PrintController.this._feeding = false;
                    PrintController.this._accessManager.processing = false;
                    PrintController.this._connection.compulsionClose();
                    PrintController.this.notifyChangeTapeFeedJobPhase(4);
                    return null;
                }
                if (!PrintController.this._connection.open()) {
                    TepraPrintLogger.d("PrintController.doTapeFeed", "Device Connection open error");
                    PrintController.this.notifyAbortTapeFeedJob(-1, deviceStatus);
                    PrintController.this.notifyChangeTapeFeedJobPhase(4);
                    PrintController.this._feeding = false;
                    PrintController.this._accessManager.processing = false;
                    return null;
                }
                if (PrintController.this._accessManager.isCancelRequest(PrintController.this._cancelRequest, PrintController.this._LWStatus)) {
                    this.closeDevice(deviceStatus);
                    return null;
                }
                PrintController.this.notifyChangeTapeFeedJobPhase(2);
                PrintController.this.resetPrinterWait();
                if (!PrintController.this._accessManager.setRequestStatus()) {
                    TepraPrintLogger.d("PrintController.doTapeFeed", "Request status command error");
                    PrintController.this.notifyAbortTapeFeedJob(-6, deviceStatus);
                    this.closeDevice(deviceStatus);
                    return null;
                }
                deviceStatus = PrintController.this.checkStatusForPrinting(DevicePhase.DevicePhaseTapeFeeding);
                TepraPrintLogger.d("PrintController.doTapeFeed", "device status: " + deviceStatus);
                if (deviceStatus == 0) {
                    boolean sendResult;
                    if (opMode == 0) {
                        TepraPrintLogger.d("PrintController.doTapeFeed", "Execute tape feed");
                        sendResult = PrintController.this._connection.send(OPERATION_SEND, OPERATION_SEND.length);
                    } else {
                        TepraPrintLogger.d("PrintController.doTapeFeed", "Execute tape cut");
                        sendResult = PrintController.this._connection.send(OPERATION_SEND_AND_CUT, OPERATION_SEND_AND_CUT.length);
                    }
                    if (!sendResult) {
                        TepraPrintLogger.d("PrintController.doTapeFeed", "send communication error error");
                        PrintController.this.notifyAbortTapeFeedJob(-6, deviceStatus);
                        PrintController.this.notifyChangeTapeFeedJobPhase(4);
                        PrintController.this._feeding = false;
                        PrintController.this._accessManager.processing = false;
                        PrintController.this._connection.compulsionClose();
                        return null;
                    }
                    deviceStatus = PrintController.this.checkStatusForAfterPrint(DevicePhase.DevicePhaseTapeFeeding);
                    if (deviceStatus != 0) {
                        if (PrintController.this._LWStatus == null || PrintController.this._LWStatus.get(PrintController.LabelWriterStatusKeyStatus) == null) {
                            PrintController.this.notifyAbortTapeFeedJob(-6, 0);
                            PrintController.this._feeding = false;
                            PrintController.this._accessManager.processing = false;
                            PrintController.this._connection.compulsionClose();
                            PrintController.this.notifyChangeTapeFeedJobPhase(4);
                            return null;
                        }
                        TepraPrintLogger.d("PrintController.doTapeFeed", "checkStatusForAfterPrint error");
                        PrintController.this.notifyAbortTapeFeedJob(-5, deviceStatus);
                    }
                } else {
                    if (PrintController.this._LWStatus == null || PrintController.this._LWStatus.get(PrintController.LabelWriterStatusKeyStatus) == null) {
                        TepraPrintLogger.d("PrintController.doTapeFeed", "checkStatusForFeeding Communication error");
                        PrintController.this.notifyAbortTapeFeedJob(-6, 0);
                        PrintController.this._feeding = false;
                        PrintController.this._accessManager.processing = false;
                        PrintController.this._connection.compulsionClose();
                        PrintController.this.notifyChangeTapeFeedJobPhase(4);
                        return null;
                    }
                    TepraPrintLogger.d("PrintController.doTapeFeed", "checkStatusForFeeding error");
                    PrintController.this.notifyAbortTapeFeedJob(-5, deviceStatus);
                }
                this.closeDevice(deviceStatus);
                return null;
            }

            protected void closeDevice(int deviceStatus) {
                PrintController.this.resetPrinterWait();
                if (deviceStatus != 0 && deviceStatus != 35) {
                    PrintController.this.idleWait();
                }
                if (!PrintController.this._accessManager.resetRequestStatus()) {
                    TepraPrintLogger.d("PrintController.doTapeFeed", "Request status command error");
                    PrintController.this.notifyAbortTapeFeedJob(-6, deviceStatus);
                }
                PrintController.this._connection.printProcessing = false;
                PrintController.this._connection.close();
                PrintController.this._accessManager.releaseAccess();
                TepraPrintLogger.d("PrintController.doTapeFeed", "DeviceAccessStatusDisconnectionSuccess");
                PrintController.this.notifyChangeTapeFeedJobPhase(4);
                PrintController.this._accessManager.processing = false;
                PrintController.this._feeding = false;
            }
        }.execute((Object[])new Integer[]{mode});
    }

    public float getProgressOfPrint() {
        return this._jobProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageNumberOfPrinting() {
        if (this._printing) {
            int numberOfPages = this._drawCallback.getNumberOfPages();
            if (this._commandLevel == 3 || this._commandLevel == 4) {
                int pageNumber = 0;
                Object object = this.lock;
                synchronized (object) {
                    pageNumber = this._totalPrintingPage + this._printingPage;
                }
                if (numberOfPages > 0) {
                    TepraPrintLogger.d(this.TAG, "getPageNumberOfPrinting(ProductCommandLevel3,4): return " + (pageNumber + 1 <= this._copiesParam * numberOfPages ? pageNumber + 1 : this._copiesParam * numberOfPages) + ", _printingPage=" + this._printingPage + ", _copiesParam=" + this._copiesParam + ", _totalPrintingPage=" + this._totalPrintingPage);
                    return pageNumber + 1 <= this._copiesParam * numberOfPages ? pageNumber + 1 : this._copiesParam * numberOfPages;
                }
                return 0;
            }
            if (numberOfPages > 0) {
                TepraPrintLogger.d(this.TAG, "getPageNumberOfPrinting(Other): return " + (this._pageNumber + this._copies * numberOfPages));
                return this._pageNumber + this._copies * numberOfPages;
            }
            return 0;
        }
        return 0;
    }

    public void cancelPrint() {
        if (this._feeding && this._feedJobPhase != 1) {
            return;
        }
        this._cancelRequest = true;
    }

    public void resumeOfPrint() {
        int totalPage;
        int numberOfPages = this._drawCallback.getNumberOfPages();
        if (numberOfPages > 0 && this._totalPrintingPage >= (totalPage = numberOfPages * this._copiesParam)) {
            this._totalPrintingPage = totalPage - 1;
            TepraPrintLogger.d(this.TAG, "adjust _totalPrintingPage: " + this._totalPrintingPage);
            this._resumeCopiesNumber = this._totalPrintingPage / numberOfPages;
            this._resumePageNumber = this._totalPrintingPage % numberOfPages + 1;
        }
        this._resumeRequest = true;
    }

    public Map<String, Integer> fetchPrinterStatus() {
        this._statusFetching = true;
        if (this._printing || this._feeding) {
            long start = System.currentTimeMillis();
            while (this._LWStatus == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start <= 10000L) continue;
            }
            this._statusFetching = false;
            return this._LWStatus;
        }
        this._LWStatus = this.printerStatusAccess();
        if (this._LWStatus != null && this._LWStatus.containsKey(LabelWriterStatusKeyStatus) && this._LWStatus.containsKey(LabelWriterStatusKeyError)) {
            int status = this._LWStatus.get(LabelWriterStatusKeyStatus);
            int errCode = this._LWStatus.get(LabelWriterStatusKeyError);
            String mdl = this._connection.printerInfo.get("usbmdl");
            Map<String, String> productInfo = new TepraPrintProductInformation().getInformation(mdl);
            if (productInfo != null && productInfo.size() != 0) {
                String productModelNumber;
                String productResumeJob;
                String productCommandLevel = productInfo.get("Command Level");
                if (productCommandLevel != null) {
                    try {
                        this._commandLevel = Integer.parseInt(productCommandLevel);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((productResumeJob = productInfo.get("Resume Job")) != null) {
                    this._resumeJobSupport = "YES".equals(productResumeJob);
                }
                if ((productModelNumber = productInfo.get("Model Number")) != null) {
                    try {
                        this._modelNumber = Integer.parseInt(productModelNumber);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            PrintCoreModelNumber printCoreModelNumber = PrintCoreModelNumber.valueOf(this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(this._modelNumber);
            OperationMode mode = this._commandFilter.getOperationFromStatus(DemandOperation.DemandOperationTapeWidth, DevicePhase.DevicePhaseIdle, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
            this._LWStatus.put(LabelWriterStatusKeyOperationStatus, mode.getValue());
        }
        this._statusFetching = false;
        return this._LWStatus;
    }

    public Map<String, String> getDeviceInformation() {
        return this._accessManager.getDeviceInformation();
    }

    public int getDeviceErrorFromStatus(Map<String, Integer> status) {
        int deviceError = 0;
        if (status != null) {
            if (status.containsKey(LabelWriterStatusKeyOperationStatus) && status.get(LabelWriterStatusKeyOperationStatus) != null) {
                deviceError = status.get(LabelWriterStatusKeyOperationStatus);
            }
            if (deviceError == OperationMode.OperationModeReprint.getValue() && status.containsKey(LabelWriterStatusKeyError) && status.get(LabelWriterStatusKeyError) != null) {
                deviceError = status.get(LabelWriterStatusKeyError);
            }
        }
        return deviceError;
    }

    public Bitmap getPreviewImage() {
        return this.getPreviewImage(-1);
    }

    public Bitmap getPreviewImage(int page) {
        if (this._drawCallback.getNumberOfPages() < 1) {
            return null;
        }
        if (page < 1) {
            page = 1;
        }
        if (TepraPrintBitmapBinarizer.useDefaultTable.booleanValue()) {
            TepraPrintBitmapBinarizer.setModelNumber(this._modelNumber);
            TepraPrintBitmapBinarizer.isLowSpeed = false;
        }
        this._drawCallback.beginJob();
        Bitmap bitmap = this.createPreviewImageForPageNumber(page);
        this._drawCallback.endJob();
        return bitmap;
    }

    public List<Bitmap> getPreviewImages() {
        int numberOfPages = this._drawCallback.getNumberOfPages();
        if (numberOfPages < 1) {
            return null;
        }
        ArrayList<Bitmap> imageList = new ArrayList<Bitmap>();
        if (TepraPrintBitmapBinarizer.useDefaultTable.booleanValue()) {
            TepraPrintBitmapBinarizer.setModelNumber(this._modelNumber);
            TepraPrintBitmapBinarizer.isLowSpeed = false;
        }
        this._drawCallback.beginJob();
        for (int i = 1; i <= numberOfPages; ++i) {
            Bitmap bitmap = this.createPreviewImageForPageNumber(i);
            imageList.add(bitmap);
        }
        this._drawCallback.endJob();
        return imageList;
    }

    public int getBatteryType() {
        return this._accessManager.getBatteryType();
    }

    public void setBatteryType(int type) {
        this._accessManager.setBatteryType(type);
    }

    public void setObjectType(Set<TepraPrintObjectType> type) {
        this._objectType = type;
    }

    private Bitmap createPreviewImageForPageNumber(int pageNumber) {
        try {
            this._drawCallback.beginPage(pageNumber);
        }
        catch (Exception e) {
            TepraPrintLogger.w("PrintController.executePrint", "Print SDK error! Illegal form data.", e);
            return null;
        }
        int tapeImageHeight = this.getImageWidthForPreview(pageNumber);
        int tapeImageLength = this.getImageHeight(pageNumber);
        if (tapeImageHeight <= 0 || tapeImageLength <= 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)tapeImageLength, (int)tapeImageHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        this._drawCallback.drawContentForPreview(canvas, pageNumber);
        this._drawCallback.endPage();
        return bitmap;
    }

    private Map<String, Integer> printerStatusAccess() {
        Map<String, Integer> status = null;
        DeviceAccessStatus accessStatus = this._accessManager.requestAccessForStatus();
        if (accessStatus == DeviceAccessStatus.DeviceAccessStatusConnectionSuccess) {
            status = this._accessManager.getPrinterStatus();
            if (status == null) {
                status = new HashMap<String, Integer>();
                status.put(LabelWriterStatusKeyOperationStatus, -16);
            }
            this._accessManager.releaseAccessForStatus();
        } else {
            if (status == null) {
                status = new HashMap<String, Integer>();
            }
            if (accessStatus == DeviceAccessStatus.DeviceAccessStatusConnectionFailure) {
                status.put(LabelWriterStatusKeyOperationStatus, -6);
            } else {
                status.put(LabelWriterStatusKeyOperationStatus, -16);
            }
        }
        return status;
    }

    private void resetPrinter() {
        if (this._accessManager.requestAccessForStatus() == DeviceAccessStatus.DeviceAccessStatusConnectionSuccess) {
            this._accessManager.resetPrinter();
            this._accessManager.releaseAccessForStatus();
        }
    }

    private int getImageWidth(int pageNumber) {
        return this._drawCallback.getContentHeightForPage(pageNumber);
    }

    private int getImageWidthForPreview(int pageNumber) {
        return this._drawCallback.getPreviewHeightForPage(pageNumber);
    }

    private int getImageHeight(int pageNumber) {
        return this._drawCallback.getContentWidthForPage(pageNumber);
    }

    private int getContentMargin(int pageNumber) {
        return this._drawCallback.getContentMarginForPage(pageNumber);
    }

    private byte[] getImageData(int pageNumber, int startRow, int rowCount) {
        return this.getImageData(pageNumber, startRow, rowCount, null);
    }

    private byte[] getImageData(int pageNumber, int startRow, int rowCount, Bitmap givenBitmap) {
        int imageWidth = this.getImageWidth(pageNumber);
        if (imageWidth <= 0 || rowCount <= 0) {
            return null;
        }
        Bitmap bitmap = null;
        if (givenBitmap == null) {
            bitmap = Bitmap.createBitmap((int)imageWidth, (int)rowCount, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            bitmap = givenBitmap.copy(Bitmap.Config.ARGB_8888, true);
            imageWidth = bitmap.getWidth();
        }
        Canvas canvas = new Canvas(bitmap);
        Matrix matrix = new Matrix();
        matrix.postRotate(90.0f);
        matrix.postTranslate((float)imageWidth, (float)(-startRow));
        canvas.concat(matrix);
        if (givenBitmap == null) {
            canvas.drawColor(-1);
        }
        if (TepraPrintBitmapBinarizer.useDefaultTable.booleanValue()) {
            TepraPrintBitmapBinarizer.setModelNumber(this._modelNumber);
            int speed = (Integer)this._printParam.get("ParameterKeyPrintSpeed");
            TepraPrintBitmapBinarizer.isLowSpeed = speed == 1;
        }
        if (givenBitmap == null) {
            this._drawCallback.drawContent(canvas, pageNumber);
        }
        byte[] imageBuf = new byte[imageWidth * rowCount];
        int[] pixels = new int[imageWidth * rowCount];
        bitmap.getPixels(pixels, 0, imageWidth, 0, 0, imageWidth, rowCount);
        for (int byteIndex = 0; byteIndex < imageBuf.length; ++byteIndex) {
            int red = pixels[byteIndex] >> 16 & 0xFF;
            int green = pixels[byteIndex] >> 8 & 0xFF;
            int blue = pixels[byteIndex] & 0xFF;
            imageBuf[byteIndex] = (byte)((float)red * 0.299f + (float)green * 0.587f + (float)blue * 0.114f);
        }
        return imageBuf;
    }

    private void notifyChangePrintJobPhase(int phase) {
        this._printJobPhase = phase;
        if (this.delegate != null) {
            this.executorService.execute(new ChangePrintJobPhaseTask(phase));
        }
    }

    private void notifySuspendPrintJob(int errorStatus, int deviceStatus) {
        if (this.delegate != null) {
            this.executorService.execute(new SuspendPrintJobTask(errorStatus, deviceStatus));
        }
    }

    private void notifyAbortPrintJob(int errorStatus, int deviceStatus) {
        if (this.delegate != null) {
            this.executorService.execute(new AbortPrintJobTask(errorStatus, deviceStatus));
        }
    }

    private void notifyChangeTapeFeedJobPhase(int phase) {
        this._feedJobPhase = phase;
        if (this.delegate != null) {
            this.executorService.execute(new ChangeTapeFeedJobPhaseTask(phase));
        }
    }

    private void notifyAbortTapeFeedJob(int errorStatus, int deviceStatus) {
        if (this.delegate != null) {
            this.executorService.execute(new AbortTapeFeedJobPhaseTask(errorStatus, deviceStatus));
        }
    }

    private int executePrint(boolean notify) {
        OperationMode mode;
        PrintCoreModelNumber printCoreModelNumber;
        int errCode;
        int status;
        DeviceAccessStatus accessStatus;
        Object contentData = null;
        this.waitForStatusProcess();
        Map<String, Integer> parameter = this.convertToIntegerMap(this._printParam);
        this._commandFilter.setPrintParameters(parameter);
        int deviceStatus = 0;
        int connectStatus = 0;
        this.notifyChangePrintJobPhase(1);
        this._connection.printProcessing = true;
        this._resumeRequest = false;
        boolean otherUsingRequired = this._printParam.containsKey("ParameterKeyOtherUsingWaitingRequired") ? (Boolean)this._printParam.get("ParameterKeyOtherUsingWaitingRequired") : false;
        while (true) {
            deviceStatus = this.checkStatusForBeforePrint(DemandOperation.DemandOperationPrint);
            this._printingPage = 0;
            if (deviceStatus != -6 || !otherUsingRequired) break;
            this.notifySuspendPrintJob(PrintCoreErrorStatus.PrintCoreErrorStatusOtherUsing.getIntValue(), -6);
            while (!this._cancelRequest && !this._resumeRequest) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            if (this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) {
                this._connection.compulsionClose();
                return 0;
            }
            this._resumeRequest = false;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        TepraPrintLogger.d("PrintController.executePrint", "device status: " + deviceStatus);
        if (deviceStatus != 0) {
            if (this._LWStatus == null || this._LWStatus.get(LabelWriterStatusKeyStatus) == null) {
                connectStatus = -6;
            }
            if (this.isResumeJobStatus(connectStatus)) {
                this._connection.compulsionClose();
                return connectStatus;
            }
            if (connectStatus == -6) {
                if (notify) {
                    this.notifyAbortPrintJob(-6, 0);
                }
                this._connection.compulsionClose();
                return -6;
            }
            if (notify) {
                this.notifyAbortPrintJob(-5, deviceStatus);
            }
            this._connection.compulsionClose();
            return -5;
        }
        if (this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) {
            this._connection.compulsionClose();
            return 0;
        }
        if (otherUsingRequired) {
            this._resumeRequest = false;
            while ((accessStatus = this._accessManager.requestAccess()) != DeviceAccessStatus.DeviceAccessStatusConnectionSuccess) {
                TepraPrintLogger.d("PrintController.executePrint", "DeviceAccessStatusConnectionFailure");
                status = this._LWStatus.containsKey(LabelWriterStatusKeyStatus) ? this._LWStatus.get(LabelWriterStatusKeyStatus) : 0;
                errCode = this._LWStatus.containsKey(LabelWriterStatusKeyError) ? this._LWStatus.get(LabelWriterStatusKeyError) : 0;
                printCoreModelNumber = PrintCoreModelNumber.valueOf(this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(this._modelNumber);
                mode = this._commandFilter.getOperationFromStatus(DemandOperation.DemandOperationPrint, DevicePhase.DevicePhaseOccupation, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
                this._LWStatus.put(LabelWriterStatusKeyOperationStatus, mode.getValue());
                this.notifySuspendPrintJob(PrintCoreErrorStatus.PrintCoreErrorStatusOtherUsing.getIntValue(), mode.getValue());
                while (!this._cancelRequest && !this._resumeRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
                if (this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) {
                    this._connection.compulsionClose();
                    return 0;
                }
                this._resumeRequest = false;
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
        } else {
            this._resumeRequest = false;
            while ((accessStatus = this._accessManager.requestAccess()) != DeviceAccessStatus.DeviceAccessStatusConnectionSuccess) {
                TepraPrintLogger.d("PrintController.executePrint", "DeviceAccessStatusConnectionFailure");
                status = this._LWStatus.containsKey(LabelWriterStatusKeyStatus) ? this._LWStatus.get(LabelWriterStatusKeyStatus) : 0;
                errCode = this._LWStatus.containsKey(LabelWriterStatusKeyError) ? this._LWStatus.get(LabelWriterStatusKeyError) : 0;
                printCoreModelNumber = PrintCoreModelNumber.valueOf(this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(this._modelNumber);
                mode = this._commandFilter.getOperationFromStatus(DemandOperation.DemandOperationPrint, DevicePhase.DevicePhaseOccupation, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
                this._LWStatus.put(LabelWriterStatusKeyOperationStatus, mode.getValue());
                int printStatus = mode.getValue();
                if (printStatus != -6 && printStatus != -4) {
                    if (notify) {
                        this.notifyAbortPrintJob(0, printStatus);
                    }
                    this._connection.compulsionClose();
                    return 0;
                }
                this.notifySuspendPrintJob(PrintCoreErrorStatus.PrintCoreErrorStatusOtherUsing.getIntValue(), printStatus);
                while (!this._cancelRequest && !this._resumeRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
                if (this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) {
                    this._connection.compulsionClose();
                    return 0;
                }
                this._resumeRequest = false;
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
        }
        if (!this._connection.open()) {
            TepraPrintLogger.d("PrintController.executePrint", "Device Connection open error");
            if (notify) {
                this.notifyAbortPrintJob(-1, deviceStatus);
            }
            this._connection.compulsionClose();
            return -1;
        }
        this.notifyChangePrintJobPhase(2);
        TepraPrintLogger.d("PrintController.executePrint", "DeviceAccessStatusConnectionSuccess");
        this.resetPrinterWait();
        int pages = 0;
        boolean sendRaster = false;
        if (!this._accessManager.setRequestStatus()) {
            connectStatus = -6;
            TepraPrintLogger.d("PrintController.executePrint", "Request status command error");
            if (!this.isResumeJobStatus(connectStatus) && notify) {
                this.notifyAbortPrintJob(connectStatus, deviceStatus);
            }
            this.done(connectStatus, deviceStatus);
            return connectStatus;
        }
        deviceStatus = this.checkStatusForPrinting(DevicePhase.DevicePhasePrinting);
        if (deviceStatus != 0) {
            if (this._LWStatus == null || this._LWStatus.get(LabelWriterStatusKeyStatus) == null) {
                connectStatus = -6;
                if (!this.isResumeJobStatus(connectStatus) && notify) {
                    this.notifyAbortPrintJob(connectStatus, 0);
                }
            } else {
                TepraPrintLogger.d("PrintController.executePrint", "checkStatusForPrinting error: " + deviceStatus);
                connectStatus = -5;
                if (!this.isResumeJobStatus(connectStatus) && notify) {
                    this.notifyAbortPrintJob(connectStatus, deviceStatus);
                }
            }
            this.done(connectStatus, deviceStatus);
            return connectStatus;
        }
        this._printingPage = 0;
        this._drawCallback.beginJob();
        pages = this._drawCallback.getNumberOfPages();
        if (pages == 0) {
            TepraPrintLogger.w("PrintController.executePrint", "pages=" + pages);
            this.done(connectStatus, deviceStatus);
            return connectStatus;
        }
        if (!this.sendJobEnvironmentCommand()) {
            TepraPrintLogger.d("PrintController.executePrint", "send(Environment) communication error error");
            connectStatus = -6;
            if (!this.isResumeJobStatus(connectStatus) && notify) {
                this.notifyAbortPrintJob(connectStatus, deviceStatus);
            }
            this.done(connectStatus, deviceStatus);
            return connectStatus;
        }
        if (!this._accessManager.setRequestStatus()) {
            connectStatus = -6;
            TepraPrintLogger.d("PrintController.executePrint", "Request status command error");
            if (!this.isResumeJobStatus(connectStatus) && notify) {
                this.notifyAbortPrintJob(connectStatus, deviceStatus);
            }
            this.done(connectStatus, deviceStatus);
            return connectStatus;
        }
        this._copies = this._resumeCopiesNumber;
        while (this._copies < this._copiesParam) {
            TepraPrintLogger.d("PrintController.executePrint", "Print loop copies: " + this._copies);
            this._pageNumber = this._resumePageNumber;
            while (this._pageNumber <= pages) {
                TepraPrintLogger.d("PrintController.executePrint", "Print loop page No. " + this._pageNumber);
                this._jobProgress = 0.0f;
                try {
                    this._drawCallback.beginPage(this._pageNumber);
                }
                catch (Exception e) {
                    TepraPrintLogger.w("PrintController.executePrint", "Print SDK error! Illegal form data.", e);
                    this.done(connectStatus, deviceStatus);
                    return connectStatus;
                }
                int rowCount = 1024;
                int width = this.getImageHeight(this._pageNumber);
                int height = this.getImageWidth(this._pageNumber);
                if (rowCount > width) {
                    rowCount = width;
                }
                if (width <= 0 || height <= 0) {
                    TepraPrintLogger.d("PrintController.executePrint", "Print SDK error! Illegal form data.");
                    this.done(connectStatus, deviceStatus);
                    return connectStatus;
                }
                int margin = this.getContentMargin(this._pageNumber);
                if (!this.sendPageEnvironmentCommand(width, height, margin)) {
                    TepraPrintLogger.d("PrintController.executePrint", "send(Environment) communication error error");
                    connectStatus = -6;
                    if (!this.isResumeJobStatus(connectStatus) && notify) {
                        this.notifyAbortPrintJob(connectStatus, deviceStatus);
                    }
                    this.done(connectStatus, deviceStatus);
                    return connectStatus;
                }
                float step = (float)rowCount / (float)width;
                for (int startRow = 0; startRow < width; startRow += rowCount) {
                    if (startRow + rowCount > width) {
                        rowCount = width - startRow;
                    }
                    TepraPrintLogger.d("PrintController.executePrint", "banding loop row: " + startRow + ", rowCount: " + rowCount + ", width: " + width + ", step: " + Float.toString(step) + ", _jobProgress: " + Float.toString(this._jobProgress));
                    byte[] bitmapData = this.getImageData(this._pageNumber, startRow, rowCount);
                    if (bitmapData == null) {
                        this.done(connectStatus, deviceStatus);
                        return connectStatus;
                    }
                    int commandLength = 8;
                    int rasterWidth = (height + 7) / 8;
                    ByteBuffer rasterData = ByteBuffer.allocate(rowCount * (rasterWidth + 8));
                    byte[] srcBuf = new byte[height];
                    byte[] destBuf = new byte[rasterWidth];
                    for (int heightLoop = 0; heightLoop < rowCount; ++heightLoop) {
                        System.arraycopy(bitmapData, height * heightLoop, srcBuf, 0, height);
                        int result = this._commandFilter.convertBitmapToRaster(height, 1, srcBuf, destBuf);
                        if (result != 0) {
                            connectStatus = -4;
                            TepraPrintLogger.d("PrintController.executePrint", "banding loop rasterData bitmapToRaster error.");
                            if (notify) {
                                this.notifyAbortPrintJob(connectStatus, deviceStatus);
                            }
                            this.done(connectStatus, deviceStatus);
                            return connectStatus;
                        }
                        rasterData.put(this.makeRasterCommand(height));
                        rasterData.put(destBuf);
                    }
                    if (!this._connection.send(rasterData.array(), rasterData.position(), true)) {
                        connectStatus = -6;
                        if (!this.isResumeJobStatus(connectStatus)) {
                            TepraPrintLogger.d("PrintController.executePrint", "send(raster) communication error");
                            if (notify) {
                                this.notifyAbortPrintJob(connectStatus, deviceStatus);
                            }
                        }
                        this.done(connectStatus, deviceStatus);
                        return connectStatus;
                    }
                    sendRaster = true;
                    switch (this._modelNumber) {
                        case 5: 
                        case 7: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 1001: 
                        case 1101: 
                        case 1201: 
                        case 1400: {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                    deviceStatus = this.checkStatusForPrinting(DevicePhase.DevicePhasePrintProcessing);
                    if (deviceStatus != 0) {
                        if (this._LWStatus == null || this._LWStatus.get(LabelWriterStatusKeyStatus) == null) {
                            connectStatus = -6;
                            if (!this.isResumeJobStatus(connectStatus) && notify) {
                                this.notifyAbortPrintJob(connectStatus, 0);
                            }
                            this.done(connectStatus, deviceStatus);
                            return connectStatus;
                        }
                        TepraPrintLogger.d("PrintController.executePrint", "checkStatusForPrinting error: " + deviceStatus);
                        connectStatus = -5;
                        if (!this.isResumeJobStatus(connectStatus) && notify) {
                            this.notifyAbortPrintJob(connectStatus, deviceStatus);
                        }
                        this.done(connectStatus, deviceStatus);
                        return connectStatus;
                    }
                    this._jobProgress = Math.min(this._jobProgress + step, 1.0f);
                    TepraPrintLogger.d("PrintController.executePrint", "_jobProgress=" + this._jobProgress + ", step=" + step);
                    if (!this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) continue;
                    break;
                }
                if (deviceStatus != 0 || this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) break;
                this._drawCallback.endPage();
                TepraPrintLogger.d("PrintController.executePrint", "Form Feed");
                byte[] ff = new byte[]{12};
                if (!this._connection.send(ff, ff.length)) {
                    connectStatus = -6;
                    TepraPrintLogger.d("PrintController.executePrint", "send(FF) communication error error");
                    if (!this.isResumeJobStatus(connectStatus) && notify) {
                        this.notifyAbortPrintJob(-6, deviceStatus);
                    }
                    this.done(connectStatus, deviceStatus);
                    return connectStatus;
                }
                ++this._pageNumber;
            }
            if (deviceStatus != 0) {
                TepraPrintLogger.d("PrintController.executePrint", "cover error hook. CS=" + connectStatus + " / DS=" + deviceStatus);
                if (!this.isBlueToothConnection()) break;
                if (notify) {
                    this.notifyAbortPrintJob(-5, deviceStatus);
                }
                this.done(connectStatus, deviceStatus);
                return connectStatus;
            }
            if (this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) break;
            this._resumePageNumber = 1;
            ++this._copies;
        }
        this._copies = this._copiesParam - 1;
        this._pageNumber = pages;
        if (!sendRaster) {
            this.done(connectStatus, deviceStatus);
            return connectStatus;
        }
        TepraPrintLogger.d("PrintController.executePrint", "Print End check");
        this.notifyChangePrintJobPhase(3);
        if (connectStatus == 0) {
            if (!this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus) && !this._connection.send(OPERATION_SEND_PRINT_END, OPERATION_SEND_PRINT_END.length)) {
                connectStatus = -6;
                TepraPrintLogger.d("PrintController.executePrint", "send(Print End) communication error error");
                if (!this.isResumeJobStatus(connectStatus) && notify) {
                    this.notifyAbortPrintJob(connectStatus, deviceStatus);
                }
                this.done(connectStatus, deviceStatus);
                return connectStatus;
            }
            deviceStatus = this.checkStatusForAfterPrint(DevicePhase.DevicePhasePrinting);
            if (deviceStatus != 0 && !this.isResumeJobStatus(connectStatus)) {
                if (this._LWStatus == null || this._LWStatus.get(LabelWriterStatusKeyStatus) == null) {
                    connectStatus = -6;
                    if (!this.isResumeJobStatus(connectStatus) && notify) {
                        this.notifyAbortPrintJob(-6, 0);
                    }
                } else {
                    TepraPrintLogger.d("PrintController.executePrint", "checkStatusForAfterPrint error");
                    if (notify) {
                        this.notifyAbortPrintJob(-5, deviceStatus);
                    }
                }
            }
        }
        this.done(connectStatus, deviceStatus);
        return connectStatus;
    }

    private void done(int connectStatus, int deviceStatus) {
        this._drawCallback.endJob();
        TepraPrintLogger.d("PrintController.executePrint", "Print Done. CS=" + connectStatus + " / DS=" + deviceStatus);
        if (!this.isBlueToothConnection()) {
            this.checkPrintingPageForResume();
        }
        if (deviceStatus != 0 && connectStatus == 0) {
            this.resetPrinterWait();
            if (deviceStatus != 35) {
                this.idleWait();
            }
        }
        if (connectStatus != -6 && !this._accessManager.resetRequestStatus()) {
            TepraPrintLogger.d("PrintController.executePrint", "Request status command error");
            this.notifyAbortPrintJob(-6, deviceStatus);
        }
        this._connection.printProcessing = false;
        this._connection.close();
        this._accessManager.releaseAccess();
        this._jobProgress = 0.0f;
        TepraPrintLogger.d("PrintController.executePrint", "DeviceAccessStatusDisconnectionSuccess");
    }

    private int checkStatusForBeforePrint(DemandOperation operation) {
        this._LWStatus = this.printerStatusAccess();
        if (this._LWStatus == null || this._LWStatus.get(LabelWriterStatusKeyStatus) == null) {
            return -1;
        }
        if (this._LWStatus.containsKey(LabelWriterStatusKeyOperationStatus) && this._LWStatus.get(LabelWriterStatusKeyOperationStatus) == -6) {
            return -6;
        }
        if (!this._LWStatus.containsKey(LabelWriterStatusKeyTapeWidth)) {
            this._LWStatus.put(LabelWriterStatusKeyTapeWidth, 0);
        }
        if (!this._LWStatus.containsKey(LabelWriterStatusKeyTapeKind)) {
            this._LWStatus.put(LabelWriterStatusKeyTapeKind, 0);
        }
        if (!this._LWStatus.containsKey(LabelWriterStatusKeyInkRibbon)) {
            this._LWStatus.put(LabelWriterStatusKeyInkRibbon, 0);
        }
        if (!this._LWStatus.containsKey(LabelWriterStatusKeyTapeOption)) {
            this._LWStatus.put(LabelWriterStatusKeyTapeOption, 0);
        }
        if (!this._LWStatus.containsKey(LabelWriterStatusKeyOperationStatus)) {
            this._LWStatus.put(LabelWriterStatusKeyOperationStatus, 0);
        }
        int status = this._LWStatus.containsKey(LabelWriterStatusKeyStatus) ? this._LWStatus.get(LabelWriterStatusKeyStatus) : 0;
        int errCode = this._LWStatus.containsKey(LabelWriterStatusKeyError) ? this._LWStatus.get(LabelWriterStatusKeyError) : 0;
        HashMap<String, Integer> lwstatus = new HashMap<String, Integer>();
        lwstatus.put(LabelWriterStatusKeyTapeWidth, this._LWStatus.get(LabelWriterStatusKeyTapeWidth));
        lwstatus.put(LabelWriterStatusKeyTapeKind, this._LWStatus.get(LabelWriterStatusKeyTapeKind));
        lwstatus.put(LabelWriterStatusKeyInkRibbon, this._LWStatus.get(LabelWriterStatusKeyInkRibbon));
        lwstatus.put(LabelWriterStatusKeyTapeOption, this._LWStatus.get(LabelWriterStatusKeyTapeOption));
        this._commandFilter.setLwStatus(lwstatus);
        OperationMode mode = OperationMode.valueOf(0);
        if (this._resumeJob && this._lastSuspendJobStatusError == errCode && this._lastSuspendJobStatusError != 0 && operation == DemandOperation.DemandOperationPrint) {
            mode = OperationMode.OperationModeDeviceErrorReprint;
        } else {
            PrintCoreModelNumber printCoreModelNumber = PrintCoreModelNumber.valueOf(this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(this._modelNumber);
            mode = this._commandFilter.getOperationFromStatus(operation, DevicePhase.DevicePhaseIdle, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
        }
        this._LWStatus.put(LabelWriterStatusKeyOperationStatus, mode.getValue());
        return mode.getValue();
    }

    private int checkStatusForPrinting(DevicePhase phase) {
        DevicePhase ph = phase;
        if (phase == DevicePhase.DevicePhasePrintProcessing) {
            ph = DevicePhase.DevicePhasePrinting;
            this._LWStatus = this._accessManager.getPrinterStatusProcessing(this._LWStatus);
        } else {
            this._LWStatus = this._accessManager.getPrinterStatus();
        }
        if (this._LWStatus == null || !this._LWStatus.containsKey(LabelWriterStatusKeyStatus)) {
            return -1;
        }
        int status = this._LWStatus.containsKey(LabelWriterStatusKeyStatus) ? this._LWStatus.get(LabelWriterStatusKeyStatus) : 0;
        int errCode = this._LWStatus.containsKey(LabelWriterStatusKeyError) ? this._LWStatus.get(LabelWriterStatusKeyError) : 0;
        DemandOperation operation = DemandOperation.DemandOperationPrint;
        if (ph == DevicePhase.DevicePhaseTapeFeeding) {
            operation = DemandOperation.DemandOperationTapeFeed;
        }
        if (phase != DevicePhase.DevicePhasePrinting && (status == PrintCoreStatus.PrintCoreStatusFeeding.getIntValue() || status == PrintCoreStatus.PrintCoreStatusPrinting.getIntValue())) {
            this._printingPage = this._LWStatus.get(LabelWriterStatusKeyPrintPage);
            this._printStart = true;
        }
        TepraPrintLogger.d(this.TAG, "checkStatusForPrinting: ST:" + status + " ER:" + errCode + " _printingPage:" + this._printingPage);
        PrintCoreModelNumber printCoreModelNumber = PrintCoreModelNumber.valueOf(this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(this._modelNumber);
        OperationMode mode = this._commandFilter.getOperationFromStatus(operation, ph, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
        this._LWStatus.put(LabelWriterStatusKeyOperationStatus, mode.getValue());
        return mode.getValue();
    }

    private int checkStatusForAfterPrint(DevicePhase phase) {
        TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: " + phase.getIntValue());
        boolean changeStatus = false;
        boolean resetPrinter = false;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            this._LWStatus = this._accessManager.getPrinterStatusForAfterPrint();
            if (this._printing && this._accessManager.isCancelRequest(this._cancelRequest, this._LWStatus)) {
                TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: [[[CANCEL]]]");
                if (!resetPrinter) {
                    TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: ResetPrinter");
                    this.resetPrinterWait();
                    resetPrinter = true;
                    if (!this._accessManager.setRequestStatus()) {
                        TepraPrintLogger.d(this.TAG, "Request status command error");
                        return -1;
                    }
                    changeStatus = true;
                }
            }
            if (this._LWStatus == null || !this._LWStatus.containsKey(LabelWriterStatusKeyStatus)) {
                return -1;
            }
            int status = this._LWStatus.containsKey(LabelWriterStatusKeyStatus) ? this._LWStatus.get(LabelWriterStatusKeyStatus) : 0;
            int errCode = 0;
            errCode = !changeStatus ? (this._LWStatus.containsKey(LabelWriterStatusKeyError) ? this._LWStatus.get(LabelWriterStatusKeyError) : 0) : (this._LWStatus.containsKey(LabelWriterStatusKeyErrorRemain) ? this._LWStatus.get(LabelWriterStatusKeyErrorRemain) : 0);
            TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: ST:" + status + " ER:" + errCode + " Printing:" + this._printingPage);
            if (status == PrintCoreStatus.PrintCoreStatusFeeding.getIntValue() || status == PrintCoreStatus.PrintCoreStatusPrinting.getIntValue()) {
                changeStatus = true;
                this._printStart = true;
            }
            TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: _printing=" + this._printing + ", _cancelRequest=" + this._cancelRequest + ", changeStatus=" + changeStatus);
            if (changeStatus) {
                this._printingPage = this._LWStatus.get(LabelWriterStatusKeyPrintPage);
                TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: _printingPage=" + this._printingPage);
                if (status == PrintCoreStatus.PrintCoreStatusIdle.getIntValue() && errCode == PrintCoreDeviceStatus.PrintCoreDeviceStatusNoError.getIntValue()) {
                    TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: return TepraPrintStatusError.NoError");
                    return 0;
                }
                if (this._cancelRequest && status == PrintCoreStatus.PrintCoreStatusIdle.getIntValue()) {
                    TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: return TepraPrintStatusError.NoError");
                    return 0;
                }
            }
            if (errCode != PrintCoreDeviceStatus.PrintCoreDeviceStatusNoError.getIntValue() && !this._cancelRequest) {
                int numberOfPages;
                DemandOperation op = DemandOperation.DemandOperationPrint;
                if (phase == DevicePhase.DevicePhaseTapeFeeding) {
                    op = DemandOperation.DemandOperationTapeFeed;
                }
                PrintCoreModelNumber printCoreModelNumber = PrintCoreModelNumber.valueOf(this._modelNumber) == null ? PrintCoreModelNumber.PrintCoreModelNumberSR5900P : PrintCoreModelNumber.valueOf(this._modelNumber);
                OperationMode mode = this._commandFilter.getOperationFromStatus(op, phase, PrintCoreStatus.valueOf(status), PrintCoreDeviceStatus.valueOf(errCode), printCoreModelNumber);
                this._LWStatus.put(LabelWriterStatusKeyOperationStatus, mode.getValue());
                TepraPrintLogger.d(this.TAG, "checkStatusForAfterPrint: return " + mode.getValue());
                if (errCode == PrintCoreDeviceStatus.PrintCoreDeviceStatusTapeEjectError.getIntValue() && this._printing && this._drawCallback != null && (numberOfPages = this._drawCallback.getNumberOfPages()) > 0) {
                    this._printingPage = this._copiesParam * numberOfPages - 1;
                }
                return mode.getValue();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPrintingPageForResume() {
        if (this._printStart) {
            Map<String, Integer> lwStatus = this._accessManager.getPrinterStatus();
            if (lwStatus != null && lwStatus.containsKey(LabelWriterStatusKeyPrintPage)) {
                this._printingPage = lwStatus.get(LabelWriterStatusKeyPrintPage);
                TepraPrintLogger.d(this.TAG, "checkPrintingPageForResume: _printingPage=" + this._printingPage);
            }
            Object object = this.lock;
            synchronized (object) {
                this._totalPrintingPage += this._printingPage;
                this._printingPage = 0;
            }
            int numberOfPages = this._drawCallback.getNumberOfPages();
            if (numberOfPages > 0) {
                this._resumeCopiesNumber = this._totalPrintingPage / numberOfPages;
                this._resumePageNumber = this._totalPrintingPage % numberOfPages + 1;
            } else {
                this._resumeCopiesNumber = 0;
                this._resumePageNumber = 1;
            }
        }
    }

    private void resetPrinterWait() {
        TepraPrintLogger.d(this.TAG, "resetPrinterWait...");
        this._accessManager.resetPrinter();
        long start = System.currentTimeMillis();
        while (!this._accessManager.getPortStatus() && System.currentTimeMillis() - start <= 10000L) {
        }
        TepraPrintLogger.d(this.TAG, "resetPrinterWait done");
    }

    private void idleWait() {
        TepraPrintLogger.d(this.TAG, "idleWait...");
        if (!this._accessManager.setRequestStatus()) {
            TepraPrintLogger.d(this.TAG, "idleWait command error");
            return;
        }
        long start = System.currentTimeMillis();
        do {
            int status;
            Map<String, Integer> lwStatus;
            if ((lwStatus = this._accessManager.getPrinterStatus()) != null && lwStatus.containsKey(LabelWriterStatusKeyStatus) && lwStatus.get(LabelWriterStatusKeyStatus) != null && (status = lwStatus.get(LabelWriterStatusKeyStatus).intValue()) == PrintCoreStatus.PrintCoreStatusIdle.getIntValue()) {
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - start <= 10000L);
        TepraPrintLogger.d(this.TAG, "idleWait done");
    }

    private boolean waitForUserRequest(int connectionStatus) {
        int deviceStatus;
        this._resumeRequest = false;
        boolean result = false;
        this._lastSuspendJobStatusError = deviceStatus = this._LWStatus.containsKey(LabelWriterStatusKeyError) ? this._LWStatus.get(LabelWriterStatusKeyError) : 0;
        TepraPrintLogger.d(this.TAG, "waitForUserRequest: StatusErrorTapeEnd error. Page : [" + this._printingPage + "]");
        this.notifySuspendPrintJob(connectionStatus, deviceStatus);
        while (!this._cancelRequest && !this._resumeRequest) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        if (this._resumeRequest) {
            result = true;
        }
        this._resumeRequest = false;
        return result;
    }

    private boolean isResumeJobStatus(int connectionStatus) {
        boolean result = false;
        if (this._cancelRequest) {
            return result;
        }
        if (!this._resumeJobSupport) {
            return result;
        }
        if (this._LWStatus.containsKey(LabelWriterStatusKeyOperationStatus) && this._LWStatus.get(LabelWriterStatusKeyOperationStatus) != null && this._LWStatus.get(LabelWriterStatusKeyOperationStatus).intValue() == OperationMode.OperationModeReprint.getValue()) {
            result = true;
        }
        if (connectionStatus == -6) {
            result = true;
        }
        return result;
    }

    private void waitForStatusProcess() {
        long start = System.currentTimeMillis();
        while (this._statusFetching && System.currentTimeMillis() - start <= 30000L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean sendJobEnvironmentCommand() {
        boolean sendResult = true;
        byte[] control = new byte[1024];
        int size = 0;
        size = this._commandFilter.createJobEnvironmentCommand(control);
        sendResult = this._connection.send(control, size);
        return sendResult;
    }

    private boolean sendPageEnvironmentCommand(int length, int width, int margin) {
        boolean sendResult = true;
        byte[] control = new byte[1024];
        int size = 0;
        size = this._commandFilter.createPageEnvironmentCommand(control, length, width, margin, this._commandLevel);
        sendResult = this._connection.send(control, size);
        return sendResult;
    }

    private byte[] makeRasterCommand(int width) {
        int byteIndex = 0;
        byte[] rasterData = new byte[8];
        rasterData[byteIndex++] = 27;
        rasterData[byteIndex++] = 46;
        rasterData[byteIndex++] = 0;
        rasterData[byteIndex++] = 0;
        rasterData[byteIndex++] = 0;
        rasterData[byteIndex++] = 1;
        rasterData[byteIndex++] = (byte)(width & 0xFF);
        rasterData[byteIndex++] = (byte)(width >> 8 & 0xFF);
        return rasterData;
    }

    private Map<String, Integer> convertToIntegerMap(Map<String, Object> dict) {
        HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Object> e : dict.entrySet()) {
            int value;
            Object obj = e.getValue();
            if (obj instanceof Integer) {
                value = (Integer)obj;
                integerMap.put(e.getKey(), value);
                continue;
            }
            if (!(obj instanceof Boolean)) continue;
            value = (Boolean)obj != false ? 1 : 0;
            integerMap.put(e.getKey(), value);
        }
        return integerMap;
    }

    private boolean isBlueToothConnection() {
        TepraPrintLogger.d("PrintController.isBlueToothConnection", "_connection = " + this._connection.getClass().getSimpleName());
        TepraPrintLogger.d("PrintController.isBlueToothConnection", "_accessManager = " + this._accessManager.getClass().getSimpleName());
        TepraPrintLogger.d("PrintController.isBlueToothConnection", "isBlueTooth = " + (this._connection instanceof DeviceConnectionBluetooth));
        return this._connection instanceof DeviceConnectionBluetooth;
    }

    class ChangePrintJobPhaseTask
    implements Runnable {
        private int phase;

        public ChangePrintJobPhaseTask(int phase) {
            this.phase = phase;
        }

        @Override
        public void run() {
            PrintController.this.delegate.onChangePrintOperationPhase(PrintController.this.tepraPrint, this.phase);
        }
    }

    class SuspendPrintJobTask
    implements Runnable {
        private int errorStatus;
        private int deviceStatus;

        public SuspendPrintJobTask(int errorStatus, int deviceStatus) {
            this.errorStatus = errorStatus;
            this.deviceStatus = deviceStatus;
        }

        @Override
        public void run() {
            PrintController.this.delegate.onSuspendPrintOperation(PrintController.this.tepraPrint, this.errorStatus, this.deviceStatus);
        }
    }

    class AbortPrintJobTask
    implements Runnable {
        private int errorStatus;
        private int deviceStatus;

        public AbortPrintJobTask(int errorStatus, int deviceStatus) {
            this.errorStatus = errorStatus;
            this.deviceStatus = deviceStatus;
        }

        @Override
        public void run() {
            PrintController.this.delegate.onAbortPrintOperation(PrintController.this.tepraPrint, this.errorStatus, this.deviceStatus);
        }
    }

    class ChangeTapeFeedJobPhaseTask
    implements Runnable {
        private int phase;

        public ChangeTapeFeedJobPhaseTask(int phase) {
            this.phase = phase;
        }

        @Override
        public void run() {
            PrintController.this.delegate.onChangeTapeFeedOperationPhase(PrintController.this.tepraPrint, this.phase);
        }
    }

    class AbortTapeFeedJobPhaseTask
    implements Runnable {
        private int errorStatus;
        private int deviceStatus;

        public AbortTapeFeedJobPhaseTask(int errorStatus, int deviceStatus) {
            this.errorStatus = errorStatus;
            this.deviceStatus = deviceStatus;
        }

        @Override
        public void run() {
            PrintController.this.delegate.onAbortTapeFeedOperation(PrintController.this.tepraPrint, this.errorStatus, this.deviceStatus);
        }
    }
}

