/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.UUID;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;

public class DeviceManagerBluetooth {
    private final String TAG = this.getClass().getSimpleName();
    private static final UUID SPP_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int RETRY_COUNT = 2;
    private static final boolean SECURE_CONNECT = false;
    private BluetoothAdapter _btAdapter;
    private BluetoothSocket _socket;
    private InputStream _in;
    private OutputStream _out;
    private boolean _connected = false;
    DeviceConnection deviceConnection;

    public DeviceManagerBluetooth(DeviceConnection deviceConnection) {
        this.deviceConnection = deviceConnection;
        this._btAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public synchronized boolean connect(BluetoothDevice device) {
        int i;
        TepraPrintLogger.d(this.TAG, "connect to: " + device);
        boolean connected = false;
        for (i = 0; i < 2; ++i) {
            TepraPrintLogger.d(this.TAG, "BluetoothSocket: Insecure connect[" + (i + 1) + "]...");
            if (this.connectWithNoReflection(device, false)) {
                connected = true;
                break;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!connected) {
            for (i = 0; i < 2; ++i) {
                TepraPrintLogger.d(this.TAG, "BluetoothSocket(reflect): Insecure connect[" + (i + 1) + "]...");
                if (this.connectWithReflection(device, false)) {
                    connected = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!connected) {
            this.close();
            return false;
        }
        try {
            this._in = new BufferedInputStream(this._socket.getInputStream());
            this._out = new BufferedOutputStream(this._socket.getOutputStream());
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "sockets not created", e);
            this.close();
            return false;
        }
        this._connected = true;
        return true;
    }

    private boolean connectWithNoReflection(BluetoothDevice device, boolean secure) {
        try {
            this._socket = secure ? device.createRfcommSocketToServiceRecord(SPP_UUID) : device.createInsecureRfcommSocketToServiceRecord(SPP_UUID);
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "BluetoothSocket create failed", e);
            return false;
        }
        return this.doConnect();
    }

    private boolean connectWithReflection(BluetoothDevice device, boolean secure) {
        try {
            if (secure) {
                Method m = device.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this._socket = (BluetoothSocket)m.invoke((Object)device, 1);
            } else {
                Method m = device.getClass().getMethod("createInsecureRfcommSocket", Integer.TYPE);
                this._socket = (BluetoothSocket)m.invoke((Object)device, 1);
            }
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "BluetoothSocket(reflection) create failed", e);
            return false;
        }
        return this.doConnect();
    }

    private boolean doConnect() {
        try {
            if (this._btAdapter == null || !this._btAdapter.isEnabled()) {
                return false;
            }
            if (this._btAdapter.isDiscovering()) {
                this._btAdapter.cancelDiscovery();
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            return false;
        }
        ConnectMonitoringThread runner = new ConnectMonitoringThread(this._socket, 10000);
        Thread countThread = new Thread(runner);
        countThread.start();
        try {
            this._socket.connect();
            TepraPrintLogger.d(this.TAG, "BluetoothSocket connected.");
            runner.setSocketConnected();
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "Connection failed: adderss=" + this._socket.getRemoteDevice().getAddress(), e);
            runner.setSocketFailed();
            this.close();
            return false;
        }
        if (runner.isClosed()) {
            TepraPrintLogger.d(this.TAG, "Bluetooth socket connect failed.");
            this.close();
            return false;
        }
        return true;
    }

    private boolean pairDevice(BluetoothDevice device) {
        TepraPrintLogger.d(this.TAG, "Start Pairing...");
        try {
            Method createBond = device.getClass().getMethod("createBond", new Class[0]);
            Boolean result = (Boolean)createBond.invoke((Object)device, new Object[0]);
            if (!result.booleanValue()) {
                TepraPrintLogger.d(this.TAG, "Pairing createBond failed.");
                return false;
            }
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "Pairing failed.", e);
            return false;
        }
        TepraPrintLogger.d(this.TAG, "Pairing finished.");
        return true;
    }

    public boolean write(byte[] buf, int timeout) {
        boolean result = false;
        if (this._out == null) {
            return result;
        }
        WriteMonitoringThread runner = new WriteMonitoringThread(this._socket, timeout);
        Thread countThread = new Thread(runner);
        countThread.start();
        try {
            TepraPrintLogger.d(this.TAG, "write(" + buf.length + "):" + new String(buf) + "[ " + TepraPrintUtil.toHexString(buf) + " ]");
            this._out.write(buf);
            this._out.flush();
            runner.setSocketWrite();
            result = true;
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "Exception during write", e);
            runner.setSocketWriteError();
        }
        if (runner.isClosed()) {
            TepraPrintLogger.d(this.TAG, "BluetoothSocket write error.");
            result = false;
        }
        return result;
    }

    public byte[] read(int length, int timeout) {
        if (this._in == null) {
            return new byte[0];
        }
        byte[] msg = new byte[length];
        int totalBytesRcvd = 0;
        while (totalBytesRcvd < length) {
            int bytesRcvd;
            ReadMonitoringThread runner = new ReadMonitoringThread(this._socket, timeout);
            Thread countThread = new Thread(runner);
            countThread.start();
            try {
                TepraPrintLogger.d(this.TAG, "Now data reading...");
                bytesRcvd = this._in.read(msg, totalBytesRcvd, length - totalBytesRcvd);
                if (bytesRcvd == -1) {
                    TepraPrintLogger.w(this.TAG, "Error during read");
                    runner.setSocketReadError();
                    return new byte[0];
                }
                runner.setSocketRead();
            }
            catch (Exception e) {
                TepraPrintLogger.w(this.TAG, "Exception during read", e);
                runner.setSocketReadError();
                return new byte[0];
            }
            TepraPrintLogger.d(this.TAG, "data received(" + (totalBytesRcvd += bytesRcvd) + " / " + length + ")");
        }
        return msg;
    }

    public byte[] readAll(int timeout) {
        if (this._in == null) {
            return null;
        }
        int length = 0;
        try {
            length = this._in.available();
        }
        catch (IOException e) {
            return null;
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] msg = new byte[length];
        int totalBytesRcvd = 0;
        while (totalBytesRcvd < length) {
            int bytesRcvd;
            ReadMonitoringThread runner = new ReadMonitoringThread(this._socket, timeout);
            Thread countThread = new Thread(runner);
            countThread.start();
            try {
                TepraPrintLogger.d(this.TAG, "Now data reading[" + length + "]...");
                bytesRcvd = this._in.read(msg, totalBytesRcvd, length - totalBytesRcvd);
                if (bytesRcvd == -1) {
                    TepraPrintLogger.w(this.TAG, "Error during read");
                    runner.setSocketReadError();
                    return null;
                }
                runner.setSocketRead();
            }
            catch (Exception e) {
                TepraPrintLogger.w(this.TAG, "Exception during read", e);
                runner.setSocketReadError();
                return null;
            }
            TepraPrintLogger.d(this.TAG, "data received(" + (totalBytesRcvd += bytesRcvd) + " / " + length + ")");
        }
        return msg;
    }

    public synchronized boolean close() {
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._out = null;
        }
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._in = null;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._socket = null;
        }
        TepraPrintLogger.d(this.TAG, "BluetoothSocket closed.");
        this._connected = false;
        return true;
    }

    public boolean isConnected() {
        return this._connected;
    }

    private class ConnectMonitoringThread
    implements Runnable {
        private volatile boolean didSocketConnect = false;
        private volatile boolean socketConnectFailed = false;
        private volatile boolean mClosed = false;
        private BluetoothSocket socket;
        private int timeout;

        public ConnectMonitoringThread(BluetoothSocket socket, int timeout) {
            this.socket = socket;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            while ((long)this.timeout > System.currentTimeMillis() - start && !this.didSocketConnect && !this.socketConnectFailed) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (!this.didSocketConnect && !this.socketConnectFailed) {
                this.mClosed = true;
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "Reached Timeout and socket not open.");
            } else if (!this.didSocketConnect && this.socketConnectFailed) {
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "socket connect failed");
            } else {
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "Connected Before Timeout Thread Hit");
            }
        }

        public void setSocketConnected() {
            this.didSocketConnect = true;
        }

        public void setSocketFailed() {
            this.socketConnectFailed = true;
        }

        public boolean isClosed() {
            return this.mClosed;
        }
    }

    private class WriteMonitoringThread
    implements Runnable {
        private volatile boolean didSocketWrite = false;
        private volatile boolean socketWriteError = false;
        private volatile boolean mClosed = false;
        private BluetoothSocket socket;
        private int timeout;

        public WriteMonitoringThread(BluetoothSocket socket, int timeout) {
            this.socket = socket;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            while ((long)this.timeout > System.currentTimeMillis() - start && !this.didSocketWrite && !this.socketWriteError) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (!this.didSocketWrite && !this.socketWriteError) {
                this.mClosed = true;
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "Reached write timeout.");
                DeviceManagerBluetooth.this.close();
            } else if (!this.didSocketWrite && this.socketWriteError) {
                this.mClosed = true;
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "socket write error");
                DeviceManagerBluetooth.this.close();
            } else {
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "Write Before Timeout Thread Hit");
            }
        }

        public void setSocketWrite() {
            this.didSocketWrite = true;
        }

        public void setSocketWriteError() {
            this.socketWriteError = true;
        }

        public boolean isClosed() {
            return this.mClosed;
        }
    }

    private class ReadMonitoringThread
    implements Runnable {
        private volatile boolean didSocketRead = false;
        private volatile boolean socketReadError = false;
        private BluetoothSocket socket;
        private int timeout;

        public ReadMonitoringThread(BluetoothSocket socket, int timeout) {
            this.socket = socket;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            while ((long)this.timeout > System.currentTimeMillis() - start && !this.didSocketRead && !this.socketReadError) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (!this.didSocketRead && !this.socketReadError) {
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "Reached read timeout.");
                DeviceManagerBluetooth.this.close();
            } else if (!this.didSocketRead && this.socketReadError) {
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "socket read error");
                DeviceManagerBluetooth.this.close();
            } else {
                TepraPrintLogger.d(DeviceManagerBluetooth.this.TAG, "Read Before Timeout Thread Hit");
            }
        }

        public void setSocketRead() {
            this.didSocketRead = true;
        }

        public void setSocketReadError() {
            this.socketReadError = true;
        }
    }
}

