/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import jp.co.kingjim.tepraprint.sdk.TepraPrint;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;

public class DeviceManagerBLE {
    private final String TAG = this.getClass().getSimpleName();
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int DISCONNECT_TIMEOUT = 10000;
    private static final int RETRY_COUNT = 2;
    private static final int REQUEST_MTU_SIZE = 247;
    private ConnectionState _connectionState = ConnectionState.DISCONNECTED;
    private final Object _connectLock = new Object();
    private final Object _readLock = new Object();
    private final Object _writeLock = new Object();
    private Context _context;
    private BluetoothAdapter _bluetoothAdapter;
    private BluetoothDevice _connectDevice;
    private BluetoothGatt _bluetoothGatt;
    private BluetoothGattService _dspsService;
    private BluetoothGattCharacteristic _txCharacteristic;
    private BluetoothGattCharacteristic _rxCharacteristic;
    private BluetoothGattCharacteristic _fcCharacteristic;
    private LinkedList<GattOperation> _gattQueue = new LinkedList();
    private GattOperation _gattOperationPending;
    private ArrayList<BluetoothGattCharacteristic> _pendingEnableNotifications;
    private LinkedList<byte[]> _readValues = new LinkedList();
    private boolean _canWrite = false;
    private boolean _isReconnected = false;
    private boolean _flowControlOn = true;
    private int _mtu = 23;
    private int _chunkSize = 0;
    private int _totalWriteLength = 0;
    private int _totalPendingLength = 0;
    private volatile long _lastConnectedTime = 0L;
    DeviceConnection _deviceConnection;
    private final BluetoothGattCallback _bluetoothGattCallback = new BluetoothGattCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            Object object = DeviceManagerBLE.this._connectLock;
            // MONITORENTER : object
            try {
                if (!DeviceManagerBLE.this._bluetoothGatt.getDevice().equals((Object)DeviceManagerBLE.this._connectDevice)) {
                    TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "Unknown device: " + DeviceManagerBLE.this._bluetoothGatt.getDevice().getAddress());
                    return;
                }
                switch (newState) {
                    case 1: {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onConnectionStateChange: STATE_CONNECTING status = " + status);
                        DeviceManagerBLE.this.setConnectionState(ConnectionState.CONNECTING);
                        return;
                    }
                    case 2: {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onConnectionStateChange: STATE_CONNECTED");
                        DeviceManagerBLE.this.setConnectionState(ConnectionState.CONNECTED);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "Thread was interrupted: " + e);
                        }
                        if (DeviceManagerBLE.this._bluetoothGatt == null) return;
                        DeviceManagerBLE.this._bluetoothGatt.discoverServices();
                        return;
                    }
                    case 3: {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onConnectionStateChange: STATE_DISCONNECTING status = " + status);
                        DeviceManagerBLE.this.setConnectionState(ConnectionState.DISCONNECTING);
                        return;
                    }
                    case 0: {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onConnectionStateChange: STATE_DISCONNECTED status = " + status);
                        if (status != 0 && DeviceManagerBLE.this.isConnected() && !DeviceManagerBLE.this._canWrite && !DeviceManagerBLE.this._isReconnected) {
                            DeviceManagerBLE.this.reconnect(DeviceManagerBLE.this._bluetoothGatt.getDevice());
                        }
                        DeviceManagerBLE.this.setConnectionState(ConnectionState.DISCONNECTED);
                        return;
                    }
                    default: {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onConnectionStateChange: Unknown state = " + newState + " status = " + status);
                        return;
                    }
                }
            }
            finally {
                DeviceManagerBLE.this._connectLock.notify();
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onServicesDiscovered: Services successfully discovered");
                DeviceManagerBLE.this._pendingEnableNotifications = new ArrayList();
                DeviceManagerBLE.this._dspsService = DeviceManagerBLE.this._bluetoothGatt.getService(Uuid.DSPS_SERVICE);
                if (DeviceManagerBLE.this._dspsService != null) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "DSPS Service successfully discovered: [" + DeviceManagerBLE.this._dspsService.getUuid() + "]");
                    DeviceManagerBLE.this._txCharacteristic = DeviceManagerBLE.this._dspsService.getCharacteristic(Uuid.TX_CHARACTERISTIC);
                    if (DeviceManagerBLE.this._txCharacteristic != null) {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "TX Characteristic successfully discovered: [" + DeviceManagerBLE.this._txCharacteristic.getUuid() + "]");
                    } else {
                        TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "Missing DSPS TX characteristic");
                    }
                    DeviceManagerBLE.this._rxCharacteristic = DeviceManagerBLE.this._dspsService.getCharacteristic(Uuid.RX_CHARACTERISTIC);
                    if (DeviceManagerBLE.this._rxCharacteristic != null) {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "RX Characteristic successfully discovered: [" + DeviceManagerBLE.this._rxCharacteristic.getUuid() + "]");
                    } else {
                        TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "Missing DSPS RX characteristic");
                    }
                    DeviceManagerBLE.this._fcCharacteristic = DeviceManagerBLE.this._dspsService.getCharacteristic(Uuid.FLOW_CONTROL_CHARACTERISTIC);
                    if (DeviceManagerBLE.this._fcCharacteristic != null) {
                        TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "FC Characteristic successfully discovered: [" + DeviceManagerBLE.this._fcCharacteristic.getUuid() + "]");
                    } else {
                        TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "Missing DSPS FC characteristic");
                    }
                    if (DeviceManagerBLE.this._txCharacteristic != null && DeviceManagerBLE.this._rxCharacteristic != null && DeviceManagerBLE.this._fcCharacteristic != null) {
                        DeviceManagerBLE.this._pendingEnableNotifications.add(DeviceManagerBLE.this._txCharacteristic);
                        DeviceManagerBLE.this._pendingEnableNotifications.add(DeviceManagerBLE.this._fcCharacteristic);
                    }
                    if (DeviceManagerBLE.this._mtu != 247) {
                        DeviceManagerBLE.this.requestMtu(247);
                    }
                    if (!DeviceManagerBLE.this._pendingEnableNotifications.isEmpty()) {
                        for (BluetoothGattCharacteristic characteristic : DeviceManagerBLE.this._pendingEnableNotifications) {
                            DeviceManagerBLE.this.enableNotifications(characteristic);
                        }
                    } else {
                        DeviceManagerBLE.this._pendingEnableNotifications = null;
                    }
                    DeviceManagerBLE.this.setConnectionState(ConnectionState.CONNECTED);
                } else {
                    TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "DSPS service not found");
                }
            } else {
                TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "onServicesDiscovered received: " + status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                if (characteristic.equals(DeviceManagerBLE.this._txCharacteristic)) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onCharacteristicWrite: TX [" + characteristic.getUuid() + "] " + characteristic.getValue().length + " byte: " + TepraPrintUtil.toHexString(characteristic.getValue()));
                } else if (characteristic.equals(DeviceManagerBLE.this._rxCharacteristic)) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onCharacteristicWrite: RX [" + characteristic.getUuid() + "] " + characteristic.getValue().length + " byte: " + TepraPrintUtil.toHexString(characteristic.getValue()));
                } else if (characteristic.equals(DeviceManagerBLE.this._fcCharacteristic)) {
                    Object object = DeviceManagerBLE.this._writeLock;
                    synchronized (object) {
                        try {
                            TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onCharacteristicWrite: FC [" + characteristic.getUuid() + "] " + characteristic.getValue().length + " byte: " + TepraPrintUtil.toHexString(characteristic.getValue()));
                            DeviceManagerBLE.this._canWrite = true;
                        }
                        finally {
                            DeviceManagerBLE.this._writeLock.notify();
                        }
                    }
                    DeviceManagerBLE.this.dequeueGattOperation();
                }
            } else {
                TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "onCharacteristicWrite: Failed with status: " + status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] receivedData = characteristic.getValue();
            if (characteristic.equals(DeviceManagerBLE.this._txCharacteristic)) {
                Object object = DeviceManagerBLE.this._readLock;
                synchronized (object) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onCharacteristicChanged: TX [" + characteristic.getUuid() + "] " + receivedData.length + " byte: " + TepraPrintUtil.toHexString(receivedData));
                    try {
                        if (DeviceManagerBLE.this._readValues.isEmpty() || DeviceManagerBLE.this._readValues.getLast() != receivedData) {
                            DeviceManagerBLE.this._readValues.add(receivedData);
                        }
                    }
                    finally {
                        DeviceManagerBLE.this._readLock.notify();
                    }
                }
            }
            if (characteristic.equals(DeviceManagerBLE.this._rxCharacteristic)) {
                TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onCharacteristicChanged: RX [" + characteristic.getUuid() + "] " + receivedData.length + " byte: " + TepraPrintUtil.toHexString(receivedData));
            } else if (characteristic.equals(DeviceManagerBLE.this._fcCharacteristic)) {
                TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onCharacteristicChanged: FC [" + characteristic.getUuid() + "] " + receivedData.length + " byte: " + TepraPrintUtil.toHexString(receivedData));
                DeviceManagerBLE.this.onDspsFlowControl(characteristic.getValue());
            } else {
                TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "onCharacteristicChanged: No Notification");
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                if (descriptor.getCharacteristic().equals(DeviceManagerBLE.this._txCharacteristic)) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onDescriptorWrite: TX [" + descriptor.getUuid() + "] value: " + TepraPrintUtil.toHexString(descriptor.getValue()));
                } else if (descriptor.getCharacteristic().equals(DeviceManagerBLE.this._rxCharacteristic)) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onDescriptorWrite: RX [" + descriptor.getUuid() + "] value: " + TepraPrintUtil.toHexString(descriptor.getValue()));
                } else if (descriptor.getCharacteristic().equals(DeviceManagerBLE.this._fcCharacteristic)) {
                    TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onDescriptorWrite: FC [" + descriptor.getUuid() + "] value: " + TepraPrintUtil.toHexString(descriptor.getValue()));
                }
                if (DeviceManagerBLE.this._pendingEnableNotifications != null) {
                    DeviceManagerBLE.this._pendingEnableNotifications.remove(descriptor.getCharacteristic());
                    if (DeviceManagerBLE.this._pendingEnableNotifications.isEmpty()) {
                        DeviceManagerBLE.this._pendingEnableNotifications = null;
                        DeviceManagerBLE.this.onDeviceReady();
                    }
                }
                DeviceManagerBLE.this.dequeueGattOperation();
            } else {
                TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "onDescriptorWrite: Failed with status: " + status);
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            if (status == 0) {
                TepraPrintLogger.d(DeviceManagerBLE.this.TAG, "onMtuChanged: MTU size changed to " + mtu);
                DeviceManagerBLE.this._mtu = mtu;
                DeviceManagerBLE.this._chunkSize = mtu - 3;
                if (DeviceManagerBLE.this._gattOperationPending.getType() == GattOperation.Type.MtuRequest) {
                    DeviceManagerBLE.this.dequeueGattOperation();
                }
            } else {
                TepraPrintLogger.e(DeviceManagerBLE.this.TAG, "onMtuChanged: Failed to change MTU size, current MTU: " + DeviceManagerBLE.this._mtu);
            }
        }
    };

    public DeviceManagerBLE(DeviceConnection deviceConnection) {
        this._deviceConnection = deviceConnection;
        this._context = new TepraPrint(this._context).getContext();
        this._bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    private void onDeviceReady() {
        if (this._fcCharacteristic != null) {
            byte[] value = new byte[]{1};
            int length = value.length;
            this.writeCharacteristic(this._fcCharacteristic, value);
            this._totalPendingLength += length;
            TepraPrintLogger.d(this.TAG, String.format(Locale.US, "Pending: %s Total: %d bytes: %s", length, this._totalPendingLength, TepraPrintUtil.toHexString(value)));
        } else {
            TepraPrintLogger.e(this.TAG, "FC characteristic is null");
        }
    }

    private synchronized void onDspsFlowControl(byte[] data) {
        int value = data.length > 0 ? data[0] : Integer.MIN_VALUE;
        switch (value) {
            case 1: {
                this._flowControlOn = true;
                break;
            }
            case 2: {
                this._flowControlOn = false;
                break;
            }
            default: {
                TepraPrintLogger.d(this.TAG, "Invalid flow control value: " + value);
                return;
            }
        }
        TepraPrintLogger.d(this.TAG, "onDspsFlowControl: Flow control = " + (this._flowControlOn ? "ON" : "OFF"));
    }

    public synchronized boolean connect(BluetoothDevice device) {
        int i;
        TepraPrintLogger.d(this.TAG, "connect to: " + device);
        boolean connected = false;
        for (i = 0; i < 2; ++i) {
            TepraPrintLogger.d(this.TAG, "BluetoothGatt: connect[" + (i + 1) + "]...");
            if (this.connectWithReflection(device, false)) {
                connected = true;
                break;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception e) {
                TepraPrintLogger.e(this.TAG, "Thread was interrupted: " + e);
            }
        }
        if (!connected) {
            for (i = 0; i < 2; ++i) {
                TepraPrintLogger.d(this.TAG, "BluetoothGatt(reflection): connect[" + (i + 1) + "]...");
                if (this.connectWithReflection(device, true)) {
                    connected = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (Exception e) {
                    TepraPrintLogger.e(this.TAG, "Thread was interrupted: " + e);
                }
            }
        }
        if (!connected) {
            this.disconnect();
            return false;
        }
        this._lastConnectedTime = System.currentTimeMillis();
        return true;
    }

    public boolean connectWithReflection(BluetoothDevice device, boolean useReflection) {
        this.setConnectionState(ConnectionState.CONNECTING);
        if (useReflection) {
            if (this._bluetoothGatt != null) {
                try {
                    Method refreshMethod = this._bluetoothGatt.getClass().getMethod("refresh", new Class[0]);
                    refreshMethod.invoke((Object)this._bluetoothGatt, new Object[0]);
                    TepraPrintLogger.d(this.TAG, "Successfully invoked refresh method using reflection");
                }
                catch (Exception e) {
                    TepraPrintLogger.e(this.TAG, "Reflection error" + e);
                }
            } else {
                TepraPrintLogger.e(this.TAG, "Skipping reflection: BluetoothGatt is null.");
            }
        } else {
            TepraPrintLogger.d(this.TAG, "Skipping reflection: useReflection = false");
        }
        return this.doConnect(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect(BluetoothDevice device) {
        try {
            if (this.isBluetoothDisabled()) {
                TepraPrintLogger.e(this.TAG, "Bluetooth is not available");
                return false;
            }
        }
        catch (Exception e) {
            TepraPrintLogger.e(this.TAG, "doConnect exception" + e);
            return false;
        }
        Object object = this._connectLock;
        synchronized (object) {
            this._connectDevice = device;
            if (this._bluetoothGatt != null) {
                this._bluetoothGatt.close();
                this._bluetoothGatt = null;
            }
            this._bluetoothGatt = device.connectGatt(this._context, false, this._bluetoothGattCallback, 2);
            try {
                this._connectLock.wait(10000L);
            }
            catch (InterruptedException e) {
                TepraPrintLogger.e(this.TAG, "Thread interrupted while waiting for connection", e);
                return false;
            }
            if (this.isConnected()) {
                TepraPrintLogger.d(this.TAG, "Connected successfully");
                return true;
            }
            TepraPrintLogger.e(this.TAG, "Failed to connect");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(BluetoothDevice device) {
        TepraPrintLogger.d(this.TAG, "reconnect to: " + device);
        if (this._lastConnectedTime != 0L && System.currentTimeMillis() - this._lastConnectedTime + 10000L < 20000L) {
            Object object = this._connectLock;
            synchronized (object) {
                this.cleanup();
                this._isReconnected = true;
                this._connectDevice = device;
                this._bluetoothGatt = device.connectGatt(this._context, false, this._bluetoothGattCallback, 2);
                try {
                    this._connectLock.wait(10000L);
                }
                catch (InterruptedException e) {
                    TepraPrintLogger.e(this.TAG, "Thread interrupted while waiting for reconnection", e);
                }
                if (this.isConnected()) {
                    TepraPrintLogger.d(this.TAG, "Reconnected successfully");
                } else {
                    TepraPrintLogger.e(this.TAG, "Failed to reconnect");
                }
            }
        }
        TepraPrintLogger.d(this.TAG, "Skipping reconnection");
    }

    private void enableNotifications(BluetoothGattCharacteristic characteristic) {
        BluetoothGattDescriptor ccc = characteristic.getDescriptor(Uuid.CLIENT_CHARACTERISTIC_CONFIGURATION_DESCRIPTOR);
        if (ccc == null) {
            TepraPrintLogger.e(this.TAG, "Missing client configuration descriptor: " + characteristic.getUuid());
            return;
        }
        boolean notify = (characteristic.getProperties() & 0x10) != 0;
        byte[] value = notify ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
        TepraPrintLogger.d(this.TAG, "Enable " + (notify ? "notifications" : "indications") + ": " + characteristic.getUuid());
        this._bluetoothGatt.setCharacteristicNotification(characteristic, true);
        this.writeDescriptor(ccc, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(byte[] buf, int timeout) {
        if (!this._canWrite) {
            Object object = this._writeLock;
            synchronized (object) {
                try {
                    this._writeLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    TepraPrintLogger.e(this.TAG, "Thread interrupted while waiting for write completion", e);
                    return false;
                }
                if (!this._canWrite) {
                    TepraPrintLogger.e("Failed to complete writing within timeout");
                    return false;
                }
                TepraPrintLogger.d("FC Writing completed successfully");
            }
        }
        if (!this.isConnected() || this._rxCharacteristic == null) {
            TepraPrintLogger.e(this.TAG, "Device is not connected or RX characteristic is null");
            return false;
        }
        for (int i = 0; i < buf.length; i += this._chunkSize) {
            int bytesToCopy = Math.min(this._chunkSize, buf.length - i);
            byte[] packet = new byte[bytesToCopy];
            System.arraycopy(buf, i, packet, 0, bytesToCopy);
            this._totalPendingLength += packet.length;
            TepraPrintLogger.d(this.TAG, String.format(Locale.US, "Pending: %s Total: %d bytes: %s", bytesToCopy, this._totalPendingLength, TepraPrintUtil.toHexString(packet)));
            this.writeCharacteristic(this._rxCharacteristic, packet);
        }
        while (true) {
            if (this.isBluetoothDisabled()) {
                TepraPrintLogger.e(this.TAG, "Bluetooth is not available");
                return false;
            }
            if (!this.isConnected()) {
                return false;
            }
            if (this._gattQueue.isEmpty()) break;
            if (this._flowControlOn) {
                this.dequeueGattOperation();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                TepraPrintLogger.e(this.TAG, "Thread was interrupted: " + e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAll(int timeout) {
        if (!this.isConnected() || this._txCharacteristic == null) {
            TepraPrintLogger.e(this.TAG, "Device is not connected or TX characteristic is null");
            return null;
        }
        Object object = this._readLock;
        synchronized (object) {
            try {
                if (this._readValues.isEmpty()) {
                    this._readLock.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                TepraPrintLogger.e(this.TAG, "Thread interrupted while waiting for received data", e);
                return null;
            }
            if (!this._readValues.isEmpty()) {
                TepraPrintLogger.d(this.TAG, "Receive data from TX Characteristic");
                return this._readValues.poll();
            }
            TepraPrintLogger.e(this.TAG, "No received data within timeout");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this._connectLock;
        synchronized (object) {
            this.setConnectionState(ConnectionState.DISCONNECTING);
            if (this._bluetoothGatt != null) {
                this._bluetoothGatt.disconnect();
            }
            try {
                this._connectLock.wait(10000L);
            }
            catch (InterruptedException e) {
                TepraPrintLogger.e(this.TAG, "Disconnection interrupted", e);
            }
            if (this._connectionState == ConnectionState.DISCONNECTED) {
                TepraPrintLogger.d(this.TAG, "Disconnected successfully");
            } else {
                TepraPrintLogger.e(this.TAG, "Failed to disconnect");
            }
            this.cleanup();
        }
    }

    private void cleanup() {
        this._connectDevice = null;
        this._dspsService = null;
        this._txCharacteristic = null;
        this._rxCharacteristic = null;
        this._fcCharacteristic = null;
        if (this._readValues != null) {
            this._readValues.clear();
        }
        this._canWrite = false;
        this._isReconnected = false;
        this._flowControlOn = true;
        this._mtu = 23;
        this._chunkSize = 0;
        this._totalWriteLength = 0;
        this._totalPendingLength = 0;
        this._lastConnectedTime = 0L;
        this._gattOperationPending = null;
        if (this._gattQueue != null) {
            this._gattQueue.clear();
        }
        if (this._pendingEnableNotifications != null) {
            this._pendingEnableNotifications.clear();
        }
        if (this._bluetoothGatt != null) {
            this._bluetoothGatt.close();
        }
        this._bluetoothGatt = null;
    }

    public void setConnectionState(ConnectionState newState) {
        this._connectionState = newState;
    }

    public boolean isConnected() {
        return this._connectionState == ConnectionState.CONNECTED;
    }

    private boolean isBluetoothDisabled() {
        return this._bluetoothAdapter == null || !this._bluetoothAdapter.isEnabled();
    }

    private synchronized void enqueueGattOperation(GattOperation operation) {
        if (this._bluetoothGatt == null) {
            return;
        }
        if (this._gattOperationPending != null) {
            this._gattQueue.add(operation);
        } else {
            this.executeGattOperation(operation);
        }
    }

    private synchronized void enqueueGattOperationWithPriority(GattOperation operation) {
        if (this._bluetoothGatt == null) {
            return;
        }
        this._gattQueue.addFirst(operation);
    }

    private synchronized void dequeueGattOperation() {
        this._gattOperationPending = null;
        if (this._gattQueue.isEmpty()) {
            return;
        }
        this.executeGattOperation(Objects.requireNonNull(this._gattQueue.poll()));
    }

    private void executeGattOperation(GattOperation operation) {
        TepraPrintLogger.d(this.TAG, "executeGattOperation: " + (Object)((Object)operation.type));
        this._gattOperationPending = operation;
        switch (operation.getType()) {
            case WriteCharacteristic: {
                this.executeWriteCharacteristic(operation.getCharacteristic());
                break;
            }
            case WriteDescriptor: {
                this.executeWriteDescriptor(operation.getDescriptor());
                break;
            }
            case MtuRequest: {
                this.executeMtuRequest(ByteBuffer.wrap(operation.getValue()).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF);
            }
        }
    }

    private void executeWriteCharacteristic(BluetoothGattCharacteristic characteristic) {
        byte[] packet = this._gattOperationPending.getValue();
        if (packet == null) {
            TepraPrintLogger.e(this.TAG, "Packet is null");
            return;
        }
        this._totalWriteLength += packet.length;
        TepraPrintLogger.d(this.TAG, String.format(Locale.US, "Writing: %d Total: %d bytes: %s", packet.length, this._totalWriteLength, TepraPrintUtil.toHexString(packet)));
        characteristic.setValue(packet);
        characteristic.setWriteType(1);
        if (!this._bluetoothGatt.writeCharacteristic(characteristic)) {
            TepraPrintLogger.e(this.TAG, "Error writing characteristic: " + characteristic.getUuid());
            this.retryWriteCharacteristic(characteristic, packet);
        }
    }

    private void executeWriteDescriptor(BluetoothGattDescriptor descriptor) {
        byte[] value = this._gattOperationPending.getValue();
        if (value == null) {
            TepraPrintLogger.e(this.TAG, "Descriptor value is null");
            return;
        }
        descriptor.setValue(value);
        if (!this._bluetoothGatt.writeDescriptor(descriptor)) {
            TepraPrintLogger.e(this.TAG, "Error writing descriptor: " + descriptor.getCharacteristic().getUuid() + " " + descriptor.getUuid());
            if (this._pendingEnableNotifications.contains(descriptor.getCharacteristic())) {
                this.dequeueGattOperation();
            }
        }
    }

    private void executeMtuRequest(int mtu) {
        if (!this._bluetoothGatt.requestMtu(mtu)) {
            TepraPrintLogger.e(this.TAG, "MTU request error");
            this.dequeueGattOperation();
        }
    }

    public void writeCharacteristic(BluetoothGattCharacteristic characteristic, byte[] value) {
        this.enqueueGattOperation(new GattOperation(characteristic, value));
    }

    public void retryWriteCharacteristic(BluetoothGattCharacteristic characteristic, byte[] value) {
        TepraPrintLogger.d(this.TAG, "Retry writing characteristic");
        this.enqueueGattOperationWithPriority(new GattOperation(characteristic, value));
    }

    private void writeDescriptor(BluetoothGattDescriptor descriptor, byte[] value) {
        this.enqueueGattOperation(new GattOperation(descriptor, value));
    }

    public void requestMtu(int mtu) {
        this.enqueueGattOperation(new GattOperation(mtu));
    }

    private static class GattOperation {
        private Type type;
        private Object gattObject;
        private byte[] value;

        public GattOperation(Object gattObject, byte[] value) {
            this.gattObject = gattObject;
            this.type = gattObject instanceof BluetoothGattCharacteristic ? Type.WriteCharacteristic : Type.WriteDescriptor;
            this.value = (byte[])value.clone();
        }

        public GattOperation(int mtu) {
            this.type = Type.MtuRequest;
            this.value = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)mtu).array();
        }

        public Type getType() {
            return this.type;
        }

        public BluetoothGattCharacteristic getCharacteristic() {
            return (BluetoothGattCharacteristic)this.gattObject;
        }

        public BluetoothGattDescriptor getDescriptor() {
            return (BluetoothGattDescriptor)this.gattObject;
        }

        public byte[] getValue() {
            return this.value;
        }

        public static enum Type {
            WriteCharacteristic,
            WriteDescriptor,
            MtuRequest;

        }
    }

    public static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }

    public static class Uuid {
        public static final UUID DSPS_SERVICE = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cb7");
        public static final UUID TX_CHARACTERISTIC = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cb8");
        public static final UUID RX_CHARACTERISTIC = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cba");
        public static final UUID FLOW_CONTROL_CHARACTERISTIC = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cb9");
        public static final UUID CLIENT_CHARACTERISTIC_CONFIGURATION_DESCRIPTOR = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    }
}

