/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManagerPort9100;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionPort9100;

public class DeviceConnectionPort9100UDP
extends DeviceConnectionPort9100 {
    private final String TAG = this.getClass().getSimpleName();
    private static final int TIMEOUT = 3000;
    DatagramSocket _datagramSocket;
    InetAddress _inetAddress;

    public DeviceConnectionPort9100UDP(Map<String, String> info) {
        super(info);
        this.accessManager = new AccessManagerPort9100(this);
        this.accessManager.statusLength = new TepraPrintProductInformation().getStatusLengthForModel((String)this.printerInfo.get("usbmdl"));
        this._datagramSocket = null;
    }

    @Override
    public boolean open() {
        if (this._datagramSocket != null) {
            return true;
        }
        String name = (String)this.printerInfo.get("name");
        String type = (String)this.printerInfo.get("type");
        String host = (String)this.printerInfo.get("host");
        try {
            this._datagramSocket = new DatagramSocket();
            this._datagramSocket.setSoTimeout(3000);
            this._inetAddress = InetAddress.getByName(host);
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean close() {
        if (this._datagramSocket != null) {
            this._datagramSocket.close();
            this._datagramSocket = null;
        }
        return true;
    }

    @Override
    public boolean send(byte[] data, int length, boolean isRaster) {
        byte[] buf = new byte[length];
        System.arraycopy(data, 0, buf, 0, length);
        TepraPrintLogger.d(this.TAG, "send(UDP): " + TepraPrintUtil.toHexString(buf));
        if (this._datagramSocket != null) {
            try {
                DatagramPacket packet = new DatagramPacket(data, length, this._inetAddress, 9100);
                this._datagramSocket.send(packet);
            }
            catch (IOException e) {
                TepraPrintLogger.w(this.TAG, "", e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean send(byte[] data, int length) {
        return this.send(data, length, false);
    }

    @Override
    public boolean receive(byte[] buffer, int length) {
        if (this._datagramSocket != null) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, length);
                this._datagramSocket.receive(packet);
            }
            catch (IOException e) {
                TepraPrintLogger.w(this.TAG, "", e);
                return false;
            }
        }
        byte[] data = new byte[length];
        System.arraycopy(buffer, 0, data, 0, length);
        TepraPrintLogger.d(this.TAG, "receive(UDP): " + TepraPrintUtil.toHexString(data));
        return true;
    }
}

