/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionPort9100;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionPort9100UDP;

public class DeviceConnectionPort9100TCP
extends DeviceConnectionPort9100 {
    private final String TAG = this.getClass().getSimpleName();
    private static final int TIMEOUT = 120000;
    Socket _socket;
    InputStream _inputStream;
    OutputStream _outputStream;
    DeviceConnectionPort9100UDP _connectionDatagram;
    boolean isResolving;

    public DeviceConnectionPort9100TCP(Map<String, String> info) {
        super(info);
        if (this._connectionDatagram != null) {
            this._connectionDatagram.close();
        }
        this._connectionDatagram = new DeviceConnectionPort9100UDP(info);
        this._connectionDatagram.open();
        this.accessManager = this._connectionDatagram.accessManager;
        this.printerInfo = this._connectionDatagram.printerInfo;
        this.accessManager.statusLength = new TepraPrintProductInformation().getStatusLengthForModel((String)this.printerInfo.get("usbmdl"));
    }

    @Override
    public boolean open() {
        String name = (String)this.printerInfo.get("name");
        String type = (String)this.printerInfo.get("type");
        String host = (String)this.printerInfo.get("host");
        this.isResolving = true;
        if (this._socket == null) {
            try {
                this._socket = new Socket(host, 9100);
                this._socket.setSoTimeout(120000);
                this._inputStream = new BufferedInputStream(this._socket.getInputStream());
                this._outputStream = new BufferedOutputStream(this._socket.getOutputStream());
            }
            catch (Exception e) {
                TepraPrintLogger.w(this.TAG, "", e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean close() {
        if (this._outputStream != null) {
            try {
                this._outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._outputStream = null;
        }
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._inputStream = null;
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._socket = null;
        }
        return true;
    }

    @Override
    public boolean send(byte[] data, int length, boolean isRaster) {
        byte[] buf = new byte[length];
        System.arraycopy(data, 0, buf, 0, length);
        TepraPrintLogger.d(this.TAG, "send(TCP): " + TepraPrintUtil.toHexString(buf));
        if (this._outputStream != null) {
            try {
                this._outputStream.write(data, 0, length);
                this._outputStream.flush();
            }
            catch (IOException e) {
                TepraPrintLogger.w(this.TAG, "", e);
                return false;
            }
        }
        TepraPrintLogger.d(this.TAG, "send(TCP): success");
        return true;
    }

    @Override
    public boolean send(byte[] data, int length) {
        return this.send(data, length, false);
    }

    @Override
    public boolean receive(byte[] data, int length) {
        return true;
    }
}

