/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import java.util.Map;
import java.util.Set;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManagerBluetooth;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManagerBluetooth2;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceManagerBluetooth;

public class DeviceConnectionBluetooth
extends DeviceConnection {
    private final String TAG = this.getClass().getSimpleName();
    private static final int DEVICE_CONNECTION_STATUS_TIMEOUT_BLUETOOTH = 60000;
    private static final int DEVICE_CONNECTION_OPEN_INTERVAL = 500;
    private static final int READ_TIMEOUT = 20000;
    private static final int WRITE_TIMEOUT = 20000;
    private static final int RASTER_DATA_WRITE_TIMEOUT = 60000;
    private BluetoothAdapter btAdapter;
    private DeviceManagerBluetooth deviceManager;
    boolean _disconnected;
    int _connectionID;
    long _lastSessionDate;

    public DeviceConnectionBluetooth(Map<String, String> info) {
        super(info);
        int statusLength = new TepraPrintProductInformation().getStatusLengthForModel((String)this.printerInfo.get("usbmdl"));
        this.accessManager = statusLength == 8 ? new AccessManagerBluetooth(this) : new AccessManagerBluetooth2(this);
        this.accessManager.statusLength = statusLength;
        this._disconnected = true;
        this.btAdapter = BluetoothAdapter.getDefaultAdapter();
        this.deviceManager = new DeviceManagerBluetooth(this);
        this._lastSessionDate = System.currentTimeMillis();
    }

    @Override
    public boolean open() {
        String macAddress = (String)this.printerInfo.get("Serial Number");
        if (this.btAdapter == null) {
            return false;
        }
        if (this.printProcessing && this.deviceManager.isConnected()) {
            TepraPrintLogger.d(this.TAG, "Bluetooth socket is already open, but does not open.");
            this._disconnected = false;
            return true;
        }
        if (System.currentTimeMillis() - this._lastSessionDate < 500L) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean result = true;
        BluetoothDevice device = this.btAdapter.getRemoteDevice(macAddress);
        result = this.deviceManager.connect(device);
        if (result) {
            this._disconnected = false;
        }
        return result;
    }

    @Override
    public boolean close() {
        if (this.printProcessing) {
            TepraPrintLogger.d(this.TAG, "It is not closed during printing.");
            return true;
        }
        if (this.deviceManager != null) {
            this.deviceManager.close();
        }
        this._lastSessionDate = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean compulsionClose() {
        this.printProcessing = false;
        return this.close();
    }

    @Override
    public boolean send(byte[] data, int length, boolean isRaster) {
        boolean result = false;
        try {
            if (data.length > 0) {
                byte[] send = new byte[length];
                System.arraycopy(data, 0, send, 0, length);
                result = isRaster ? this.deviceManager.write(send, 60000) : this.deviceManager.write(send, 20000);
            }
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "", e);
        }
        return result;
    }

    @Override
    public boolean send(byte[] data, int length) {
        return this.send(data, length, false);
    }

    @Override
    public boolean receive(byte[] buffer, int length) {
        boolean result = false;
        byte[] data = this.deviceManager.read(length, 60000);
        if (data.length > 0) {
            System.arraycopy(data, 0, buffer, 0, data.length);
            result = true;
        }
        return result;
    }

    @Override
    public byte[] receiveAll(int timeout) {
        int to = timeout;
        if (timeout == 0) {
            to = 60000;
        }
        byte[] data = null;
        long start = System.currentTimeMillis();
        while (true) {
            if ((data = this.deviceManager.readAll(20000)) == null) {
                return null;
            }
            if (data.length > 0) break;
            if (System.currentTimeMillis() - start > (long)to) {
                data = null;
                break;
            }
            if (this._disconnected) {
                data = null;
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return data;
    }

    public boolean isDeviceEnabled() {
        boolean deviceEnabled = false;
        if (this.btAdapter != null) {
            Set pairedDevices = this.btAdapter.getBondedDevices();
            if (this.btAdapter.isEnabled() && pairedDevices.size() > 0) {
                String macAddress = (String)this.printerInfo.get("Serial Number");
                for (BluetoothDevice device : pairedDevices) {
                    if (!device.getAddress().equals(macAddress)) continue;
                    deviceEnabled = true;
                    break;
                }
            }
        }
        return deviceEnabled;
    }
}

