/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManagerBLE;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceManagerBLE;

public class DeviceConnectionBLE
extends DeviceConnection {
    private final String TAG = this.getClass().getSimpleName();
    private static final int DEVICE_CONNECTION_STATUS_TIMEOUT = 60000;
    private static final int DEVICE_CONNECTION_OPEN_INTERVAL = 500;
    private static final int READ_TIMEOUT = 20000;
    static final int WRITE_TIMEOUT = 20000;
    private static final int RASTER_DATA_WRITE_TIMEOUT = 60000;
    private final BluetoothAdapter _bluetoothAdapter;
    private final DeviceManagerBLE _deviceManagerBLE;
    private boolean _disconnected;
    private long _lastSessionDate;

    public DeviceConnectionBLE(Map<String, String> info) {
        super(info);
        int statusLength = new TepraPrintProductInformation().getStatusLengthForModel((String)this.printerInfo.get("usbmdl"));
        if (statusLength == 22) {
            this.accessManager = new AccessManagerBLE(this);
        } else {
            TepraPrintLogger.e(this.TAG, "Invalid status length: Expected 22, but received " + statusLength);
        }
        this.accessManager.statusLength = statusLength;
        this._disconnected = true;
        this._bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this._deviceManagerBLE = new DeviceManagerBLE(this);
        this._lastSessionDate = System.currentTimeMillis();
    }

    @Override
    public boolean open() {
        BluetoothDevice device;
        boolean result;
        String macAddress = (String)this.printerInfo.get("Serial Number");
        if (this._bluetoothAdapter == null) {
            return false;
        }
        if (this.printProcessing && this._deviceManagerBLE.isConnected()) {
            TepraPrintLogger.d(this.TAG, "Bluetooth Gatt is already open, but does not open.");
            this._disconnected = false;
            return true;
        }
        if (System.currentTimeMillis() - this._lastSessionDate < 500L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                TepraPrintLogger.e(this.TAG, "Thread was interrupted: " + e);
            }
        }
        if (result = this._deviceManagerBLE.connect(device = this._bluetoothAdapter.getRemoteDevice(macAddress))) {
            this._disconnected = false;
        }
        return result;
    }

    @Override
    public boolean close() {
        if (this.printProcessing) {
            TepraPrintLogger.d(this.TAG, "It is not closed during printing.");
            return true;
        }
        if (this._deviceManagerBLE != null) {
            this._deviceManagerBLE.disconnect();
        }
        this._lastSessionDate = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean compulsionClose() {
        this.printProcessing = false;
        return this.close();
    }

    @Override
    public boolean send(byte[] data, int length, boolean isRaster) {
        boolean result = false;
        try {
            if (data.length > 0) {
                byte[] send = new byte[length];
                System.arraycopy(data, 0, send, 0, length);
                result = isRaster ? this._deviceManagerBLE.write(send, 60000) : this._deviceManagerBLE.write(send, 20000);
            }
        }
        catch (Exception e) {
            TepraPrintLogger.e(this.TAG, "Error during BLE send", e);
        }
        return result;
    }

    @Override
    public boolean send(byte[] data, int length) {
        return this.send(data, length, false);
    }

    @Override
    public byte[] receiveAll(int timeout) {
        byte[] data;
        int to = timeout == 0 ? 60000 : timeout;
        long start = System.currentTimeMillis();
        while (true) {
            if ((data = this._deviceManagerBLE.readAll(20000)) == null) {
                return null;
            }
            if (data.length > 0) break;
            if (System.currentTimeMillis() - start > (long)to) {
                data = null;
                break;
            }
            if (this._disconnected) {
                data = null;
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                TepraPrintLogger.e(this.TAG, "Thread was interrupted: " + e);
            }
        }
        return data;
    }

    public boolean isDeviceEnabled() {
        return this._bluetoothAdapter != null;
    }
}

