/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManager;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceAccessStatus;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;

public class AccessManagerPort9100
extends AccessManager {
    private final String TAG = this.getClass().getSimpleName();
    private static final int PACKET_SIZE = 32;
    private static final int ENGAGE_LW_RESPONSE_SIZE = 35;
    private static final int DISABLE_ENGAGE_LW_RESPONSE_SIZE = 35;
    private static final int CHECK_ENGAGE_LW_RESPONSE_SIZE = 35;
    private static final int ENGAGE_LW_RESPONSE_RESPONSENUM = 32;
    private static final int ENGAGE_LW_RESPONSE_RESULT = 33;
    private static final int ENGAGE_LW_RESPONSE_RESERVE = 34;
    private static final int LW_STATUS_RESPONSE_SIZE = 46;
    private static final int PORT_STATUS_RESPONSE_SIZE = 33;
    private static final int PORT_STATUS_RESPONSE_RESULT = 32;
    private static final int DEFAULT_RETRY_COUNT = 10;
    byte[] _infoID = new byte[8];
    boolean _isAccessing = false;

    public AccessManagerPort9100(DeviceConnection deviceConnection) {
        super(deviceConnection);
    }

    @Override
    public DeviceAccessStatus requestAccess() {
        byte[] packet = new byte[256];
        byte[] data = new byte[256];
        byte[] response = new byte[256];
        boolean success = false;
        this._commandFilter.createPacket(2, packet, data, this._infoID, false, this.getIPAddress());
        if (this.sendAndReceive(packet, 32, response, 35, 10) && response[33] == 0) {
            TepraPrintLogger.d(this.TAG, "access request success");
            this._commandFilter.createPacket(4, packet, data, this._infoID, true, this.getIPAddress());
            if (this.sendAndReceive(packet, 32, response, 35, 10)) {
                TepraPrintLogger.d(this.TAG, "access response receive");
                if (response[33] == 0) {
                    TepraPrintLogger.d(this.TAG, "access SUCCESS");
                    success = true;
                }
            }
        }
        if (success) {
            this._isAccessing = true;
            return DeviceAccessStatus.DeviceAccessStatusConnectionSuccess;
        }
        this._isAccessing = false;
        return DeviceAccessStatus.DeviceAccessStatusConnectionFailure;
    }

    @Override
    public DeviceAccessStatus releaseAccess() {
        byte[] packet = new byte[256];
        byte[] data = new byte[256];
        byte[] response = new byte[256];
        boolean success = false;
        this._commandFilter.createPacket(3, packet, data, this._infoID, true, this.getIPAddress());
        if (this.sendAndReceive(packet, 32, response, 35, 10)) {
            if (response[33] == 0) {
                TepraPrintLogger.d(this.TAG, "release success");
                success = true;
            } else {
                TepraPrintLogger.d(this.TAG, "release access failed");
            }
        }
        if (success) {
            this._isAccessing = true;
            return DeviceAccessStatus.DeviceAccessStatusConnectionSuccess;
        }
        this._isAccessing = false;
        return DeviceAccessStatus.DeviceAccessStatusConnectionFailure;
    }

    @Override
    public Map<String, Integer> getPrinterStatus() {
        Map<String, Integer> status = new HashMap<String, Integer>();
        byte[] packet = new byte[256];
        byte[] data = new byte[256];
        boolean success = false;
        this._commandFilter.createPacket(1, packet, data, this._infoID, this._isAccessing, this.getIPAddress());
        byte[] lwStatus = new byte[256];
        if (this.sendAndReceive(packet, 32, lwStatus, 32 + this.statusLength, 10)) {
            success = true;
            byte[] realStatus = Arrays.copyOfRange(lwStatus, 32, lwStatus.length);
            status = this.parseStatusFromLwStatus(realStatus);
        }
        return status;
    }

    @Override
    public Map<String, String> getDeviceInformation() {
        Map<String, String> deviceInfo = null;
        byte[] packet = new byte[256];
        byte[] data = new byte[256];
        this._commandFilter.createPacket(5, packet, data, this._infoID, this._isAccessing, this.getIPAddress());
        byte[] lwStatus = new byte[256];
        if (this.sendAndReceive(packet, 32, lwStatus, 96, 3)) {
            byte[] realStatus = Arrays.copyOfRange(lwStatus, 32, 96);
            deviceInfo = this.parseDeviceInformation(realStatus);
        }
        return deviceInfo;
    }

    @Override
    public Map<String, Integer> getPrinterStatusProcessing(Map<String, Integer> status) {
        return this.getPrinterStatus();
    }

    @Override
    public Map<String, Integer> getPrinterStatusForAfterPrint() {
        return this.getPrinterStatus();
    }

    @Override
    public void resetPrinter() {
        byte[] packet = new byte[256];
        byte[] data = new byte[256];
        this._commandFilter.createPacket(257, packet, data, this._infoID, this._isAccessing, this.getIPAddress());
        byte[] response = new byte[256];
        if (this.sendAndReceive(packet, 32, response, 32, 10)) {
            // empty if block
        }
    }

    @Override
    public boolean getPortStatus() {
        byte[] packet = new byte[256];
        byte[] data = new byte[256];
        boolean success = false;
        this._commandFilter.createPacket(256, packet, data, this._infoID, this._isAccessing, this.getIPAddress());
        byte[] response = new byte[256];
        if (this.sendAndReceive(packet, 32, response, 33, 10)) {
            success = (response[32] & 0x10) == 16;
        }
        return success;
    }

    private boolean sendAndReceive(byte[] sendData, int sendLength, byte[] receiveData, int receiveLength, int retryCount) {
        boolean result = false;
        for (int connect = 0; connect < retryCount; ++connect) {
            if (!this.deviceConnection.open()) {
                TepraPrintLogger.d(this.TAG, "sendAndReceive[" + connect + "]: deviceConnection open error");
                return false;
            }
            for (int i = 0; i < 1; ++i) {
                TepraPrintLogger.d(this.TAG, "sendAndReceive[" + i + "]: sendLength(" + connect + "," + i + ")=" + sendLength);
                if (this.deviceConnection.send(sendData, sendLength)) {
                    Arrays.fill(receiveData, (byte)0);
                    if (this.deviceConnection.receive(receiveData, receiveLength)) {
                        TepraPrintLogger.d(this.TAG, "sendAndReceive[" + i + "]: receiveLength(" + connect + "," + i + ")=" + receiveLength);
                        result = true;
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!result) {
                this.deviceConnection.close();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.deviceConnection.close();
            break;
        }
        TepraPrintLogger.d(this.TAG, "sendAndReceive: Result: " + result);
        return result;
    }
}

