/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManagerBluetooth;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceAccessStatus;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionBluetooth;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreTapeWidth;

public class AccessManagerBluetooth2
extends AccessManagerBluetooth {
    private final String TAG = this.getClass().getSimpleName();
    private static final int PREFIX_LENGTH = 13;

    public AccessManagerBluetooth2(DeviceConnection deviceConnection) {
        super(deviceConnection);
    }

    @Override
    public boolean setRequestStatus() {
        this._isPrint = true;
        byte[] request = new byte[]{27, 123, 5, 73, 5, 0, 78, 125};
        return this.deviceConnection.send(request, request.length);
    }

    @Override
    public boolean resetRequestStatus() {
        this._isPrint = false;
        byte[] request = new byte[]{27, 123, 5, 73, 0, 0, 73, 125};
        boolean result = this.deviceConnection.send(request, request.length);
        if (result) {
            this.getPrinterStatus();
        }
        return result;
    }

    @Override
    public DeviceAccessStatus requestAccessForStatus() {
        if (this.deviceConnection.open()) {
            this._isPrint = false;
            byte[] request = new byte[]{27, 123, 5, 73, 0, 0, 73, 125};
            this.deviceConnection.send(request, request.length);
            return DeviceAccessStatus.DeviceAccessStatusConnectionSuccess;
        }
        return DeviceAccessStatus.DeviceAccessStatusPortOpenError;
    }

    @Override
    public Map<String, Integer> getPrinterStatus() {
        DeviceConnectionBluetooth dcBluetooth;
        Map<String, Integer> status = this.getPrinterStatusSub();
        if ((status == null || status.isEmpty() && !this._isPrint) && this.deviceConnection instanceof DeviceConnectionBluetooth && !(dcBluetooth = (DeviceConnectionBluetooth)this.deviceConnection).isDeviceEnabled()) {
            TepraPrintLogger.d(this.TAG, "Bluetooth is disabled or the device is not paired.");
            return null;
        }
        return status;
    }

    private Map<String, Integer> getPrinterStatusSub() {
        boolean mode = false;
        Map<String, Integer> status = new HashMap<String, Integer>();
        byte[] buff = new byte[]{};
        if (mode) {
            status.put("ST", 0);
            status.put("ER", 0);
            status.put("PP", 0);
        } else {
            ByteBuffer byteBuf;
            do {
                byte[] data = this.deviceConnection.receiveAll(this._isPrint ? (this._isAfterPrint ? 30000 : 300000) : 0);
                if (data == null || data.length == 0) {
                    return null;
                }
                byteBuf = ByteBuffer.allocate(buff.length + data.length);
                byteBuf.put(buff);
                byteBuf.put(data);
            } while ((buff = byteBuf.array()).length < 91);
            TepraPrintLogger.d(this.TAG, "receive data(" + buff.length + "):" + new String(buff) + "[ " + TepraPrintUtil.toHexString(buff) + " ]");
            byte[] statusBuff = Arrays.copyOfRange(buff, 13, buff.length);
            status = this.parseStatusFromLwStatus(statusBuff);
            this.updateStatusBuffer(status, buff);
        }
        TepraPrintLogger.d(this.TAG, "PrinterStatus:" + ((Object)status).toString());
        return status;
    }

    @Override
    Map<String, Integer> parseStatusFromLwStatus(byte[] lwStatus) {
        HashMap<String, Integer> status = new HashMap<String, Integer>();
        PrintCoreTapeWidth tapeWidth = this._commandFilter.getTapeWidthFromLWStatusTWCode(lwStatus[3] & 0xFF);
        status.put("ST", 0);
        status.put("ER", 0);
        status.put("PP", 0);
        status.put("ER2", 0);
        if (this.statusLength == 78) {
            int pp = ((lwStatus[12] & 0xFF) << 8) + (lwStatus[13] & 0xFF);
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("TW", lwStatus[3] & 0xFF);
            status.put("TR", lwStatus[4] & 0xFF);
            status.put("EI", lwStatus[5] & 0xFF);
            status.put("TO", lwStatus[8] & 0xFF);
            status.put("IR", lwStatus[9] & 0xFF);
            status.put("RR", lwStatus[10] & 0xFF);
            status.put("EJ", lwStatus[11] & 0xFF);
            status.put("PP", pp);
            status.put("ER2", lwStatus[2] & 0xFF);
            status.put("EI2", lwStatus[15] & 0xFF);
            status.put("EJ2", lwStatus[16] & 0xFF);
            status.put("TC", lwStatus[17] & 0xFF);
            status.put("RC", lwStatus[18] & 0xFF);
            status.put("JI", lwStatus[19] & 0xFF);
            status.put("TS", lwStatus[20] & 0xFF);
            status.put("T8S", lwStatus[21] & 0xFF);
            status.put("T8O", lwStatus[22] & 0xFF);
            status.put("T8T", lwStatus[23] & 0xFF);
            status.put("T8B", lwStatus[24] & 0xFF);
            int rb = ((lwStatus[25] & 0xFF) << 24) + ((lwStatus[26] & 0xFF) << 16) + ((lwStatus[27] & 0xFF) << 8) + (lwStatus[28] & 0xFF);
            status.put("RB", rb);
            status.put("WA", lwStatus[29] & 0xFF);
            int printingPage = ((lwStatus[30] & 0xFF) << 8) + (lwStatus[31] & 0xFF);
            status.put("PPN", printingPage);
            status.put("TWS", lwStatus[32] & 0xFF);
            status.put("BR", lwStatus[33] & 0xFF);
            int brLengthMM = ((lwStatus[34] & 0xFF) << 24) + ((lwStatus[35] & 0xFF) << 16) + ((lwStatus[36] & 0xFF) << 8) + (lwStatus[37] & 0xFF);
            status.put("BTLM", brLengthMM);
            int brLengthIn = ((lwStatus[38] & 0xFF) << 24) + ((lwStatus[39] & 0xFF) << 16) + ((lwStatus[40] & 0xFF) << 8) + (lwStatus[41] & 0xFF);
            status.put("BTLI", brLengthIn);
            int usingLength = ((lwStatus[42] & 0xFF) << 24) + ((lwStatus[43] & 0xFF) << 16) + ((lwStatus[44] & 0xFF) << 8) + (lwStatus[45] & 0xFF);
            status.put("BTUL", usingLength);
            int labelTotal = ((lwStatus[46] & 0xFF) << 8) + (lwStatus[47] & 0xFF);
            status.put("BLT", labelTotal);
            int labelCount = ((lwStatus[48] & 0xFF) << 8) + (lwStatus[49] & 0xFF);
            status.put("BLC", labelCount);
            int tapeRGBA = ((lwStatus[50] & 0xFF) << 24) + ((lwStatus[51] & 0xFF) << 16) + ((lwStatus[52] & 0xFF) << 8) + (lwStatus[53] & 0xFF);
            status.put("BTR", tapeRGBA);
            int ribbonRGBA = ((lwStatus[54] & 0xFF) << 24) + ((lwStatus[55] & 0xFF) << 16) + ((lwStatus[56] & 0xFF) << 8) + (lwStatus[57] & 0xFF);
            status.put("BRR", ribbonRGBA);
            status.put("BTW", lwStatus[58] & 0xFF);
            int tapeKind = ((lwStatus[59] & 0xFF) << 8) + (lwStatus[60] & 0xFF);
            status.put("BTK", tapeKind);
            status.put("BPS", lwStatus[61] & 0xFF);
            status.put("BO", lwStatus[62] & 0xFF);
            status.put("BPD", lwStatus[63] & 0xFF);
            status.put("BHD", lwStatus[64] & 0xFF);
            status.put("RES3", lwStatus[65] & 0xFF);
            for (int i = 0; i < 12; ++i) {
                status.put("BSN_" + String.valueOf(i + 1), lwStatus[66 + i] & 0xFF);
            }
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
        }
        return status;
    }

    @Override
    public void updateStatusBuffer(Map<String, Integer> status, byte[] allData) {
    }

    @Override
    public int getBatteryType() {
        int type = 0;
        if (this.deviceConnection.open()) {
            byte[] read;
            byte[] start = new byte[]{27, 123, 4, 85, 1, 86, 125};
            boolean result = this.deviceConnection.send(start, start.length);
            if (result && (result = this.deviceConnection.send(read = new byte[]{27, 123, 5, 102, 18, 16, -120, 125}, read.length))) {
                byte[] data = this.deviceConnection.receiveAll(300000);
                if (data == null || data.length <= 10) {
                    return type;
                }
                TepraPrintLogger.d(this.TAG, "getBatteryType(" + data.length + "):" + new String(data) + "[ " + TepraPrintUtil.toHexString(data) + " ]");
                type = data[9];
                byte[] end = new byte[]{27, 123, 4, 85, 0, 85, 125};
                result = this.deviceConnection.send(end, end.length);
                if (!result) {
                    // empty if block
                }
            }
            if (!this.deviceConnection.close()) {
                // empty if block
            }
        }
        return type;
    }

    @Override
    public void setBatteryType(int type) {
        if (this.deviceConnection.open()) {
            byte[] data;
            byte[] update;
            byte[] start = new byte[]{27, 123, 4, 85, 1, 86, 125};
            boolean result = this.deviceConnection.send(start, start.length);
            if (result && (result = this.deviceConnection.send(update = new byte[]{27, 123, 3, 119, 119, 125}, update.length)) && (result = this.deviceConnection.send(data = new byte[]{67, 70, 59, 7, 0, 59, 18, 16, 59, (byte)type, 59, (byte)(152 + type + 59)}, data.length))) {
                byte[] rcv = this.deviceConnection.receiveAll(300000);
                if (rcv == null) {
                    return;
                }
                TepraPrintLogger.d(this.TAG, "setBatteryType(" + rcv.length + "):" + new String(rcv) + "[ " + TepraPrintUtil.toHexString(rcv) + " ]");
                byte[] end = new byte[]{27, 123, 4, 85, 0, 85, 125};
                result = this.deviceConnection.send(end, end.length);
                if (result) {
                    TepraPrintLogger.d(this.TAG, "setBatteryType Success");
                }
            }
            if (!this.deviceConnection.close()) {
                // empty if block
            }
        }
    }
}

