/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManager;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceAccessStatus;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionBluetooth;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreStatus;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreTapeWidth;

public class AccessManagerBluetooth
extends AccessManager {
    private final String TAG = this.getClass().getSimpleName();
    protected static final int ACCESS_MANAGER_READ_TIMEOUT_BLUETOOTH = 300000;
    protected static final int ACCESS_MANAGER_AFTER_PRINT_TIMEOUT_BLUETOOTH = 30000;
    protected boolean _isPrint;
    protected boolean _isAfterPrint;
    private int[] _statusERPriorityList = new int[]{1, 48, 21, 33, 6, 32, 34};

    public AccessManagerBluetooth(DeviceConnection deviceConnection) {
        super(deviceConnection);
        String model;
        if (!deviceConnection.printerInfo.containsKey("product") || (model = deviceConnection.printerInfo.get("product")).equals("SR-MK1")) {
            // empty if block
        }
    }

    @Override
    public DeviceAccessStatus releaseAccess() {
        this._isAfterPrint = false;
        return DeviceAccessStatus.DeviceAccessStatusDisconnectionSuccess;
    }

    @Override
    public boolean setRequestStatus() {
        this._isPrint = true;
        byte[] request = new byte[]{27, 123, 5, 81, 5, 0, 86, 125};
        return this.deviceConnection.send(request, request.length);
    }

    @Override
    public boolean resetRequestStatus() {
        this._isPrint = false;
        byte[] request = new byte[]{27, 123, 5, 81, 0, 0, 81, 125};
        boolean result = this.deviceConnection.send(request, request.length);
        if (result) {
            this.getPrinterStatus();
        }
        return result;
    }

    @Override
    public DeviceAccessStatus requestAccessForStatus() {
        if (this.deviceConnection.open()) {
            this._isPrint = false;
            byte[] request = new byte[]{27, 123, 5, 81, 0, 0, 81, 125};
            this.deviceConnection.send(request, request.length);
            return DeviceAccessStatus.DeviceAccessStatusConnectionSuccess;
        }
        return DeviceAccessStatus.DeviceAccessStatusPortOpenError;
    }

    @Override
    public DeviceAccessStatus releaseAccessForStatus() {
        this._isPrint = false;
        if (this.deviceConnection.close()) {
            return DeviceAccessStatus.DeviceAccessStatusDisconnectionSuccess;
        }
        return DeviceAccessStatus.DeviceAccessStatusConnectionFailure;
    }

    @Override
    public Map<String, Integer> getPrinterStatus() {
        DeviceConnectionBluetooth dcBluetooth;
        Map<String, Integer> status = this.getPrinterStatusSub();
        if ((status == null || status.isEmpty() && !this._isPrint) && this.deviceConnection instanceof DeviceConnectionBluetooth && !(dcBluetooth = (DeviceConnectionBluetooth)this.deviceConnection).isDeviceEnabled()) {
            TepraPrintLogger.d(this.TAG, "Bluetooth is disabled or the device is not paired.");
            return null;
        }
        return status;
    }

    @Override
    public Map<String, Integer> getPrinterStatusForAfterPrint() {
        this._isAfterPrint = true;
        return this.getPrinterStatus();
    }

    private Map<String, Integer> getPrinterStatusSub() {
        boolean mode = false;
        Map<String, Integer> status = new HashMap<String, Integer>();
        byte[] buff = new byte[1024];
        if (mode) {
            status.put("ST", 0);
            status.put("ER", 0);
            status.put("PP", 0);
        } else {
            byte[] allData = new byte[]{};
            boolean hit = false;
            block0: do {
                byte[] data = this.deviceConnection.receiveAll(this._isPrint ? (this._isAfterPrint ? 30000 : 300000) : 0);
                if (data == null || data.length == 0) {
                    return null;
                }
                ByteBuffer byteBuf = ByteBuffer.allocate(allData.length + data.length);
                byteBuf.put(allData);
                byteBuf.put(data);
                allData = byteBuf.array();
                if (data.length == 64 && data[0] == 64 && data[63] == -1) {
                    buff = Arrays.copyOfRange(allData, 0, allData.length);
                }
                for (int i = allData.length - 1; i >= 0; --i) {
                    if (allData[i] != 64 || allData.length - i < 64) continue;
                    if (allData[i + 63] != -1) continue block0;
                    buff = Arrays.copyOfRange(allData, i, i + 64);
                    hit = true;
                    continue block0;
                }
            } while (!hit);
            TepraPrintLogger.d(this.TAG, "receive data(" + buff.length + "):" + new String(allData) + "[ " + TepraPrintUtil.toHexString(buff) + " ]");
            status = this.parseStatusFromLwStatus(buff);
            this.updateStatusBuffer(status, allData);
        }
        TepraPrintLogger.d(this.TAG, "PrinterStatus:" + ((Object)status).toString());
        return status;
    }

    @Override
    public void resetPrinter() {
        byte[] request = new byte[]{27, 123, 3, 33, 33, 125};
        this.deviceConnection.send(request, request.length);
    }

    @Override
    public boolean isCancelRequest(boolean cancel, Map<String, Integer> status) {
        if (status != null && status.containsKey("ST")) {
            int st = status.get("ST");
            if (st == PrintCoreStatus.PrintCoreStatusFeeding.getIntValue() || st == PrintCoreStatus.PrintCoreStatusPrinting.getIntValue()) {
                return cancel;
            }
            return false;
        }
        return false;
    }

    @Override
    Map<String, Integer> parseStatusFromLwStatus(byte[] lwStatus) {
        boolean mode = true;
        if (mode) {
            HashMap<String, Integer> status = new HashMap<String, Integer>();
            status.put("PP", 0);
            status.put("ER2", 0);
            lwStatus[63] = 0;
            String s = null;
            try {
                s = new String(lwStatus, "UTF-8");
            }
            catch (Exception e) {
                TepraPrintLogger.w(this.TAG, "", e);
                return status;
            }
            int dt = 0;
            dt = this.parseStatusCode(s, "ST");
            status.put("ST", dt);
            dt = this.parseStatusCode(s, "ER");
            status.put("ER", dt);
            status.put("ER2", dt);
            dt = this.parseStatusCode(s, "TW");
            status.put("TW", dt);
            PrintCoreTapeWidth tapeWidth = this._commandFilter.getTapeWidthFromLWStatusTWCode(dt);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
            dt = this.parseStatusCode(s, "TR");
            status.put("TR", dt);
            dt = this.parseStatusCode(s, "EI");
            status.put("EI", dt);
            dt = this.parseStatusCode(s, "TO");
            status.put("TO", dt);
            dt = this.parseStatusCode(s, "IR");
            status.put("IR", dt);
            dt = this.parseStatusCode(s, "RR");
            status.put("RR", dt);
            dt = this.parseStatusCode(s, "EJ");
            status.put("EJ", dt);
            dt = this.parseStatusCode(s, "WR");
            status.put("WR", dt);
            dt = this.parseStatusCode(s, "RV");
            status.put("RV", dt);
            dt = this.parseStatusCode(s, "CT");
            status.put("CT", dt);
            dt = this.parseStatusCode(s, "OP");
            status.put("OP", dt);
            return status;
        }
        HashMap<String, Integer> statusDict = new HashMap<String, Integer>();
        statusDict.put("PP", 0);
        statusDict.put("ER2", 0);
        lwStatus[64] = 0;
        String s = null;
        try {
            s = new String(lwStatus, "UTF-8");
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "", e);
        }
        int dt = 0;
        String codestring = s.substring(11, 13);
        dt = Integer.parseInt(codestring, 16);
        statusDict.put("ST", dt);
        codestring = s.substring(13, 15);
        dt = Integer.parseInt(codestring, 16);
        statusDict.put("ER", dt);
        codestring = s.substring(15, 17);
        dt = Integer.parseInt(codestring, 16);
        statusDict.put("TW", dt);
        PrintCoreTapeWidth tapeWidth = this._commandFilter.getTapeWidthFromLWStatusTWCode(dt);
        statusDict.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
        codestring = s.substring(17, 19);
        dt = Integer.parseInt(codestring, 16);
        statusDict.put("TW", dt);
        codestring = s.substring(19, 21);
        dt = Integer.parseInt(codestring, 16);
        statusDict.put("TR", dt);
        codestring = s.substring(21, 23);
        dt = Integer.parseInt(codestring, 16);
        statusDict.put("EI", dt);
        return statusDict;
    }

    @Override
    public int getBatteryType() {
        return 0;
    }

    @Override
    public void setBatteryType(int type) {
    }

    private int parseStatusCode(String data, String identifier) {
        int code = 0;
        int index = data.lastIndexOf(identifier);
        if (index != -1) {
            int dt;
            String codestring = data.substring(index + 3, index + 3 + 2);
            code = dt = Integer.parseInt(codestring, 16);
        }
        return code;
    }

    public void updateStatusBuffer(Map<String, Integer> status, byte[] allData) {
        int errAns = 0;
        int er = 0;
        int indexMin = this._statusERPriorityList.length;
        int index = 0;
        String[] allStr = new String(allData).split("\n");
        for (int i = 0; i < allStr.length; ++i) {
            if (allStr[i].indexOf("ER:") <= 0) continue;
            try {
                er = this.parseStatusCode(allStr[i], "ER");
            }
            catch (Exception e) {
                TepraPrintLogger.w(this.TAG, "updateStatusBuffer: skip data=[" + allStr[i] + "]");
                continue;
            }
            index = this.indexOf(this._statusERPriorityList, er);
            if (index == -1 && er != 0) {
                errAns = er;
                break;
            }
            if (index == -1 || index >= indexMin) continue;
            errAns = indexMin == -1 ? 0 : er;
            indexMin = index == -1 ? indexMin : index;
        }
        if (status.containsKey("ER")) {
            status.put("ER", errAns);
        }
        if (status.containsKey("ER2")) {
            status.put("ER2", errAns);
        }
    }

    private int indexOf(int[] dim, int num) {
        for (int i = 0; i < dim.length; ++i) {
            if (dim[i] != num) continue;
            return i;
        }
        return -1;
    }
}

