/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintUtil;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.AccessManagerBluetooth2;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnectionBLE;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreTapeWidth;

public class AccessManagerBLE
extends AccessManagerBluetooth2 {
    private final String TAG = this.getClass().getSimpleName();
    private static final int ACCESS_MANAGER_READ_TIMEOUT_BLE = 300000;
    private static final int ACCESS_MANAGER_AFTER_PRINT_TIMEOUT_BLE = 30000;
    private static final int PREFIX_LENGTH = 13;

    public AccessManagerBLE(DeviceConnection deviceConnection) {
        super(deviceConnection);
    }

    @Override
    public Map<String, Integer> getPrinterStatus() {
        DeviceConnectionBLE dcBLE;
        Map<String, Integer> status = this.getPrinterStatusSub();
        if ((status == null || status.isEmpty() && !this._isPrint) && this.deviceConnection instanceof DeviceConnectionBLE && !(dcBLE = (DeviceConnectionBLE)this.deviceConnection).isDeviceEnabled()) {
            TepraPrintLogger.d(this.TAG, "Bluetooth is disabled or the device is not paired.");
            return null;
        }
        return status;
    }

    private Map<String, Integer> getPrinterStatusSub() {
        HashMap<String, Integer> status = new HashMap();
        byte[] buff = new byte[1024];
        byte[] allData = new byte[]{};
        boolean hit = false;
        block0: do {
            byte[] data = this.deviceConnection.receiveAll(this._isPrint ? (this._isAfterPrint ? 30000 : 300000) : 0);
            if (data == null || data.length == 0) {
                return null;
            }
            ByteBuffer byteBuf = ByteBuffer.allocate(allData.length + data.length);
            byteBuf.put(allData);
            byteBuf.put(data);
            allData = byteBuf.array();
            if (allData.length == 36 && allData[0] == 64) {
                buff = Arrays.copyOfRange(allData, 0, allData.length);
                break;
            }
            for (int i = allData.length - 1; i >= 0; --i) {
                if (allData[i] != 64 || allData.length - i < 36) continue;
                buff = Arrays.copyOfRange(allData, i, i + 36);
                hit = true;
                continue block0;
            }
        } while (!hit);
        TepraPrintLogger.d(this.TAG, "receive data(" + buff.length + "):" + new String(buff) + "[ " + TepraPrintUtil.toHexString(buff) + " ]");
        byte[] statusBuff = Arrays.copyOfRange(buff, 13, buff.length);
        status = this.parseStatusFromLwStatus(statusBuff);
        this.updateStatusBuffer(status, buff);
        TepraPrintLogger.d(this.TAG, "PrinterStatus:" + ((Object)status).toString());
        return status;
    }

    @Override
    Map<String, Integer> parseStatusFromLwStatus(byte[] lwStatus) {
        HashMap<String, Integer> status = new HashMap<String, Integer>();
        status.put("ST", 0);
        status.put("ER", 0);
        status.put("ER2", 0);
        status.put("PP", 0);
        if (this.statusLength == 22) {
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("ER2", lwStatus[2] & 0xFF);
            status.put("EI2", lwStatus[4] & 0xFF);
            status.put("EJ2", lwStatus[5] & 0xFF);
            status.put("TW", lwStatus[6] & 0xFF);
            status.put("TR", lwStatus[7] & 0xFF);
            status.put("TS", lwStatus[8] & 0xFF);
            status.put("T8S", lwStatus[9] & 0xFF);
            status.put("T8O", lwStatus[10] & 0xFF);
            status.put("T8T", lwStatus[11] & 0xFF);
            int printPage = ((lwStatus[12] & 0xFF) << 8) + (lwStatus[13] & 0xFF);
            status.put("PP", printPage);
            int receiveBuffer = ((lwStatus[14] & 0xFF) << 24) + ((lwStatus[15] & 0xFF) << 16) + ((lwStatus[16] & 0xFF) << 8) + (lwStatus[17] & 0xFF);
            status.put("RB", receiveBuffer);
            status.put("WA", lwStatus[18] & 0xFF);
            status.put("VER", lwStatus[19] & 0xFF);
            int reserved = ((lwStatus[20] & 0xFF) << 8) + (lwStatus[21] & 0xFF);
            status.put("RES", reserved);
            PrintCoreTapeWidth tapeWidth = this._commandFilter.getTapeWidthFromLWStatusTWCode(lwStatus[6] & 0xFF);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
        }
        return status;
    }
}

