/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.android.androidcore;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceAccessStatus;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceConnection;
import jp.co.kingjim.tepraprint.sdk.core.command.CommandFilter;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreTapeWidth;

public class AccessManager {
    private final String TAG = this.getClass().getSimpleName();
    DeviceConnection deviceConnection;
    CommandFilter _commandFilter;
    int statusLength;
    int ipaddress;
    boolean processing;

    public AccessManager(DeviceConnection deviceConnection) {
        this.deviceConnection = deviceConnection;
        this._commandFilter = new CommandFilter();
    }

    public DeviceAccessStatus requestAccess() {
        return DeviceAccessStatus.DeviceAccessStatusConnectionSuccess;
    }

    public DeviceAccessStatus releaseAccess() {
        return DeviceAccessStatus.DeviceAccessStatusDisconnectionSuccess;
    }

    public DeviceAccessStatus requestAccessForStatus() {
        return DeviceAccessStatus.DeviceAccessStatusConnectionSuccess;
    }

    public DeviceAccessStatus releaseAccessForStatus() {
        return DeviceAccessStatus.DeviceAccessStatusDisconnectionSuccess;
    }

    public boolean setRequestStatus() {
        return true;
    }

    public boolean resetRequestStatus() {
        return true;
    }

    public Map<String, Integer> getPrinterStatus() {
        HashMap<String, Integer> status = new HashMap<String, Integer>();
        status.put("ST", 0);
        status.put("ER", 0);
        status.put("PP", 0);
        return status;
    }

    public Map<String, String> getDeviceInformation() {
        return null;
    }

    public Map<String, Integer> getPrinterStatusProcessing(Map<String, Integer> status) {
        return this.getPrinterStatus();
    }

    public Map<String, Integer> getPrinterStatusForAfterPrint() {
        return this.getPrinterStatus();
    }

    public void resetPrinter() {
    }

    public boolean getPortStatus() {
        return true;
    }

    public boolean isCancelRequest(boolean cancel, Map<String, Integer> status) {
        return cancel;
    }

    Map<String, Integer> parseStatusFromLwStatus(byte[] lwStatus) {
        HashMap<String, Integer> status = new HashMap<String, Integer>();
        PrintCoreTapeWidth tapeWidth = this._commandFilter.getTapeWidthFromLWStatusTWCode(lwStatus[3] & 0xFF);
        status.put("ST", 0);
        status.put("ER", 0);
        status.put("PP", 0);
        status.put("ER2", 0);
        if (this.statusLength == 8) {
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("TW", lwStatus[3] & 0xFF);
            status.put("TR", lwStatus[4] & 0xFF);
            status.put("EI", lwStatus[5] & 0xFF);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
            status.put("ER2", lwStatus[2] & 0xFF);
        } else if (this.statusLength == 12) {
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("TW", lwStatus[3] & 0xFF);
            status.put("TR", lwStatus[4] & 0xFF);
            status.put("EI", lwStatus[5] & 0xFF);
            status.put("TO", lwStatus[8] & 0xFF);
            status.put("IR", lwStatus[9] & 0xFF);
            status.put("RR", lwStatus[10] & 0xFF);
            status.put("EJ", lwStatus[11] & 0xFF);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
            status.put("ER2", lwStatus[2] & 0xFF);
        } else if (this.statusLength == 20) {
            int pp = ((lwStatus[12] & 0xFF) << 8) + (lwStatus[13] & 0xFF);
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("TW", lwStatus[3] & 0xFF);
            status.put("TR", lwStatus[4] & 0xFF);
            status.put("EI", lwStatus[5] & 0xFF);
            status.put("TO", lwStatus[8] & 0xFF);
            status.put("IR", lwStatus[9] & 0xFF);
            status.put("RR", lwStatus[10] & 0xFF);
            status.put("EJ", lwStatus[11] & 0xFF);
            status.put("PP", pp);
            status.put("ER2", lwStatus[14] & 0xFF);
            status.put("EI2", lwStatus[15] & 0xFF);
            status.put("EJ2", lwStatus[16] & 0xFF);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
            status.put("TC", lwStatus[17] & 0xFF);
            status.put("RC", lwStatus[18] & 0xFF);
            status.put("JI", lwStatus[19] & 0xFF);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
        } else if (this.statusLength == 24) {
            int pp = ((lwStatus[12] & 0xFF) << 8) + (lwStatus[13] & 0xFF);
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("TW", lwStatus[3] & 0xFF);
            status.put("TR", lwStatus[4] & 0xFF);
            status.put("EI", lwStatus[5] & 0xFF);
            status.put("TO", lwStatus[8] & 0xFF);
            status.put("IR", lwStatus[9] & 0xFF);
            status.put("RR", lwStatus[10] & 0xFF);
            status.put("EJ", lwStatus[11] & 0xFF);
            status.put("PP", pp);
            status.put("ER2", lwStatus[14] & 0xFF);
            status.put("EI2", lwStatus[15] & 0xFF);
            status.put("EJ2", lwStatus[16] & 0xFF);
            status.put("TC", lwStatus[17] & 0xFF);
            status.put("RC", lwStatus[18] & 0xFF);
            status.put("JI", lwStatus[19] & 0xFF);
            status.put("TS", lwStatus[20] & 0xFF);
            status.put("T8S", lwStatus[21] & 0xFF);
            status.put("T8O", lwStatus[22] & 0xFF);
            status.put("T8T", lwStatus[23] & 0xFF);
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
        } else if (this.statusLength == 78) {
            int pp = ((lwStatus[12] & 0xFF) << 8) + (lwStatus[13] & 0xFF);
            status.put("ST", lwStatus[1] & 0xFF);
            status.put("ER", lwStatus[2] & 0xFF);
            status.put("TW", lwStatus[3] & 0xFF);
            status.put("TR", lwStatus[4] & 0xFF);
            status.put("EI", lwStatus[5] & 0xFF);
            status.put("TO", lwStatus[8] & 0xFF);
            status.put("IR", lwStatus[9] & 0xFF);
            status.put("RR", lwStatus[10] & 0xFF);
            status.put("EJ", lwStatus[11] & 0xFF);
            status.put("PP", pp);
            status.put("ER2", lwStatus[14] & 0xFF);
            status.put("EI2", lwStatus[15] & 0xFF);
            status.put("EJ2", lwStatus[16] & 0xFF);
            status.put("TC", lwStatus[17] & 0xFF);
            status.put("RC", lwStatus[18] & 0xFF);
            status.put("JI", lwStatus[19] & 0xFF);
            status.put("TS", lwStatus[20] & 0xFF);
            status.put("T8S", lwStatus[21] & 0xFF);
            status.put("T8O", lwStatus[22] & 0xFF);
            status.put("T8T", lwStatus[23] & 0xFF);
            status.put("T8B", lwStatus[24] & 0xFF);
            int rb = ((lwStatus[25] & 0xFF) << 24) + ((lwStatus[26] & 0xFF) << 16) + ((lwStatus[27] & 0xFF) << 8) + (lwStatus[28] & 0xFF);
            status.put("RB", rb);
            status.put("WA", lwStatus[29] & 0xFF);
            int printingPage = ((lwStatus[30] & 0xFF) << 8) + (lwStatus[31] & 0xFF);
            status.put("PPN", printingPage);
            status.put("TWS", lwStatus[32] & 0xFF);
            status.put("BR", lwStatus[33] & 0xFF);
            int brLengthMM = ((lwStatus[34] & 0xFF) << 24) + ((lwStatus[35] & 0xFF) << 16) + ((lwStatus[36] & 0xFF) << 8) + (lwStatus[37] & 0xFF);
            status.put("BTLM", brLengthMM);
            int brLengthIn = ((lwStatus[38] & 0xFF) << 24) + ((lwStatus[39] & 0xFF) << 16) + ((lwStatus[40] & 0xFF) << 8) + (lwStatus[41] & 0xFF);
            status.put("BTLI", brLengthIn);
            int usingLength = ((lwStatus[42] & 0xFF) << 24) + ((lwStatus[43] & 0xFF) << 16) + ((lwStatus[44] & 0xFF) << 8) + (lwStatus[45] & 0xFF);
            status.put("BTUL", usingLength);
            int labelTotal = ((lwStatus[46] & 0xFF) << 8) + (lwStatus[47] & 0xFF);
            status.put("BLT", labelTotal);
            int labelCount = ((lwStatus[48] & 0xFF) << 8) + (lwStatus[49] & 0xFF);
            status.put("BLC", labelCount);
            int tapeRGBA = ((lwStatus[50] & 0xFF) << 24) + ((lwStatus[51] & 0xFF) << 16) + ((lwStatus[52] & 0xFF) << 8) + (lwStatus[53] & 0xFF);
            status.put("BTR", tapeRGBA);
            int ribbonRGBA = ((lwStatus[54] & 0xFF) << 24) + ((lwStatus[55] & 0xFF) << 16) + ((lwStatus[56] & 0xFF) << 8) + (lwStatus[57] & 0xFF);
            status.put("BRR", ribbonRGBA);
            status.put("BTW", lwStatus[58] & 0xFF);
            int tapeKind = ((lwStatus[59] & 0xFF) << 8) + (lwStatus[60] & 0xFF);
            status.put("BTK", tapeKind);
            status.put("BPS", lwStatus[61] & 0xFF);
            status.put("BO", lwStatus[62] & 0xFF);
            status.put("BPD", lwStatus[63] & 0xFF);
            status.put("BHD", lwStatus[64] & 0xFF);
            status.put("RES3", lwStatus[65] & 0xFF);
            for (int i = 0; i < 12; ++i) {
                status.put("BSN_" + String.valueOf(i + 1), lwStatus[66 + i] & 0xFF);
            }
            status.put("StatusKeyTapeWidth", tapeWidth.getIntValue());
        }
        return status;
    }

    Map<String, String> parseDeviceInformation(byte[] response) {
        HashMap<String, String> deviceInfo = new HashMap<String, String>();
        int packetSize = 32;
        byte[] modelName = Arrays.copyOfRange(response, 0, packetSize);
        byte[] deviceName = Arrays.copyOfRange(response, packetSize, packetSize * 2);
        TepraPrintLogger.d(this.TAG, "GET_LW_INFO: modelName=" + new String(modelName).trim() + ", printerName=" + new String(deviceName).trim());
        deviceInfo.put("usbmdl", new String(modelName).trim());
        deviceInfo.put("name", new String(deviceName).trim());
        return deviceInfo;
    }

    public byte[] getIPAddress() {
        byte[] byteaddr = new byte[]{(byte)(this.ipaddress & 0xFF), (byte)(this.ipaddress >> 8 & 0xFF), (byte)(this.ipaddress >> 16 & 0xFF), (byte)(this.ipaddress >> 24 & 0xFF)};
        return byteaddr;
    }

    public int getBatteryType() {
        return 0;
    }

    public void setBatteryType(int type) {
    }
}

