/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;

public class TepraPrintQRCode {
    public static synchronized Bitmap makeCode(byte[] code, int imageSize, DataCorrectQuality quality) {
        return TepraPrintQRCode.makeCodePrivate(code, imageSize, quality, false, true);
    }

    public static synchronized Bitmap makeCode(byte[] code, int imageSize, DataCorrectQuality quality, boolean hasQuietZone) {
        return TepraPrintQRCode.makeCodePrivate(code, imageSize, quality, false, hasQuietZone);
    }

    public static synchronized Bitmap makeCodePrivate(byte[] code, int imageSize, DataCorrectQuality quality, boolean isAuto) {
        return TepraPrintQRCode.makeCodePrivate(code, imageSize, quality, isAuto, true);
    }

    public static synchronized Bitmap makeCodePrivate(byte[] code, int imageSize, DataCorrectQuality quality, boolean isAuto, boolean hasQuietZone) {
        int quietSize;
        int qualityIndex = Arrays.asList(DataCorrectQuality.values()).indexOf((Object)quality);
        boolean generateResult = TepraPrintQRCode.nativeGenerateQRCode(code, qualityIndex, isAuto);
        if (!generateResult) {
            return null;
        }
        byte[] codeData = TepraPrintQRCode.nativeGetCellData();
        int cellSize = TepraPrintQRCode.nativeGetCellSize();
        int bytesPerRow = (cellSize + 7) / 8;
        int quietZoneX = quietSize = hasQuietZone ? 4 : 0;
        int quietZoneY = quietSize;
        float moduleSize = (float)imageSize / (float)(cellSize + quietZoneY * 2);
        TepraPrintLogger.d("TepraPrintQRCode", "QRCode module size: " + moduleSize);
        moduleSize = 1.0f;
        int qrImageSize = 1;
        if (imageSize > 0) {
            qrImageSize = imageSize;
        }
        imageSize = cellSize + quietSize * 2;
        Bitmap bitmapQRCode = Bitmap.createBitmap((int)imageSize, (int)imageSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        TepraPrintLogger.d("TepraPrintQRCode", "QRCode image size: " + imageSize);
        Canvas canvas = new Canvas(bitmapQRCode);
        float offsetX = moduleSize * (float)quietZoneX;
        float offsetY = moduleSize * (float)quietZoneY;
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setDither(true);
        paint.setStyle(Paint.Style.FILL);
        for (int rowIndex = 0; rowIndex < cellSize; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < cellSize; ++columnIndex) {
                int byteIndex = rowIndex * bytesPerRow + columnIndex / 8;
                int bitIndex = columnIndex % 8;
                if ((codeData[byteIndex] & 128 >> bitIndex) == 0) continue;
                float left = offsetX + (float)columnIndex * moduleSize;
                float top = offsetY + (float)rowIndex * moduleSize;
                canvas.drawRect(left, top, left + moduleSize, top + moduleSize, paint);
            }
        }
        TepraPrintLogger.d("TepraPrintQRCode", "QRCode image width: " + bitmapQRCode.getWidth() + ", qrImageSize=" + qrImageSize);
        if (bitmapQRCode != null && bitmapQRCode.getWidth() != qrImageSize) {
            Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)bitmapQRCode, (int)qrImageSize, (int)qrImageSize, (boolean)false);
            if (bitmapQRCode != bitmap) {
                bitmapQRCode.recycle();
            }
            return bitmap;
        }
        return bitmapQRCode;
    }

    private static native boolean nativeGenerateQRCode(byte[] var0, int var1, boolean var2);

    private static native int nativeGetCellSize();

    private static native byte[] nativeGetCellData();

    static {
        System.loadLibrary("TepraPrint");
    }

    public static enum DataCorrectQuality {
        Low,
        Middle,
        Quality,
        High;

    }
}

