/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import java.util.HashMap;
import java.util.Map;

public class TepraPrintProductInformation {
    public static final String COPYRIGHT = "Copyright 2016-2025 KING JIM CO.,LTD.";
    public static final String TepraPrintProductResolution = "Resolution";
    public static final String TepraPrintProductStatusLength = "Status Length";
    public static final String TepraPrintProductHalfcut = "Halfcut";
    public static final String TepraPrintProductLowSpeed = "LowSpeed";
    public static final String TepraPrintProductKindOfTape = "Kind of Tape";
    public static final String TepraPrintProductCommandLevel = "Command Level";
    public static final String TepraPrintProductResumeJob = "Resume Job";
    public static final String TepraPrintProductModelNumber = "Model Number";
    public static final String TepraPrintProductVersionString = "1.3.0";
    public static final int FIRST_GENERATION_LENGTH = 8;
    public static final int WAFFLE_STATUS_LENGTH = 20;
    public static final int FREEMAN_STATUS_LENGTH = 22;
    public static final int NOTICE_8BIT_MODEL_LENGTH = 24;
    public static final int WOZ_STATUS_LENGTH = 78;
    Map<String, Object> _information = new HashMap<String, Object>();
    private static final int[][] PrintableSizeTable = new int[][]{{0, 0, 0, 0}, {22, 33, 44, 36}, {36, 54, 72, 60}, {54, 81, 108, 90}, {72, 108, 144, 120}, {108, 162, 216, 180}, {128, 192, 288, 238}, {192, 288, 384, 361}, {0, 0, 0, 0}, {0, 0, 0, 0}, {297, 446, 595, 496}, {652, 979, 1305, 1088}, {297, 446, 595, 566}};
    private static final int[] SizeIndexTable = new int[]{180, 270, 360, 300};

    public TepraPrintProductInformation() {
        HashMap<String, String> detail = null;
        detail = new HashMap<String, String>();
        detail.put(TepraPrintProductResolution, "360");
        detail.put(TepraPrintProductStatusLength, String.valueOf(20));
        detail.put(TepraPrintProductHalfcut, "YES");
        detail.put(TepraPrintProductLowSpeed, "YES");
        detail.put(TepraPrintProductCommandLevel, "3");
        detail.put(TepraPrintProductResumeJob, "YES");
        detail.put(TepraPrintProductModelNumber, "4");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6,7");
        this._information.put("TEPRA PRO SR5900P", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "180");
        detail.put(TepraPrintProductStatusLength, String.valueOf(8));
        detail.put(TepraPrintProductHalfcut, "NO");
        detail.put(TepraPrintProductLowSpeed, "NO");
        detail.put(TepraPrintProductCommandLevel, "1");
        detail.put(TepraPrintProductResumeJob, "NO");
        detail.put(TepraPrintProductModelNumber, "5");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6");
        this._information.put("SR5500P", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "180");
        detail.put(TepraPrintProductStatusLength, String.valueOf(22));
        detail.put(TepraPrintProductHalfcut, "NO");
        detail.put(TepraPrintProductLowSpeed, "NO");
        detail.put(TepraPrintProductCommandLevel, "5");
        detail.put(TepraPrintProductResumeJob, "NO");
        detail.put(TepraPrintProductModelNumber, "18");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6");
        this._information.put("SR-R5600P", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "180");
        detail.put(TepraPrintProductStatusLength, String.valueOf(22));
        detail.put(TepraPrintProductHalfcut, "NO");
        detail.put(TepraPrintProductLowSpeed, "NO");
        detail.put(TepraPrintProductCommandLevel, "5");
        detail.put(TepraPrintProductResumeJob, "NO");
        detail.put(TepraPrintProductModelNumber, "19");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6");
        this._information.put("SR-R5600C", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "180");
        detail.put(TepraPrintProductStatusLength, String.valueOf(22));
        detail.put(TepraPrintProductHalfcut, "NO");
        detail.put(TepraPrintProductLowSpeed, "NO");
        detail.put(TepraPrintProductCommandLevel, "5");
        detail.put(TepraPrintProductResumeJob, "NO");
        detail.put(TepraPrintProductModelNumber, "20");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6");
        this._information.put("SR-R5600GS", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "300");
        detail.put(TepraPrintProductStatusLength, String.valueOf(78));
        detail.put(TepraPrintProductHalfcut, "YES");
        detail.put(TepraPrintProductLowSpeed, "YES");
        detail.put(TepraPrintProductCommandLevel, "4");
        detail.put(TepraPrintProductResumeJob, "YES");
        detail.put(TepraPrintProductModelNumber, "6");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6,7,12");
        this._information.put("TEPRA PRO SR-R7900P", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "360");
        detail.put(TepraPrintProductStatusLength, String.valueOf(78));
        detail.put(TepraPrintProductHalfcut, "NO");
        detail.put(TepraPrintProductLowSpeed, "NO");
        detail.put(TepraPrintProductCommandLevel, "5");
        detail.put(TepraPrintProductResumeJob, "NO");
        detail.put(TepraPrintProductModelNumber, "7");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6");
        this._information.put("SR-MK1", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "180");
        detail.put(TepraPrintProductStatusLength, String.valueOf(78));
        detail.put(TepraPrintProductHalfcut, "NO");
        detail.put(TepraPrintProductLowSpeed, "NO");
        detail.put(TepraPrintProductCommandLevel, "5");
        detail.put(TepraPrintProductResumeJob, "NO");
        detail.put(TepraPrintProductModelNumber, "8");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5");
        this._information.put("SR-R2500P", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "360");
        detail.put(TepraPrintProductStatusLength, String.valueOf(20));
        detail.put(TepraPrintProductHalfcut, "YES");
        detail.put(TepraPrintProductLowSpeed, "YES");
        detail.put(TepraPrintProductCommandLevel, "3");
        detail.put(TepraPrintProductResumeJob, "YES");
        detail.put(TepraPrintProductModelNumber, "16");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6,7");
        this._information.put("TEPRA PRO SR5900C", detail);
        detail = new HashMap();
        detail.put(TepraPrintProductResolution, "360");
        detail.put(TepraPrintProductStatusLength, String.valueOf(20));
        detail.put(TepraPrintProductHalfcut, "YES");
        detail.put(TepraPrintProductLowSpeed, "YES");
        detail.put(TepraPrintProductCommandLevel, "3");
        detail.put(TepraPrintProductResumeJob, "YES");
        detail.put(TepraPrintProductModelNumber, "17");
        detail.put(TepraPrintProductKindOfTape, "1,2,3,4,5,6,7");
        this._information.put("TEPRA PRO SR5900GS", detail);
    }

    public static final String getVersion() {
        return TepraPrintProductVersionString;
    }

    public Map<String, String> getInformation(String model) {
        return (Map)this._information.get(model);
    }

    public int getStatusLengthForModel(String model) {
        String productStatusLength;
        int statusLength = 0;
        Map<String, String> productInfo = this.getInformation(model);
        if (productInfo != null && (productStatusLength = productInfo.get(TepraPrintProductStatusLength)) != null) {
            try {
                statusLength = Integer.parseInt(productStatusLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return statusLength;
    }

    public String[] getBonjourSupportModels() {
        String[] models = new String[]{"(KING JIM TEPRA PRO SR5900P)", "SR5500P", "SR-R5600P", "SR-R5600C", "SR-R5600GS", "(KING JIM TEPRA PRO SR-R7900P)", "SR-MK1", "SR-R2500P", "(KING JIM TEPRA PRO SR5900C)", "(KING JIM TEPRA PRO SR5900GS)"};
        return models;
    }

    public Map<String, String> getSupportModels() {
        HashMap<String, String> models = new HashMap<String, String>();
        models.put("SR5900P", "TEPRA PRO SR5900P");
        models.put("SR5500P", "SR5500P");
        models.put("SR-R5600P", "SR-R5600P");
        models.put("SR-R5600C", "SR-R5600C");
        models.put("SR-R5600GS", "SR-R5600GS");
        models.put("SR-R7900P", "TEPRA PRO SR-R7900P");
        models.put("SR-MK1", "SR-MK1");
        models.put("SR-R2500P", "SR-R2500P");
        models.put("SR5900C", "TEPRA PRO SR5900C");
        models.put("SR5900GS", "TEPRA PRO SR5900GS");
        return models;
    }

    public static float getPrintableSize(int tapeWidth, int resolution, int modelNumber) {
        if ((modelNumber == 1300 || modelNumber == 8) && tapeWidth == 5) {
            return 96.0f;
        }
        if (modelNumber == 7 && tapeWidth == 6) {
            return 256.0f;
        }
        if (tapeWidth < 0 || PrintableSizeTable.length <= tapeWidth) {
            tapeWidth = 0;
        }
        int[] table = PrintableSizeTable[tapeWidth];
        int sizeIndex = -1;
        for (int target = 0; target < SizeIndexTable.length; ++target) {
            if (SizeIndexTable[target] != resolution) continue;
            sizeIndex = target;
            break;
        }
        if (sizeIndex == -1) {
            return 0.0f;
        }
        float area = table[sizeIndex];
        return area;
    }
}

