/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Canvas;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDraw;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataTopFrame;
import jp.co.kingjim.tepraprint.sdk.formdata.PlistParser;

public class TepraPrintFormDraw
extends TepraPrintDraw {
    private ObjectDataTopFrame mTopFrame;
    private TepraPrintDataProvider mDataProvider;
    private int mResolution;
    private int mTapeWidth;
    private int mCurrentPage = -1;
    private int mModelNumber;

    public TepraPrintFormDraw(TepraPrintDataProvider provider) {
        this.mDataProvider = provider;
        this.mTopFrame = null;
    }

    public int getResolution() {
        return this.mResolution;
    }

    public void setResolution(int resolution) {
        this.mResolution = resolution;
    }

    public int getTapeWidth() {
        return this.mTapeWidth;
    }

    public void setTapeWidth(int tapeWidth) {
        this.mTapeWidth = tapeWidth;
    }

    public int getModelNumber() {
        return this.mModelNumber;
    }

    public void setModelNumber(int modelNumber) {
        this.mModelNumber = modelNumber;
    }

    @Override
    public void beginJob() {
        if (this.mDataProvider != null) {
            this.mDataProvider.startOfPrint();
        }
        this.mCurrentPage = -1;
    }

    @Override
    public void endJob() {
        if (this.mDataProvider != null) {
            this.mDataProvider.endOfPrint();
        }
    }

    @Override
    public void beginPage(int pageIndex) {
        if (this.mDataProvider == null) {
            return;
        }
        this.mDataProvider.startPage();
        InputStream data = this.mDataProvider.getFormDataForPage(pageIndex);
        Object plistMap = PlistParser.parse(data, false);
        if (plistMap == null) {
            TepraPrintLogger.d("Print SDK error!", "InputStream of the form data is incorrect.");
            return;
        }
        if (!(plistMap instanceof Map)) {
            TepraPrintLogger.d("Print SDK error!", "the root object of the form data is not \"Map\".");
            return;
        }
        Map objectInfo = (Map)plistMap;
        HashMap<String, Object> contextInfo = new HashMap<String, Object>();
        contextInfo.put("ObjectParameterResolution", this.mResolution);
        contextInfo.put("ObjectParameterTapeWidth", this.mTapeWidth);
        contextInfo.put("ObjectParameterModelNumber", this.mModelNumber);
        this.mTopFrame = new ObjectDataTopFrame(objectInfo, contextInfo, this.mDataProvider);
        this.mCurrentPage = pageIndex;
        this.mTopFrame.setPage(this.mCurrentPage);
    }

    @Override
    public void endPage() {
        if (this.mDataProvider != null) {
            this.mDataProvider.endPage();
        }
        this.mTopFrame = null;
    }

    @Override
    public int getNumberOfPages() {
        return this.mDataProvider != null ? this.mDataProvider.getNumberOfPages() : 0;
    }

    @Override
    public int getContentWidthForPage(int pageIndex) {
        int contentWidth = 0;
        if (this.mTopFrame != null) {
            this.mTopFrame.setPage(pageIndex);
            contentWidth = (int)this.mTopFrame.getCurrentBounds().width();
        }
        return contentWidth;
    }

    @Override
    public int getPreviewHeightForPage(int pageIndex) {
        return this.getContentHeightForPage(pageIndex);
    }

    @Override
    public int getContentHeightForPage(int pageIndex) {
        int contentHeight = 0;
        if (this.mTopFrame != null) {
            this.mTopFrame.setPage(pageIndex);
            contentHeight = (int)this.mTopFrame.getCurrentBounds().height();
        }
        return contentHeight;
    }

    @Override
    public int getContentMarginForPage(int pageIndex) {
        int contentMargin = 0;
        if (this.mTopFrame != null) {
            this.mTopFrame.setPage(pageIndex);
            contentMargin = (int)this.mTopFrame.getMarginsValue();
        }
        return contentMargin;
    }

    @Override
    public void drawContentForPreview(Canvas canvas, int pageIndex) {
        canvas.drawColor(-1);
        this.drawContent(canvas, pageIndex);
    }

    @Override
    public void drawContent(Canvas canvas, int pageIndex) {
        if (this.mTopFrame == null) {
            return;
        }
        if (pageIndex != this.mCurrentPage) {
            this.mTopFrame.setPage(pageIndex);
            this.mCurrentPage = pageIndex;
        }
        this.mTopFrame.drawContent(canvas);
    }
}

