/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.ArrayList;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDotbydotDraw;

public class TepraPrintDotbydotDrawFromByteArray
extends TepraPrintDotbydotDraw {
    private ArrayList<byte[]> mByteArrayList;
    private Bitmap mBitmap;

    public TepraPrintDotbydotDrawFromByteArray(TepraPrintDataProvider provider, ArrayList<byte[]> byteArrayList, int margin) {
        super(provider, new ArrayList<Bitmap>(), margin);
        this.mByteArrayList = byteArrayList;
    }

    @Override
    public void beginPage(int pageIndex) {
        float min;
        if (this.mDataProvider != null) {
            this.mDataProvider.startPage();
        }
        if (this.mByteArrayList != null) {
            byte[] byteArray = this.mByteArrayList.get(pageIndex - 1);
            this.mBitmap = BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
            this._imageRect = new RectF(0.0f, 0.0f, (float)this.mBitmap.getWidth(), (float)this.mBitmap.getHeight());
        }
        float dataLength = this._imageRect.width();
        int resolution = super.getResolution();
        float value = (float)this._margin / 25.4f * (float)resolution;
        this._marginValue = value < (min = 0.0f) ? min : value;
        if (dataLength < this._marginValue) {
            this._marginValue = dataLength;
        }
    }

    @Override
    public void endPage() {
        if (this.mDataProvider != null) {
            this.mDataProvider.endPage();
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.mByteArrayList != null ? this.mByteArrayList.size() : 0;
    }

    public ArrayList<byte[]> getPrintDataByteArray() {
        return this.mByteArrayList;
    }

    @Override
    public void drawContent(Canvas canvas, int pageIndex) {
        canvas.save();
        if (this.mBitmap != null) {
            Paint paint = new Paint();
            paint.setAntiAlias(false);
            Rect srcRect = new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
            RectF dstRect = new RectF();
            dstRect.left = 0.0f;
            dstRect.top = 0.0f;
            dstRect.right = dstRect.left + (float)this.mBitmap.getWidth();
            dstRect.bottom = dstRect.top + (float)this.mBitmap.getHeight();
            canvas.drawBitmap(this.mBitmap, srcRect, dstRect, paint);
        }
        canvas.restore();
    }
}

