/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.ArrayList;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDraw;

public class TepraPrintDotbydotDraw
extends TepraPrintDraw {
    protected TepraPrintDataProvider mDataProvider;
    private int mResolution;
    private int mTapeWidth;
    private int mModelNumber;
    private ArrayList<Bitmap> mBitmapArray;
    protected int _margin;
    protected float _marginValue;
    protected RectF _imageRect;

    public TepraPrintDotbydotDraw(TepraPrintDataProvider provider, ArrayList<Bitmap> bitmapArray, int margin) {
        this.mDataProvider = provider;
        this.mBitmapArray = bitmapArray;
        this._margin = margin;
    }

    public int getResolution() {
        return this.mResolution;
    }

    public void setResolution(int resolution) {
        this.mResolution = resolution;
    }

    public int getTapeWidth() {
        return this.mTapeWidth;
    }

    public void setTapeWidth(int tapeWidth) {
        this.mTapeWidth = tapeWidth;
    }

    public int getModelNumber() {
        return this.mModelNumber;
    }

    public void setModelNumber(int modelNumber) {
        this.mModelNumber = modelNumber;
    }

    @Override
    public void beginJob() {
        if (this.mDataProvider != null) {
            this.mDataProvider.startOfPrint();
        }
    }

    @Override
    public void endJob() {
        if (this.mDataProvider != null) {
            this.mDataProvider.endOfPrint();
        }
    }

    @Override
    public void beginPage(int pageIndex) {
        if (this.mDataProvider != null) {
            this.mDataProvider.startPage();
        }
        if (this.mBitmapArray != null) {
            Bitmap bitmap = this.mBitmapArray.get(pageIndex - 1);
            this._imageRect = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        }
        float dataLength = this._imageRect.width();
        float value = (float)this._margin / 25.4f * (float)this.mResolution;
        float min = 0.0f;
        this._marginValue = value < min ? min : value;
        if (dataLength < this._marginValue) {
            this._marginValue = dataLength;
        }
    }

    @Override
    public void endPage() {
        if (this.mDataProvider != null) {
            this.mDataProvider.endPage();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.mBitmapArray != null ? this.mBitmapArray.size() : 0;
    }

    public ArrayList<Bitmap> getPrintDataArray() {
        return this.mBitmapArray;
    }

    @Override
    public int getContentWidthForPage(int pageIndex) {
        return (int)this._imageRect.width();
    }

    @Override
    public int getContentHeightForPage(int pageIndex) {
        return (int)this._imageRect.height();
    }

    @Override
    public int getContentMarginForPage(int pageIndex) {
        return (int)this._marginValue;
    }

    @Override
    public void drawContent(Canvas canvas, int pageIndex) {
        canvas.save();
        Bitmap bitmap = this.mBitmapArray.get(pageIndex - 1);
        if (bitmap != null) {
            Paint paint = new Paint();
            paint.setAntiAlias(false);
            Rect srcRect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF dstRect = new RectF();
            dstRect.left = 0.0f;
            dstRect.top = 0.0f;
            dstRect.right = dstRect.left + (float)bitmap.getWidth();
            dstRect.bottom = dstRect.top + (float)bitmap.getHeight();
            canvas.drawBitmap(bitmap, srcRect, dstRect, paint);
        }
        canvas.restore();
    }
}

