/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import java.util.ArrayList;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDiscoverPrinter;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;

@TargetApi(value=14)
public class TepraPrintDiscoverPrinterWifiDirect
implements WifiP2pManager.PeerListListener,
WifiP2pManager.ConnectionInfoListener {
    private final String TAG = this.getClass().getSimpleName();
    private Context mContext;
    private TepraPrintDiscoverPrinter mDiscoverPrinter;
    private static final int WIFIDIRECT_CATEGORY_PRINTERS = 3;
    private static final int WIFIDIRECT_SUB_CATEGORY_PRINTER = 1;
    private WifiP2pManager p2pManager;
    private WifiP2pManager.Channel channel;
    private boolean mConnected;
    private WifiP2pDevice mConnectedDevice;
    private String mGroupOwnerIP;
    private Object lockObject = new Object();
    private final BroadcastReceiver wifiDirectReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("wifi_p2p_state", -1);
                if (state == 2) {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: state changed - enabled");
                } else {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: state changed - disabled");
                }
            } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
                if (TepraPrintDiscoverPrinterWifiDirect.this.p2pManager == null) {
                    return;
                }
                try {
                    TepraPrintDiscoverPrinterWifiDirect.this.p2pManager.requestPeers(TepraPrintDiscoverPrinterWifiDirect.this.channel, (WifiP2pManager.PeerListListener)TepraPrintDiscoverPrinterWifiDirect.this);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: peers changed");
            } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action)) {
                if (TepraPrintDiscoverPrinterWifiDirect.this.p2pManager == null) {
                    return;
                }
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                if (networkInfo.isConnected()) {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: connection changed - connected");
                    TepraPrintDiscoverPrinterWifiDirect.this.p2pManager.requestConnectionInfo(TepraPrintDiscoverPrinterWifiDirect.this.channel, (WifiP2pManager.ConnectionInfoListener)TepraPrintDiscoverPrinterWifiDirect.this);
                } else {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: connection changed - disconnected");
                }
            } else if ("android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
                WifiP2pDevice device = (WifiP2pDevice)intent.getParcelableExtra("wifiP2pDevice");
                String status = TepraPrintDiscoverPrinterWifiDirect.this.getDeviceStatus(device.status);
                TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: this device changed - " + status);
                if (device.status == 0) {
                    TepraPrintDiscoverPrinterWifiDirect.this.mConnected = true;
                } else {
                    TepraPrintDiscoverPrinterWifiDirect.this.mConnected = false;
                    TepraPrintDiscoverPrinterWifiDirect.this.mConnectedDevice = null;
                    TepraPrintDiscoverPrinterWifiDirect.this.mGroupOwnerIP = "";
                }
            }
        }
    };

    public TepraPrintDiscoverPrinterWifiDirect(Context context, TepraPrintDiscoverPrinter discoverPrinter) {
        this.mContext = context;
        this.mDiscoverPrinter = discoverPrinter;
        this.p2pManager = (WifiP2pManager)context.getSystemService("wifip2p");
        this.channel = this.p2pManager.initialize(context, context.getMainLooper(), null);
        TepraPrintLogger.d(this.TAG, "Wi-Fi P2P: initialize success");
    }

    public void startDiscover() {
        this.mConnected = false;
        this.mConnectedDevice = null;
        this.mGroupOwnerIP = "";
        new AsyncTask<Object, Object, Object>(){

            protected Object doInBackground(Object ... params) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.net.wifi.p2p.STATE_CHANGED");
                filter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
                filter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
                filter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
                if (Build.VERSION.SDK_INT >= 33) {
                    Context context = TepraPrintDiscoverPrinterWifiDirect.this.mContext;
                    BroadcastReceiver broadcastReceiver = TepraPrintDiscoverPrinterWifiDirect.this.wifiDirectReceiver;
                    TepraPrintDiscoverPrinterWifiDirect.this.mContext;
                    context.registerReceiver(broadcastReceiver, filter, 2);
                } else {
                    TepraPrintDiscoverPrinterWifiDirect.this.mContext.registerReceiver(TepraPrintDiscoverPrinterWifiDirect.this.wifiDirectReceiver, filter);
                }
                TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: registerReceiver success");
                try {
                    TepraPrintDiscoverPrinterWifiDirect.this.p2pManager.discoverPeers(TepraPrintDiscoverPrinterWifiDirect.this.channel, new WifiP2pManager.ActionListener(){

                        public void onSuccess() {
                            TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: discovery initiated");
                            TepraPrintDiscoverPrinterWifiDirect.this.p2pManager.requestConnectionInfo(TepraPrintDiscoverPrinterWifiDirect.this.channel, (WifiP2pManager.ConnectionInfoListener)TepraPrintDiscoverPrinterWifiDirect.this);
                        }

                        public void onFailure(int reason) {
                            TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: discovery failed - " + reason);
                        }
                    });
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }.execute(new Object[0]);
    }

    public void stopDiscover() {
        try {
            this.mContext.unregisterReceiver(this.wifiDirectReceiver);
            TepraPrintLogger.d(this.TAG, "Wi-Fi P2P: unregisterReceiver success");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disConnectDevice() {
        if (this.p2pManager != null) {
            this.p2pManager.removeGroup(this.channel, new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: disconnect success");
                }

                public void onFailure(int reason) {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinterWifiDirect.this.TAG, "Wi-Fi P2P: disconnect failed - " + reason);
                }
            });
        }
    }

    public void onPeersAvailable(WifiP2pDeviceList deviceList) {
        ArrayList devices = new ArrayList();
        devices.clear();
        devices.addAll(deviceList.getDeviceList());
        TepraPrintLogger.d(this.TAG, "Wi-Fi P2P: found devices=" + devices.size());
        for (int i = 0; i < devices.size(); ++i) {
            final WifiP2pDevice device = (WifiP2pDevice)devices.get(i);
            TepraPrintLogger.d(this.TAG, "Wi-Fi P2P: found device[" + i + "] - Device=" + device.deviceName + ", deviceAddress=" + device.deviceAddress + ", primary type=" + device.primaryDeviceType + ", status=" + this.getDeviceStatus(device.status));
            if (device.status != 0 || "".equals(this.mGroupOwnerIP) || !this.isSearchModelForWifiDirect(device)) continue;
            this.mConnectedDevice = device;
            if (this.mDiscoverPrinter == null) continue;
            new AsyncTask<Object, Object, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doInBackground(Object ... params) {
                    Object object = TepraPrintDiscoverPrinterWifiDirect.this.lockObject;
                    synchronized (object) {
                        TepraPrintDiscoverPrinterWifiDirect.this.mDiscoverPrinter.addPeersDevice(device.deviceName, TepraPrintDiscoverPrinterWifiDirect.this.mGroupOwnerIP, device.deviceAddress, device.primaryDeviceType, device.status);
                    }
                    return null;
                }
            }.execute(new Object[0]);
        }
    }

    private boolean isSearchModelForWifiDirect(WifiP2pDevice device) {
        boolean ret = false;
        String primaryDeviceType = device.primaryDeviceType;
        String[] arrayData = this.split(primaryDeviceType, "-");
        if (arrayData != null && arrayData.length >= 3) {
            String category = arrayData[0];
            String subCategory = arrayData[2];
            String categoryId = String.valueOf(3);
            String subCategoryId = String.valueOf(1);
            if (categoryId.equals(category) && subCategoryId.equals(subCategory)) {
                ret = true;
            }
        }
        return ret;
    }

    private String[] split(String value, String regex) {
        String[] values = new String[]{};
        if (TextUtils.isEmpty((CharSequence)value) || TextUtils.isEmpty((CharSequence)regex)) {
            return values;
        }
        return value.split(regex);
    }

    public void onConnectionInfoAvailable(WifiP2pInfo info) {
        if (info.groupOwnerAddress != null) {
            this.mGroupOwnerIP = info.groupOwnerAddress.getHostAddress();
            TepraPrintLogger.d(this.TAG, "Wi-Fi P2P: Group Owner IP=" + this.mGroupOwnerIP + ", Group Owner=" + info.isGroupOwner);
            if (this.mConnectedDevice != null && this.isSearchModelForWifiDirect(this.mConnectedDevice) && this.mDiscoverPrinter != null) {
                new AsyncTask<Object, Object, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Object doInBackground(Object ... params) {
                        Object object = TepraPrintDiscoverPrinterWifiDirect.this.lockObject;
                        synchronized (object) {
                            TepraPrintDiscoverPrinterWifiDirect.this.mDiscoverPrinter.addPeersDevice(((TepraPrintDiscoverPrinterWifiDirect)TepraPrintDiscoverPrinterWifiDirect.this).mConnectedDevice.deviceName, TepraPrintDiscoverPrinterWifiDirect.this.mGroupOwnerIP, ((TepraPrintDiscoverPrinterWifiDirect)TepraPrintDiscoverPrinterWifiDirect.this).mConnectedDevice.deviceAddress, ((TepraPrintDiscoverPrinterWifiDirect)TepraPrintDiscoverPrinterWifiDirect.this).mConnectedDevice.primaryDeviceType, ((TepraPrintDiscoverPrinterWifiDirect)TepraPrintDiscoverPrinterWifiDirect.this).mConnectedDevice.status);
                        }
                        return null;
                    }
                }.execute(new Object[0]);
            }
        }
    }

    private String getDeviceStatus(int deviceStatus) {
        switch (deviceStatus) {
            case 3: {
                return "Available";
            }
            case 1: {
                return "Invited";
            }
            case 0: {
                return "Connected";
            }
            case 2: {
                return "Failed";
            }
            case 4: {
                return "Unavailable";
            }
        }
        return "Unknown";
    }
}

