/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelUuid;
import android.text.TextUtils;
import android.text.format.Formatter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.kingjim.tepraprint.sdk.TepraPrint;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDiscoverConnectionType;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDiscoverPrinterCallback;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDiscoverPrinterWifiDirect;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.DeviceManagerBLE;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceEvent;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceListener;

public class TepraPrintDiscoverPrinter {
    private final String TAG = this.getClass().getSimpleName();
    public static final String PRINTER_INFO_NAME = "name";
    public static final String PRINTER_INFO_PRODUCT = "product";
    public static final String PRINTER_INFO_USBMDL = "usbmdl";
    public static final String PRINTER_INFO_HOST = "host";
    public static final String PRINTER_INFO_PORT = "port";
    public static final String PRINTER_INFO_TYPE = "type";
    public static final String PRINTER_INFO_DOMAIN = "domain";
    public static final String PRINTER_INFO_SERIAL_NUMBER = "Serial Number";
    public static final String PRINTER_INFO_DEVICE_CLASS = "Device Class";
    public static final String PRINTER_INFO_DEVICE_STATUS = "Device Status";
    private static final int RETRY_COUNT = 3;
    public static final int BLUETOOTHCLASS_DEVICE_MAJOR_IMAGING = 1536;
    public static final int BLUETOOTHCLASS_DEVICE_PRINTER = 1664;
    private Context _context;
    private WifiManager wifi;
    private static WifiManager.MulticastLock lock;
    private NsdManager dns;
    private String[] types;
    private String[] _models;
    private TepraPrintDiscoverPrinterCallback listener = null;
    private DiscoverBluetoothTask discoverBluetoothTask;
    private DiscoverBLETask discoverBLETask;
    private DiscoverBluetoothAndBLETask discoverBluetoothAndBLETask;
    private BluetoothAdapter btAdapter;
    private boolean isBluetoothSupported;
    private BluetoothLeScanner bluetoothLeScanner;
    private final ScanFilter scanFilter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(DeviceManagerBLE.Uuid.DSPS_SERVICE)).build();
    private final List<ScanFilter> scanFilters = Collections.singletonList(this.scanFilter);
    private final ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(1).build();
    private Object lockObject = new Object();
    private EnumSet<TepraPrintDiscoverConnectionType> _connectionType;
    private boolean modeBluetooth = false;
    private TepraPrintDiscoverPrinterWifiDirect mWifiDirectManager;
    private TepraPrint tepraPrint;
    private List<String> mListCache;
    private static final int TIMER_DELAY = 8000;
    private static final int TIMER_PERIOD = 8000;
    private static final int RESTART_TIMEOUT = 10000;
    private Timer timer;
    private int mNotifyCount;
    private volatile boolean mRestarting;
    private volatile boolean mStopDiscover;
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (device.getBondState() != 12) {
                    BluetoothClass bluetoothClass = device.getBluetoothClass();
                    String deviceClassName = bluetoothClass != null ? TepraPrintDiscoverPrinter.this.getBTDeviceClass(bluetoothClass.getDeviceClass()) : "Unknown";
                    TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "BluetoothDevice.ACTION_FOUND: Device name=" + device.getName() + ", MAC address=" + device.getAddress() + ", Device Class=" + deviceClassName);
                    if (bluetoothClass != null && TepraPrintDiscoverPrinter.this.listener != null && TepraPrintDiscoverPrinter.this.isSearchModelForBluetooth(device)) {
                        Map printerInfo = TepraPrintDiscoverPrinter.this.makePrinterInfoFromBluetoothDevice(device);
                        Object object = TepraPrintDiscoverPrinter.this.lockObject;
                        synchronized (object) {
                            TepraPrintDiscoverPrinter.this.listener.onFindPrinter(TepraPrintDiscoverPrinter.this, printerInfo);
                        }
                    }
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "BluetoothDevice.ACTION_DISCOVERY_FINISHED");
            }
        }
    };
    private ServiceListener serviceListener = new ServiceListener(){

        @Override
        public void serviceAdded(ServiceEvent ev) {
            TepraPrintLogger.d("TepraPrintDiscoverPrinter", "Service Added: name:" + ev.getName() + " type:" + ev.getType());
            if (TepraPrintDiscoverPrinter.this.dns != null) {
                TepraPrintDiscoverPrinter.this.dns.requestServiceInfo(ev.getType(), ev.getName(), 1L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceRemoved(ServiceEvent ev) {
            String host = null;
            InetAddress[] hosts = ev.getInfo().getInetAddresses();
            if (hosts != null && hosts.length > 0) {
                host = hosts[0].getHostAddress();
            }
            String productName = "";
            String usbMDL = "";
            try {
                productName = this.parseServiceInfo(ev.getInfo().getTextBytes(), TepraPrintDiscoverPrinter.PRINTER_INFO_PRODUCT);
                usbMDL = this.parseServiceInfo(ev.getInfo().getTextBytes(), "usb_MDL");
            }
            catch (Exception exception) {
                // empty catch block
            }
            TepraPrintLogger.d("TepraPrintDiscoverPrinter", "Service Removed: name:" + ev.getInfo().getName() + " host:" + host + " port:" + ev.getInfo().getPort() + " type:" + ev.getInfo().getType() + " domain:" + ev.getInfo().getDomain() + " product:" + productName + " usb_MDL:" + usbMDL);
            if (TepraPrintDiscoverPrinter.this.listener != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_NAME, ev.getInfo().getName());
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_PRODUCT, productName);
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_USBMDL, usbMDL);
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_HOST, host);
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_PORT, String.valueOf(ev.getInfo().getPort()));
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_TYPE, ev.getInfo().getType());
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_DOMAIN, ev.getInfo().getDomain());
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_SERIAL_NUMBER, "");
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_DEVICE_CLASS, "");
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_DEVICE_STATUS, "");
                map.put(ev.getName(), null);
                Object object = TepraPrintDiscoverPrinter.this.lockObject;
                synchronized (object) {
                    TepraPrintDiscoverPrinter.this.listener.onRemovePrinter(TepraPrintDiscoverPrinter.this, map);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceResolved(ServiceEvent ev) {
            String host = null;
            InetAddress[] hosts = ev.getInfo().getInetAddresses();
            if (hosts != null && hosts.length > 0) {
                host = hosts[0].getHostAddress();
            }
            String productName = "";
            String usbMDL = "";
            try {
                productName = this.parseServiceInfo(ev.getInfo().getTextBytes(), TepraPrintDiscoverPrinter.PRINTER_INFO_PRODUCT);
                usbMDL = this.parseServiceInfo(ev.getInfo().getTextBytes(), "usb_MDL");
            }
            catch (Exception exception) {
                // empty catch block
            }
            TepraPrintLogger.d("TepraPrintDiscoverPrinter", "Service Resolved: name:" + ev.getInfo().getName() + " host:" + host + " port:" + ev.getInfo().getPort() + " type:" + ev.getInfo().getType() + " domain:" + ev.getInfo().getDomain() + " product:" + productName + " usb_MDL:" + usbMDL);
            if (TepraPrintDiscoverPrinter.this.listener != null && TepraPrintDiscoverPrinter.this.isSearchModel(productName)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_NAME, ev.getInfo().getName());
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_PRODUCT, productName);
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_USBMDL, usbMDL);
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_HOST, host);
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_PORT, String.valueOf(ev.getInfo().getPort()));
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_TYPE, ev.getInfo().getType());
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_DOMAIN, ev.getInfo().getDomain());
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_SERIAL_NUMBER, "");
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_DEVICE_CLASS, "");
                map.put(TepraPrintDiscoverPrinter.PRINTER_INFO_DEVICE_STATUS, "");
                Object object = TepraPrintDiscoverPrinter.this.lockObject;
                synchronized (object) {
                    TepraPrintDiscoverPrinter.this.listener.onFindPrinter(TepraPrintDiscoverPrinter.this, map);
                }
            }
        }

        private String parseServiceInfo(byte[] data, String targetKey) {
            String targetValue = "";
            String tmpData = new String(data);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < data.length; ++i) {
                int num = data[i] & 0xFF;
                String s = tmpData.substring(i + 1, i + 1 + num);
                String key = "";
                String value = "";
                int index = s.indexOf("=");
                if (index != -1) {
                    key = s.substring(0, index);
                    value = s.substring(index + 1);
                    map.put(key, value);
                }
                i += num;
            }
            if (map.containsKey(targetKey)) {
                targetValue = (String)map.get(targetKey);
            }
            return targetValue;
        }
    };

    public TepraPrintDiscoverPrinter() {
        this._models = new TepraPrintProductInformation().getBonjourSupportModels();
        this._connectionType = EnumSet.of(TepraPrintDiscoverConnectionType.ConnectionTypeAll);
    }

    public TepraPrintDiscoverPrinter(List<String> types) {
        this();
        if (types != null && types.size() > 0) {
            this.types = types.toArray(new String[types.size()]);
        }
    }

    public TepraPrintDiscoverPrinter(List<String> types, List<String> models, EnumSet<TepraPrintDiscoverConnectionType> connectionType) {
        if (types != null && types.size() > 0) {
            this.types = types.toArray(new String[types.size()]);
        }
        this._models = models != null && models.size() > 0 ? models.toArray(new String[models.size()]) : new TepraPrintProductInformation().getBonjourSupportModels();
        this._connectionType = connectionType;
    }

    public void setCallback(TepraPrintDiscoverPrinterCallback callback) {
        this.listener = callback;
    }

    public void enableMulticastOnWifi(Context context) {
        if (context != null && lock == null) {
            this.wifi = (WifiManager)context.getSystemService("wifi");
            if (this.wifi != null) {
                try {
                    lock = this.wifi.createMulticastLock("Print SDK");
                    lock.setReferenceCounted(true);
                    lock.acquire();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void disableMulticastOnWifi() {
        try {
            if (lock != null && lock.isHeld()) {
                lock.release();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        finally {
            lock = null;
        }
    }

    public void startDiscover(Context context) {
        TepraPrintLogger.d(this.TAG, "startDiscover: starting...");
        this._context = context;
        this.mRestarting = false;
        this.mStopDiscover = false;
        this.startDiscoverWifi(true);
        boolean bl = this.modeBluetooth = this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeAll) || this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBluetooth) || this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBLE);
        if (this.modeBluetooth) {
            this.isBluetoothSupported = this.createAdapter();
        }
        if (this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeAll) || this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBluetooth) && this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBLE)) {
            this.discoverBluetoothAndBLETask = new DiscoverBluetoothAndBLETask();
            this.discoverBluetoothAndBLETask.startTask();
        } else if (this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBluetooth)) {
            this.discoverBluetoothTask = new DiscoverBluetoothTask();
            this.discoverBluetoothTask.startTask();
        } else if (this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBLE)) {
            this.discoverBLETask = new DiscoverBLETask();
            this.discoverBLETask.startTask();
        }
        TepraPrintLogger.d(this.TAG, "startDiscover: started by " + this._connectionType);
    }

    private void startDiscoverWifi(boolean monitoring) {
        boolean modeNetwork;
        boolean enableMulticast = false;
        for (int i = 0; i < 3; ++i) {
            this.enableMulticastOnWifi(this._context);
            if (this.wifi == null || lock == null) continue;
            enableMulticast = true;
            TepraPrintLogger.d(this.TAG, "startDiscoverWifi: MulticastLock acquire success");
            break;
        }
        if (!enableMulticast) {
            TepraPrintLogger.d(this.TAG, "startDiscoverWifi: MulticastLock acquire failure");
            return;
        }
        boolean bl = modeNetwork = this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeAll) || this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeNetwork);
        if (modeNetwork) {
            this.mNotifyCount = 0;
            if (monitoring) {
                TepraPrintLogger.d(this.TAG, "startDiscoverWifi: start discover Wi-Fi and Wi-Fi Direct");
                new DiscoverWifiTask().execute(new Object[0]);
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (!TepraPrintDiscoverPrinter.this.mStopDiscover && TepraPrintDiscoverPrinter.this.mNotifyCount == 0) {
                            TepraPrintDiscoverPrinter.this.mRestarting = true;
                            TepraPrintDiscoverPrinter.this.restartDiscoverWifi();
                        }
                    }
                };
                this.timer.schedule(task, 8000L, 8000L);
            } else {
                if (this.mStopDiscover) {
                    this.mRestarting = false;
                    return;
                }
                TepraPrintLogger.d(this.TAG, "startDiscoverWifi: start discover Bonjour");
                new DiscoverBonjourTask().execute(new Object[0]);
            }
        }
    }

    private void restartDiscoverWifi() {
        TepraPrintLogger.d(this.TAG, "restartDiscoverWifi: restarting...");
        this.closeNsdManager();
        if (this.mStopDiscover) {
            this.mRestarting = false;
            return;
        }
        this.startDiscoverWifi(false);
        TepraPrintLogger.d(this.TAG, "restartDiscoverWifi: restarted");
    }

    @TargetApi(value=11)
    private <T> void executeAsyncTask(AsyncTask<T, ?, ?> task) {
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
        } else {
            task.execute(new Object[0]);
        }
    }

    @TargetApi(value=11)
    private <T> void executeAsyncTask(AsyncTask<T, ?, ?> task, T ... params) {
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])params);
        } else {
            task.execute((Object[])params);
        }
    }

    private boolean createAdapter() {
        try {
            this.btAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "Can not get default bluetooth adapter", e);
            return false;
        }
        return this.btAdapter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getPairedDevices() {
        try {
            Set pairedDevices = this.btAdapter.getBondedDevices();
            if (pairedDevices.size() <= 0) return;
            for (BluetoothDevice device : pairedDevices) {
                BluetoothClass bluetoothClass = device.getBluetoothClass();
                String deviceClassName = bluetoothClass != null ? this.getBTDeviceClass(bluetoothClass.getDeviceClass()) : "Unknown";
                TepraPrintLogger.d(this.TAG, "Bluetooth Bonded Devices: Device name=" + device.getName() + ", MAC address=" + device.getAddress() + ", Device Class=" + deviceClassName);
                if (bluetoothClass == null || this.listener == null || !this.isSearchModelForBluetooth(device)) continue;
                Map<String, String> printerInfo = this.makePrinterInfoFromBluetoothDevice(device);
                Object object = this.lockObject;
                synchronized (object) {
                    this.listener.onFindPrinter(this, printerInfo);
                }
            }
            return;
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "Can not get bonded devices", e);
        }
    }

    private boolean isSearchModelForBluetooth(BluetoothDevice device) {
        boolean ret = false;
        BluetoothClass bluetoothClass = device.getBluetoothClass();
        if (bluetoothClass != null) {
            int majorDeviceClass = bluetoothClass.getMajorDeviceClass();
            int deviceClass = bluetoothClass.getDeviceClass();
            String deviceName = device.getName();
            if (majorDeviceClass == 1536 && deviceClass == 1664 && !TextUtils.isEmpty((CharSequence)deviceName)) {
                for (int i = 0; i < this._models.length; ++i) {
                    if (deviceName.indexOf(this._models[i]) == -1) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private boolean isSearchModelForBLE(BluetoothDevice device, String deviceName) {
        boolean ret = false;
        BluetoothClass bluetoothClass = device.getBluetoothClass();
        if (bluetoothClass != null && !TextUtils.isEmpty((CharSequence)deviceName)) {
            for (String model : this._models) {
                if (!deviceName.contains(model)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private Map<String, String> makePrinterInfoFromBluetoothDevice(BluetoothDevice device) {
        BluetoothClass bluetoothClass = device.getBluetoothClass();
        String deviceClassName = bluetoothClass != null ? this.getBTDeviceClass(bluetoothClass.getDeviceClass()) : "Unknown";
        HashMap<String, String> printerInfo = new HashMap<String, String>();
        printerInfo.put(PRINTER_INFO_NAME, device.getName() == null ? "Unknown" : device.getName());
        printerInfo.put(PRINTER_INFO_DOMAIN, "local.");
        printerInfo.put(PRINTER_INFO_TYPE, "_pdl-datastream._bluetooth.");
        String usbModel = "SR5500P";
        if (device.getName() != null) {
            Map<String, String> models = new TepraPrintProductInformation().getSupportModels();
            for (String model : models.keySet()) {
                if (device.getName().indexOf(model) == -1) continue;
                usbModel = models.get(model);
                break;
            }
        }
        printerInfo.put(PRINTER_INFO_USBMDL, usbModel);
        printerInfo.put(PRINTER_INFO_PRODUCT, usbModel);
        printerInfo.put(PRINTER_INFO_HOST, "");
        printerInfo.put(PRINTER_INFO_PORT, "");
        printerInfo.put(PRINTER_INFO_SERIAL_NUMBER, device.getAddress());
        printerInfo.put(PRINTER_INFO_DEVICE_CLASS, deviceClassName);
        printerInfo.put(PRINTER_INFO_DEVICE_STATUS, "");
        TepraPrintLogger.d("TepraPrintDiscoverPrinter", "makePrinterInfoFromBluetoothDevice: " + ((Object)printerInfo).toString());
        return printerInfo;
    }

    private Map<String, String> makePrinterInfoFromBLEDevice(BluetoothDevice device, String deviceName) {
        BluetoothClass bluetoothClass = device.getBluetoothClass();
        String deviceClassName = bluetoothClass != null ? this.getBLEDeviceClass(device, deviceName) : "Unknown";
        HashMap<String, String> printerInfo = new HashMap<String, String>();
        printerInfo.put(PRINTER_INFO_NAME, deviceName == null ? "Unknown" : deviceName);
        printerInfo.put(PRINTER_INFO_DOMAIN, "local.");
        printerInfo.put(PRINTER_INFO_TYPE, "_pdl-datastream._ble.");
        String bleModel = "";
        if (deviceName != null) {
            Map<String, String> models = new TepraPrintProductInformation().getSupportModels();
            for (String model : models.keySet()) {
                if (deviceName.indexOf(model) == -1) continue;
                bleModel = models.get(model);
                break;
            }
        }
        printerInfo.put(PRINTER_INFO_USBMDL, bleModel);
        printerInfo.put(PRINTER_INFO_PRODUCT, bleModel);
        printerInfo.put(PRINTER_INFO_HOST, "");
        printerInfo.put(PRINTER_INFO_PORT, "");
        printerInfo.put(PRINTER_INFO_SERIAL_NUMBER, device.getAddress());
        printerInfo.put(PRINTER_INFO_DEVICE_CLASS, deviceClassName);
        printerInfo.put(PRINTER_INFO_DEVICE_STATUS, "");
        TepraPrintLogger.d("TepraPrintDiscoverPrinter", "makePrinterInfoFromBLEDevice: " + ((Object)printerInfo).toString());
        return printerInfo;
    }

    private String getBTDeviceClass(int device) {
        switch (device) {
            case 1076: {
                return "AUDIO_VIDEO_CAMCORDER";
            }
            case 1056: {
                return "AUDIO_VIDEO_CAR_AUDIO";
            }
            case 1032: {
                return "AUDIO_VIDEO_HANDSFREE";
            }
            case 1048: {
                return "AUDIO_VIDEO_HEADPHONES";
            }
            case 1064: {
                return "AUDIO_VIDEO_HIFI_AUDIO";
            }
            case 1044: {
                return "AUDIO_VIDEO_LOUDSPEAKER";
            }
            case 1040: {
                return "AUDIO_VIDEO_MICROPHONE";
            }
            case 1052: {
                return "AUDIO_VIDEO_PORTABLE_AUDIO";
            }
            case 1060: {
                return "AUDIO_VIDEO_SET_TOP_BOX";
            }
            case 1024: {
                return "AUDIO_VIDEO_UNCATEGORIZED";
            }
            case 1068: {
                return "AUDIO_VIDEO_VCR";
            }
            case 1072: {
                return "AUDIO_VIDEO_VIDEO_CAMERA";
            }
            case 1088: {
                return "AUDIO_VIDEO_VIDEO_CONFERENCING";
            }
            case 1084: {
                return "AUDIO_VIDEO_VIDEO_DISPLAY_AND_LOUDSPEAKER";
            }
            case 1096: {
                return "AUDIO_VIDEO_VIDEO_GAMING_TOY";
            }
            case 1080: {
                return "AUDIO_VIDEO_VIDEO_MONITOR";
            }
            case 1028: {
                return "AUDIO_VIDEO_WEARABLE_HEADSET";
            }
            case 260: {
                return "COMPUTER_DESKTOP";
            }
            case 272: {
                return "COMPUTER_HANDHELD_PC_PDA";
            }
            case 268: {
                return "COMPUTER_LAPTOP";
            }
            case 276: {
                return "COMPUTER_PALM_SIZE_PC_PDA";
            }
            case 264: {
                return "COMPUTER_SERVER";
            }
            case 256: {
                return "COMPUTER_UNCATEGORIZED";
            }
            case 280: {
                return "COMPUTER_WEARABLE";
            }
            case 2308: {
                return "HEALTH_BLOOD_PRESSURE";
            }
            case 2332: {
                return "HEALTH_DATA_DISPLAY";
            }
            case 2320: {
                return "HEALTH_GLUCOSE";
            }
            case 2324: {
                return "HEALTH_PULSE_OXIMETER";
            }
            case 2328: {
                return "HEALTH_PULSE_RATE";
            }
            case 2312: {
                return "HEALTH_THERMOMETER";
            }
            case 2304: {
                return "HEALTH_UNCATEGORIZED";
            }
            case 2316: {
                return "HEALTH_WEIGHING";
            }
            case 516: {
                return "PHONE_CELLULAR";
            }
            case 520: {
                return "PHONE_CORDLESS";
            }
            case 532: {
                return "PHONE_ISDN";
            }
            case 528: {
                return "PHONE_MODEM_OR_GATEWAY";
            }
            case 524: {
                return "PHONE_SMART";
            }
            case 512: {
                return "PHONE_UNCATEGORIZED";
            }
            case 2064: {
                return "TOY_CONTROLLER";
            }
            case 2060: {
                return "TOY_DOLL_ACTION_FIGURE";
            }
            case 2068: {
                return "TOY_GAME";
            }
            case 2052: {
                return "TOY_ROBOT";
            }
            case 2048: {
                return "TOY_UNCATEGORIZED";
            }
            case 2056: {
                return "TOY_VEHICLE";
            }
            case 1812: {
                return "WEARABLE_GLASSES";
            }
            case 1808: {
                return "WEARABLE_HELMET";
            }
            case 1804: {
                return "WEARABLE_JACKET";
            }
            case 1800: {
                return "WEARABLE_PAGER";
            }
            case 1792: {
                return "WEARABLE_UNCATEGORIZED";
            }
            case 1796: {
                return "WEARABLE_WRIST_WATCH";
            }
            case 1664: {
                return "PRINTER";
            }
        }
        return "UNKNOWN";
    }

    private String getBLEDeviceClass(BluetoothDevice device, String deviceName) {
        if (this.isSearchModelForBLE(device, deviceName)) {
            return "PRINTER";
        }
        int deviceClass = device.getBluetoothClass().getDeviceClass();
        return this.getBTDeviceClass(deviceClass);
    }

    private void doDiscovery() {
        try {
            if (this.btAdapter.isDiscovering()) {
                this.btAdapter.cancelDiscovery();
            }
            this.btAdapter.startDiscovery();
        }
        catch (Exception e) {
            TepraPrintLogger.w(this.TAG, "Can not start discovery", e);
        }
    }

    private boolean isSearchModelForWifiDirect(String modelName) {
        boolean ret = false;
        if (!TextUtils.isEmpty((CharSequence)modelName)) {
            for (int i = 0; i < this._models.length; ++i) {
                if (this._models[i].indexOf(modelName) == -1) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private synchronized Map<String, String> getDeviceInformation(Map<String, String> printerInfo) {
        Map<String, String> deviceInfo = null;
        if (this.tepraPrint != null) {
            this.tepraPrint.setPrinterInformation(printerInfo);
            deviceInfo = this.tepraPrint.getDeviceInformation();
        }
        return deviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeersDevice(String deviceName, String ipAddress, String deviceAddress, String primaryDeviceType, int status) {
        Map<String, String> printerInfo;
        Map<String, String> deviceInfo;
        TepraPrintLogger.d(this.TAG, "Wi-Fi Direct: add peers device - Device name=" + deviceName + ", IP address=" + ipAddress + ", MAC address=" + deviceAddress + ", Device Type=" + primaryDeviceType + ", Device Status=" + status);
        if (!this.mListCache.contains(deviceAddress) && (deviceInfo = this.getDeviceInformation(printerInfo = this.makePrinterInfoFromWifiP2pDevice(deviceName, ipAddress, deviceAddress, primaryDeviceType, status))) != null) {
            String modelName = deviceInfo.get(PRINTER_INFO_USBMDL);
            String printerName = deviceInfo.get(PRINTER_INFO_NAME);
            if (this.listener != null && this.isSearchModelForWifiDirect(modelName)) {
                if (!TextUtils.isEmpty((CharSequence)modelName)) {
                    printerInfo.put(PRINTER_INFO_USBMDL, modelName);
                }
                Object object = this.lockObject;
                synchronized (object) {
                    TepraPrintLogger.d(this.TAG, "Wi-Fi Direct: notify found printer - " + deviceName + "/" + deviceAddress);
                    this.listener.onFindPrinter(this, printerInfo);
                    this.mListCache.add(deviceAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeersDevice(String deviceName, String ipAddress, String deviceAddress, String primaryDeviceType, int status) {
        Map<String, String> printerInfo;
        Map<String, String> deviceInfo;
        TepraPrintLogger.d(this.TAG, "Wi-Fi Direct: remove peers device - Device name=" + deviceName + ", IP address=" + ipAddress + ", MAC address=" + deviceAddress + ", Device Type=" + primaryDeviceType + ", Device Status=" + status);
        if (this.mListCache.contains(deviceAddress) && (deviceInfo = this.getDeviceInformation(printerInfo = this.makePrinterInfoFromWifiP2pDevice(deviceName, ipAddress, deviceAddress, primaryDeviceType, status))) != null) {
            String modelName = deviceInfo.get(PRINTER_INFO_USBMDL);
            String printerName = deviceInfo.get(PRINTER_INFO_NAME);
            if (this.listener != null && this.isSearchModelForWifiDirect(modelName)) {
                if (!TextUtils.isEmpty((CharSequence)modelName)) {
                    printerInfo.put(PRINTER_INFO_USBMDL, modelName);
                }
                Object object = this.lockObject;
                synchronized (object) {
                    TepraPrintLogger.d(this.TAG, "Wi-Fi Direct: notify remove printer - " + deviceName + "/" + deviceAddress);
                    this.listener.onRemovePrinter(this, printerInfo);
                    this.mListCache.remove(deviceAddress);
                }
            }
        }
    }

    private Map<String, String> makePrinterInfoFromWifiP2pDevice(String deviceName, String ipAddress, String deviceAddress, String primaryDeviceType, int status) {
        HashMap<String, String> printerInfo = new HashMap<String, String>();
        printerInfo.put(PRINTER_INFO_NAME, deviceName == null ? "Unknown" : deviceName);
        printerInfo.put(PRINTER_INFO_DOMAIN, "local.");
        printerInfo.put(PRINTER_INFO_TYPE, "_pdl-datastream._wifidirect.");
        String usbModel = "TEPRA PRO SR5900P";
        if (deviceName != null) {
            Map<String, String> models = new TepraPrintProductInformation().getSupportModels();
            for (String model : models.keySet()) {
                if (deviceName.indexOf(model) == -1) continue;
                usbModel = models.get(model);
                break;
            }
        }
        printerInfo.put(PRINTER_INFO_USBMDL, usbModel);
        printerInfo.put(PRINTER_INFO_PRODUCT, deviceName);
        printerInfo.put(PRINTER_INFO_HOST, ipAddress);
        printerInfo.put(PRINTER_INFO_PORT, "");
        printerInfo.put(PRINTER_INFO_SERIAL_NUMBER, deviceAddress);
        printerInfo.put(PRINTER_INFO_DEVICE_CLASS, primaryDeviceType);
        printerInfo.put(PRINTER_INFO_DEVICE_STATUS, String.valueOf(status));
        TepraPrintLogger.d("TepraPrintDiscoverPrinter", "makePrinterInfoFromWifiP2pDevice: " + ((Object)printerInfo).toString());
        return printerInfo;
    }

    public void stopDiscover() {
        TepraPrintLogger.d(this.TAG, "stopDiscover is called - restarting=" + this.mRestarting);
        this.mStopDiscover = true;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        long start = System.currentTimeMillis();
        while (this.mRestarting && System.currentTimeMillis() - start <= 10000L) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        TepraPrintLogger.d(this.TAG, "stopDiscover: stopping...");
        this.listener = null;
        if (Build.VERSION.SDK_INT >= 14 && this.mWifiDirectManager != null) {
            this.mWifiDirectManager.stopDiscover();
            this.mWifiDirectManager = null;
        }
        if (this.modeBluetooth) {
            if (this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeAll) || this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBluetooth) && this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBLE)) {
                this.discoverBluetoothAndBLETask.stopTask();
            } else if (this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBluetooth)) {
                this.discoverBluetoothTask.stopTask();
            } else if (this._connectionType.contains((Object)TepraPrintDiscoverConnectionType.ConnectionTypeBLE)) {
                this.discoverBLETask.stopTask();
            }
            this.btAdapter = null;
        }
        new AsyncTask<Object, Object, Object>(){

            protected Object doInBackground(Object ... params) {
                TepraPrintDiscoverPrinter.this.closeNsdManager();
                return null;
            }

            protected void onPostExecute(Object result) {
                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "stopDiscover: NsdManager closed");
            }
        }.execute(new Object[0]);
        TepraPrintLogger.d(this.TAG, "stopDiscover: stopped");
    }

    private void closeNsdManager() {
        this.disableMulticastOnWifi();
        if (this.dns != null) {
            if (this.types != null) {
                for (int i = 0; i < this.types.length; ++i) {
                    this.dns.removeServiceListener(this.types[i], this.serviceListener);
                }
            }
            this.dns.unregisterAllServices();
            this.dns.close();
            this.dns = null;
        }
    }

    private boolean isSearchModel(String name) {
        boolean ret = false;
        if (this._models != null) {
            if (Arrays.asList(this._models).contains(name)) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public class DiscoverBluetoothAndBLETask {
        private static final int BLE_SCAN_PERIOD = 10000;
        private ExecutorService executorService = Executors.newSingleThreadExecutor();
        private HandlerThread handlerThread = new HandlerThread(this.getClass().getSimpleName());
        private Handler handler;
        private DiscoverBLETask mDiscoverBLETask;
        private volatile boolean isReceiverRegistered = false;

        public DiscoverBluetoothAndBLETask() {
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
        }

        public void startTask() {
            try {
                if (!this.executorService.isShutdown()) {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "DiscoverBluetoothAndBLETask: started");
                    this.executorService.submit(() -> {
                        try {
                            if (!TepraPrintDiscoverPrinter.this.isBluetoothSupported) {
                                TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "Bluetooth is not available");
                            } else if (TepraPrintDiscoverPrinter.this.btAdapter != null && TepraPrintDiscoverPrinter.this.btAdapter.isEnabled()) {
                                TepraPrintDiscoverPrinter.this.getPairedDevices();
                                this.mDiscoverBLETask = new DiscoverBLETask();
                                this.mDiscoverBLETask.startTask();
                                this.handler.postDelayed(() -> {
                                    this.mDiscoverBLETask.stopTask();
                                    this.mDiscoverBLETask = null;
                                    IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
                                    if (Build.VERSION.SDK_INT >= 33) {
                                        TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter, 2);
                                    } else {
                                        TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter);
                                    }
                                    filter = new IntentFilter("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                                    if (Build.VERSION.SDK_INT >= 33) {
                                        TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter, 2);
                                    } else {
                                        TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter);
                                    }
                                    this.isReceiverRegistered = true;
                                    TepraPrintDiscoverPrinter.this.doDiscovery();
                                }, 10000L);
                            } else {
                                TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "Bluetooth is not enabled");
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "Can not start discovery Bluetooth and BLE" + e);
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopTask() {
            try {
                if (!this.executorService.isShutdown()) {
                    this.executorService.submit(() -> {
                        try {
                            if (this.mDiscoverBLETask != null) {
                                this.mDiscoverBLETask.stopTask();
                                this.mDiscoverBLETask = null;
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "BLEStopError: " + e.getMessage());
                        }
                        try {
                            if (TepraPrintDiscoverPrinter.this.btAdapter != null && TepraPrintDiscoverPrinter.this.btAdapter.isDiscovering()) {
                                TepraPrintDiscoverPrinter.this.btAdapter.cancelDiscovery();
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "BluetoothStopError: " + e.getMessage());
                        }
                        finally {
                            try {
                                if (this.isReceiverRegistered) {
                                    TepraPrintDiscoverPrinter.this._context.unregisterReceiver(TepraPrintDiscoverPrinter.this.receiver);
                                    this.isReceiverRegistered = false;
                                }
                            }
                            catch (Exception e) {
                                TepraPrintLogger.w(TepraPrintDiscoverPrinter.this.TAG, "ReceiverUnregisterError: " + e.getMessage());
                            }
                        }
                        this.handler.removeCallbacksAndMessages(null);
                        this.handlerThread.quitSafely();
                        TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "DiscoverBluetoothAndBLETask: stopped");
                    });
                }
                this.executorService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class DiscoverBluetoothTask {
        private ExecutorService executorService = Executors.newSingleThreadExecutor();

        public void startTask() {
            try {
                if (!this.executorService.isShutdown()) {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "DiscoverBluetoothTask: started");
                    this.executorService.submit(() -> {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (!TepraPrintDiscoverPrinter.this.isBluetoothSupported) {
                                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "Bluetooth is not available");
                            } else if (TepraPrintDiscoverPrinter.this.btAdapter != null && TepraPrintDiscoverPrinter.this.btAdapter.isEnabled()) {
                                IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
                                if (Build.VERSION.SDK_INT >= 33) {
                                    TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter, 2);
                                } else {
                                    TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter);
                                }
                                filter = new IntentFilter("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                                if (Build.VERSION.SDK_INT >= 33) {
                                    TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter, 2);
                                } else {
                                    TepraPrintDiscoverPrinter.this._context.registerReceiver(TepraPrintDiscoverPrinter.this.receiver, filter);
                                }
                                TepraPrintDiscoverPrinter.this.getPairedDevices();
                                TepraPrintDiscoverPrinter.this.doDiscovery();
                                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "start discover Bluetooth");
                            } else {
                                TepraPrintLogger.e("TepraPrintDiscoverPrinter", "Bluetooth is not enabled");
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.w("TepraPrintDiscoverPrinter", "", e);
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopTask() {
            try {
                if (!this.executorService.isShutdown()) {
                    this.executorService.submit(() -> {
                        try {
                            if (TepraPrintDiscoverPrinter.this.btAdapter != null && TepraPrintDiscoverPrinter.this.btAdapter.isDiscovering()) {
                                TepraPrintDiscoverPrinter.this.btAdapter.cancelDiscovery();
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "BluetoothStopError: " + e.getMessage());
                        }
                        finally {
                            try {
                                TepraPrintDiscoverPrinter.this._context.unregisterReceiver(TepraPrintDiscoverPrinter.this.receiver);
                            }
                            catch (Exception e) {
                                TepraPrintLogger.w(TepraPrintDiscoverPrinter.this.TAG, "ReceiverUnregisterError: " + e.getMessage());
                            }
                        }
                        TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "DiscoverBluetoothTask: stopped");
                    });
                }
                this.executorService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class DiscoverBLETask {
        private ExecutorService executorService;
        private final Set<String> scannedDevices;
        private final ScanCallback scanCallback = new ScanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onScanResult(int callbackType, ScanResult result) {
                BluetoothDevice device = result.getDevice();
                BluetoothClass bluetoothClass = device.getBluetoothClass();
                String deviceClassName = bluetoothClass != null ? TepraPrintDiscoverPrinter.this.getBTDeviceClass(bluetoothClass.getDeviceClass()) : "Unknown";
                String deviceName = Objects.requireNonNull(result.getScanRecord()).getDeviceName();
                String deviceAddress = device.getAddress();
                if (!DiscoverBLETask.this.scannedDevices.contains(deviceAddress)) {
                    DiscoverBLETask.this.scannedDevices.add(deviceAddress);
                    TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "BLEDevice.ACTION_FOUND: Device name=" + deviceName + ", MAC address=" + deviceAddress + ", Device Class=" + deviceClassName);
                    if (bluetoothClass != null && TepraPrintDiscoverPrinter.this.listener != null && TepraPrintDiscoverPrinter.this.isSearchModelForBLE(device, deviceName)) {
                        Map printerInfo = TepraPrintDiscoverPrinter.this.makePrinterInfoFromBLEDevice(device, deviceName);
                        Object object = TepraPrintDiscoverPrinter.this.lockObject;
                        synchronized (object) {
                            TepraPrintDiscoverPrinter.this.listener.onFindPrinter(TepraPrintDiscoverPrinter.this, printerInfo);
                        }
                    }
                }
                super.onScanResult(callbackType, result);
            }

            public void onScanFailed(int errorCode) {
                TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "BLE Scan failed... Error code: " + errorCode);
                super.onScanFailed(errorCode);
            }
        };

        public DiscoverBLETask() {
            this.executorService = Executors.newSingleThreadExecutor();
            this.scannedDevices = new HashSet<String>();
        }

        public void startTask() {
            try {
                if (!this.executorService.isShutdown()) {
                    TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "DiscoverBLETask: started");
                    this.executorService.submit(() -> {
                        try {
                            if (!TepraPrintDiscoverPrinter.this.isBluetoothSupported) {
                                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "Bluetooth is not available");
                            } else if (TepraPrintDiscoverPrinter.this.btAdapter != null && TepraPrintDiscoverPrinter.this.btAdapter.isEnabled()) {
                                TepraPrintDiscoverPrinter.this.bluetoothLeScanner = TepraPrintDiscoverPrinter.this.btAdapter.getBluetoothLeScanner();
                                if (TepraPrintDiscoverPrinter.this.bluetoothLeScanner != null) {
                                    TepraPrintDiscoverPrinter.this.bluetoothLeScanner.startScan(TepraPrintDiscoverPrinter.this.scanFilters, TepraPrintDiscoverPrinter.this.scanSettings, this.scanCallback);
                                    TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "start discover BLE");
                                } else {
                                    TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "BluetoothLeScanner is not available");
                                }
                            } else {
                                TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "Bluetooth is not enabled");
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "Can not start discovery BLE" + e);
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopTask() {
            try {
                if (!this.executorService.isShutdown()) {
                    this.executorService.submit(() -> {
                        try {
                            if (TepraPrintDiscoverPrinter.this.bluetoothLeScanner != null) {
                                TepraPrintDiscoverPrinter.this.bluetoothLeScanner.stopScan(this.scanCallback);
                            }
                        }
                        catch (Exception e) {
                            TepraPrintLogger.e(TepraPrintDiscoverPrinter.this.TAG, "", e);
                        }
                        finally {
                            TepraPrintDiscoverPrinter.this.bluetoothLeScanner = null;
                            this.scannedDevices.clear();
                        }
                        TepraPrintLogger.d(TepraPrintDiscoverPrinter.this.TAG, "DiscoverBLETask: stopped");
                    });
                }
                this.executorService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class DiscoverWifiTask
    extends DiscoverBonjourTask {
        protected void onPostExecute(Object result) {
            new DiscoverWifiDirectTask().execute(new Object[0]);
        }
    }

    public class DiscoverBonjourTask
    extends AsyncTask<Object, Object, Object> {
        protected Object doInBackground(Object ... params) {
            try {
                WifiInfo wifiinfo = TepraPrintDiscoverPrinter.this.wifi.getConnectionInfo();
                int intaddr = wifiinfo.getIpAddress();
                byte[] byteaddr = new byte[]{(byte)(intaddr & 0xFF), (byte)(intaddr >> 8 & 0xFF), (byte)(intaddr >> 16 & 0xFF), (byte)(intaddr >> 24 & 0xFF)};
                InetAddress addr = InetAddress.getByAddress(byteaddr);
                if (TepraPrintDiscoverPrinter.this.mStopDiscover) {
                    TepraPrintDiscoverPrinter.this.mRestarting = false;
                    return null;
                }
                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "start discover Wi-Fi: IP address=" + Formatter.formatIpAddress((int)intaddr));
                if (TepraPrintDiscoverPrinter.this.dns == null) {
                    TepraPrintDiscoverPrinter.this.dns = new NsdManager(addr);
                }
                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "start discover Wi-Fi: Bonjour started");
            }
            catch (Exception e) {
                TepraPrintLogger.w("TepraPrintDiscoverPrinter", "", e);
            }
            if (TepraPrintDiscoverPrinter.this.types != null) {
                for (int i = 0; i < TepraPrintDiscoverPrinter.this.types.length; ++i) {
                    if (TepraPrintDiscoverPrinter.this.dns == null) continue;
                    TepraPrintDiscoverPrinter.this.dns.addServiceListener(TepraPrintDiscoverPrinter.this.types[i], TepraPrintDiscoverPrinter.this.serviceListener);
                }
            }
            TepraPrintDiscoverPrinter.this.mRestarting = false;
            return null;
        }
    }

    public class DiscoverWifiDirectTask
    extends AsyncTask<Object, Object, Object> {
        protected Object doInBackground(Object ... params) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Build.VERSION.SDK_INT >= 14) {
                if (TepraPrintDiscoverPrinter.this.tepraPrint == null) {
                    TepraPrintDiscoverPrinter.this.tepraPrint = new TepraPrint(TepraPrintDiscoverPrinter.this._context);
                }
                if (TepraPrintDiscoverPrinter.this.mListCache != null) {
                    TepraPrintDiscoverPrinter.this.mListCache.clear();
                    TepraPrintDiscoverPrinter.this.mListCache = null;
                }
                TepraPrintDiscoverPrinter.this.mListCache = new ArrayList();
                if (TepraPrintDiscoverPrinter.this.mWifiDirectManager == null) {
                    try {
                        TepraPrintDiscoverPrinter.this.mWifiDirectManager = new TepraPrintDiscoverPrinterWifiDirect(TepraPrintDiscoverPrinter.this._context, TepraPrintDiscoverPrinter.this);
                    }
                    catch (Exception e) {
                        TepraPrintLogger.w("TepraPrintDiscoverPrinter", "", e);
                        return null;
                    }
                }
                TepraPrintDiscoverPrinter.this.mWifiDirectManager.startDiscover();
                TepraPrintLogger.d("TepraPrintDiscoverPrinter", "start discover Wi-Fi Direct");
            }
            return null;
        }
    }
}

