/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;

public class TepraPrintDataMatrix {
    public static synchronized Bitmap makeCode(byte[] code, ShapeType shape, PrefixType prefix, int quietZoneCount) {
        int shapeIndex = Arrays.asList(ShapeType.values()).indexOf((Object)shape);
        int prefixIndex = Arrays.asList(PrefixType.values()).indexOf((Object)prefix);
        TepraPrintLogger.d("DataMatrix param: code:" + new String(code));
        TepraPrintLogger.d("DataMatrix param: shape:" + shapeIndex + " prefix:" + prefixIndex);
        long[] outputInfo = new long[4];
        byte[] codeData = TepraPrintDataMatrix.nativeGenerateDataMatrix(code, shapeIndex, prefixIndex, outputInfo);
        if (codeData == null) {
            TepraPrintLogger.d("makeCode: encode error");
            return null;
        }
        if (outputInfo[0] != 0L) {
            if (outputInfo[0] == 30L) {
                TepraPrintLogger.w("DataMatrix encode other error:" + outputInfo[3]);
            } else {
                TepraPrintLogger.w("DataMatrix encode parameter error:" + outputInfo[0]);
            }
            return null;
        }
        int bitmapWidth = (int)outputInfo[1];
        int bitmapHeight = (int)outputInfo[2];
        TepraPrintLogger.d("DataMatrix: nDestinationCol:" + bitmapWidth + " nDestinationRow:" + bitmapHeight);
        int imageSizeX = bitmapWidth + quietZoneCount * 2;
        int imageSizeY = bitmapHeight + quietZoneCount * 2;
        Bitmap bitmapDataMatrix = Bitmap.createBitmap((int)imageSizeX, (int)imageSizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmapDataMatrix);
        float offsetX = quietZoneCount;
        float offsetY = quietZoneCount;
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setDither(true);
        paint.setStyle(Paint.Style.FILL);
        int bytesPerRow = bitmapWidth;
        for (int rowIndex = 0; rowIndex < bitmapHeight; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < bitmapWidth; ++columnIndex) {
                int byteIndex = rowIndex * bytesPerRow + columnIndex;
                if ((codeData[byteIndex] & 0xFF) == 0) continue;
                float left = offsetX + (float)columnIndex;
                float top = offsetY + (float)rowIndex;
                canvas.drawRect(left, top, left + 1.0f, top + 1.0f, paint);
            }
        }
        return bitmapDataMatrix;
    }

    private static native byte[] nativeGenerateDataMatrix(byte[] var0, int var1, int var2, long[] var3);

    static {
        System.loadLibrary("TepraPrint");
    }

    public static enum ShapeType {
        Square,
        Rectangle;

    }

    public static enum PrefixType {
        None,
        FNC1,
        ReaderProgramming,
        Macro05,
        Macro06;

    }
}

