/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLookUpTable;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;

public class TepraPrintBitmapBinarizer {
    public static Boolean useDefaultTable = true;
    public static Boolean isLowSpeed = false;
    public static int tapeWidth = 5;
    public static int tapeKind = 0;
    private static int modelNumber = 5;
    private static byte[] lookUpTable = null;

    public static Bitmap convertByThreshold(Bitmap src, int width, int height, int color, int threshold) {
        Bitmap converted = TepraPrintBitmapBinarizer.convertBitmapSize(src, width, height);
        boolean result = TepraPrintBitmapBinarizer.nativeConvertByThreshold(converted, color, threshold);
        if (!result) {
            return null;
        }
        return converted;
    }

    public static Bitmap convertByDither(Bitmap src, int width, int height, int color) {
        TepraPrintBitmapBinarizer.setLut();
        Bitmap converted = TepraPrintBitmapBinarizer.convertBitmapSize(src, width, height);
        boolean result = TepraPrintBitmapBinarizer.nativeConvertByDither(converted, color, lookUpTable);
        if (!result) {
            return null;
        }
        return converted;
    }

    public static Bitmap convertByScreen(Bitmap src, int width, int height, int color) {
        TepraPrintBitmapBinarizer.setLut();
        Bitmap converted = TepraPrintBitmapBinarizer.convertBitmapSize(src, width, height);
        boolean result = TepraPrintBitmapBinarizer.nativeConvertByScreen(converted, color, lookUpTable);
        if (!result) {
            return null;
        }
        return converted;
    }

    private static Bitmap convertBitmapSize(Bitmap src, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        RectF srcRect = new RectF(0.0f, 0.0f, (float)src.getWidth(), (float)src.getHeight());
        RectF destRect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Matrix matrix = new Matrix();
        matrix.setRectToRect(srcRect, destRect, Matrix.ScaleToFit.FILL);
        Bitmap converted = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(converted);
        canvas.drawColor(-1);
        canvas.drawBitmap(src, matrix, new Paint());
        return converted;
    }

    public static void setLookupTable(byte[] newTable) {
        if (!useDefaultTable.booleanValue()) {
            lookUpTable = newTable;
        }
    }

    public static void setModelNumber(int newValue) {
        modelNumber = newValue;
    }

    public static void setModelNumberFromUsbmdl(String usbmdl) {
        String productModelNumber;
        Map<String, String> productInfo = new TepraPrintProductInformation().getInformation(usbmdl);
        if (productInfo != null && productInfo.size() != 0 && (productModelNumber = productInfo.get("Model Number")) != null) {
            try {
                modelNumber = Integer.parseInt(productModelNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void setLut() {
        lookUpTable = useDefaultTable == true || lookUpTable == null ? TepraPrintLookUpTable.getLut(modelNumber, isLowSpeed) : TepraPrintLookUpTable.getLutWithParameters(modelNumber, isLowSpeed, tapeKind, tapeWidth);
    }

    private static native boolean nativeConvertByThreshold(Bitmap var0, int var1, int var2);

    private static native boolean nativeConvertByDither(Bitmap var0, int var1, byte[] var2);

    private static native boolean nativeConvertByScreen(Bitmap var0, int var1, byte[] var2);

    static {
        System.loadLibrary("TepraPrint");
    }
}

