/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.graphics.Bitmap;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorCODE128;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorCODE39;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorITF;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorJAN;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorNW7;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorUPCA;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGeneratorUPCE;

public class TepraPrintBarcode {
    public static Bitmap makeCode(byte[] code, Type type, Width width, Ratio ratio, boolean showHRIText, boolean useCheckDigit, int height, int resolution) {
        BarcodeGenerator generator = null;
        switch (type) {
            case JAN13: {
                generator = new BarcodeGeneratorJAN(BarcodeGeneratorJAN.JANType.JAN13);
                break;
            }
            case JAN8: {
                generator = new BarcodeGeneratorJAN(BarcodeGeneratorJAN.JANType.JAN8);
                break;
            }
            case CODE39: {
                generator = new BarcodeGeneratorCODE39();
                break;
            }
            case ITF: {
                generator = new BarcodeGeneratorITF();
                break;
            }
            case NW7: {
                generator = new BarcodeGeneratorNW7();
                break;
            }
            case UPCA: {
                generator = new BarcodeGeneratorUPCA();
                break;
            }
            case UPCE: {
                generator = new BarcodeGeneratorUPCE();
                break;
            }
            case CODE128: {
                generator = new BarcodeGeneratorCODE128();
                break;
            }
            default: {
                return null;
            }
        }
        boolean isValidParameters = generator.setParameters(code, width, ratio, showHRIText, useCheckDigit, height, resolution);
        if (!isValidParameters) {
            return null;
        }
        return generator.makeImage();
    }

    public static enum Type {
        JAN13,
        JAN8,
        NW7,
        UPCA,
        ITF,
        UPCE,
        CODE39,
        CODE128;

    }

    public static enum Width {
        Small,
        Standard,
        Large;

    }

    public static enum Ratio {
        Small,
        Medium,
        Large;

    }
}

