/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.kingjim.tepraprint.sdk.TepraPrintCallback;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDotbydotDraw;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDotbydotDrawFromByteArray;
import jp.co.kingjim.tepraprint.sdk.TepraPrintFormDraw;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.TepraPrintObjectType;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.android.androidcore.PrintController;

public class TepraPrint {
    private final String TAG = this.getClass().getSimpleName();
    TepraPrintCallback listener = null;
    private TepraPrintDataProvider provider = null;
    Map<String, Integer> mapPrinterStatus = null;
    private boolean _cancelRequest = false;
    PrintController _printController = new PrintController();
    Map<String, String> _printerInfo;
    Context context;
    private static final Map<Integer, Integer> TAPE_KIND_STATUS_TO_BIGROLL;

    private TepraPrint() {
        this._printController.setCaller(this);
        Log.i((String)("TEPRA-Print SDK Ver." + TepraPrintProductInformation.getVersion()), (String)"Copyright 2016-2025 KING JIM CO.,LTD.");
    }

    public TepraPrint(Context context) {
        this();
        this.context = context;
    }

    public static final String getVersion() {
        return TepraPrintProductInformation.getVersion();
    }

    public Context getContext() {
        return this.context;
    }

    public TepraPrintCallback getCallback() {
        return this.listener;
    }

    public void setCallback(TepraPrintCallback callback) {
        this.listener = callback;
    }

    public float getProgressOfPrint() {
        return this._printController.getProgressOfPrint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageNumberOfPrinting() {
        TepraPrint tepraPrint = this;
        synchronized (tepraPrint) {
            return this._printController.getPageNumberOfPrinting();
        }
    }

    public Map<String, String> getPrinterInformation() {
        return this._printerInfo;
    }

    public void setPrinterInformation(Map<String, String> printerInfo) {
        this._printController.setPrinterInformation(printerInfo);
        this._printerInfo = this._printController.getPrinterInformation();
        if (this._printerInfo != null) {
            TepraPrintLogger.d(this.TAG, "setPrinterInformation: " + this._printerInfo.toString());
        }
    }

    public void doPrint(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter) {
        if (printParameter == null || this._printController.isPrinting()) {
            return;
        }
        this.provider = dataProvider;
        TepraPrintFormDraw draw = new TepraPrintFormDraw(dataProvider);
        Object obj = null;
        int tapeWidth = 0;
        if (printParameter.containsKey("ParameterKeyTapeWidth") && (obj = printParameter.get("ParameterKeyTapeWidth")) instanceof Integer) {
            tapeWidth = (Integer)obj;
        }
        draw.setTapeWidth(tapeWidth);
        if (draw.getTapeWidth() < 1 || draw.getTapeWidth() > 12) {
            draw.setTapeWidth(5);
        }
        draw.setResolution(this.getResolution());
        draw.setModelNumber(this.getModelNumber());
        this._printController.setDrawCallback(draw);
        this._printController.setDelegate(this.listener);
        this._printController.doPrint(printParameter);
    }

    public void doPrint(Bitmap bitmap, Map<String, Object> printParameter) {
        ArrayList<Bitmap> bitmapArray = new ArrayList<Bitmap>();
        bitmapArray.add(bitmap);
        this.doPrint(null, printParameter, bitmapArray, 1);
    }

    public void doPrint(Bitmap bitmap, Map<String, Object> printParameter, int margin) {
        ArrayList<Bitmap> bitmapArray = new ArrayList<Bitmap>();
        bitmapArray.add(bitmap);
        this.doPrint(null, printParameter, bitmapArray, margin);
    }

    public void doPrint(ArrayList<Bitmap> bitmapArray, Map<String, Object> printParameter) {
        this.doPrint(null, printParameter, bitmapArray, 1);
    }

    public void doPrint(ArrayList<Bitmap> bitmapArray, Map<String, Object> printParameter, int margin) {
        this.doPrint(null, printParameter, bitmapArray, margin);
    }

    public void doPrint(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter, Bitmap bitmap) {
        ArrayList<Bitmap> bitmapArray = new ArrayList<Bitmap>();
        bitmapArray.add(bitmap);
        this.doPrint(dataProvider, printParameter, bitmapArray, 1);
    }

    public void doPrint(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter, ArrayList<Bitmap> bitmapArray, int margin) {
        if (printParameter == null || this._printController.isPrinting()) {
            return;
        }
        this.provider = dataProvider;
        TepraPrintDotbydotDraw draw = new TepraPrintDotbydotDraw(dataProvider, bitmapArray, margin);
        Object obj = null;
        int tapeWidth = 0;
        if (printParameter.containsKey("ParameterKeyTapeWidth") && (obj = printParameter.get("ParameterKeyTapeWidth")) instanceof Integer) {
            tapeWidth = (Integer)obj;
        }
        draw.setTapeWidth(tapeWidth);
        if (draw.getTapeWidth() < 1 || draw.getTapeWidth() > 12) {
            draw.setTapeWidth(5);
        }
        draw.setResolution(this.getResolution());
        draw.setModelNumber(this.getModelNumber());
        this._printController.setDrawCallback(draw);
        this._printController.setDelegate(this.listener);
        this._printController.doPrint(printParameter);
    }

    public void doPrintLabelImage(byte[] byteArray, Map<String, Object> printParameter, int margin) {
        ArrayList<byte[]> byteArrayList = new ArrayList<byte[]>();
        byteArrayList.add(byteArray);
        this.doPrintLabelImage(null, printParameter, byteArrayList, margin);
    }

    public void doPrintLabelImage(byte[] byteArray, Map<String, Object> printParameter) {
        ArrayList<byte[]> byteArrayList = new ArrayList<byte[]>();
        byteArrayList.add(byteArray);
        this.doPrintLabelImage(null, printParameter, byteArrayList, 1);
    }

    public void doPrintLabelImage(ArrayList<byte[]> byteArrayList, Map<String, Object> printParameter, int margin) {
        this.doPrintLabelImage(null, printParameter, byteArrayList, margin);
    }

    public void doPrintLabelImage(ArrayList<byte[]> byteArrayList, Map<String, Object> printParameter) {
        this.doPrintLabelImage(null, printParameter, byteArrayList, 1);
    }

    public void doPrintLabelImage(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter, ArrayList<byte[]> byteArrayList, int margin) {
        if (printParameter == null || this._printController.isPrinting()) {
            return;
        }
        this.provider = dataProvider;
        TepraPrintDotbydotDrawFromByteArray draw = new TepraPrintDotbydotDrawFromByteArray(dataProvider, byteArrayList, margin);
        Object obj = null;
        int tapeWidth = 0;
        if (printParameter.containsKey("ParameterKeyTapeWidth") && (obj = printParameter.get("ParameterKeyTapeWidth")) instanceof Integer) {
            tapeWidth = (Integer)obj;
        }
        draw.setTapeWidth(tapeWidth);
        if (draw.getTapeWidth() < 1 || draw.getTapeWidth() > 12) {
            draw.setTapeWidth(5);
        }
        draw.setResolution(this.getResolution());
        draw.setModelNumber(this.getModelNumber());
        this._printController.setDrawCallback(draw);
        this._printController.setDelegate(this.listener);
        this._printController.doPrint(printParameter);
    }

    public Bitmap getLabelImage(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter) {
        return this.getLabelImage(dataProvider, printParameter, -1);
    }

    public Bitmap getLabelImage(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter, int page) {
        if (printParameter == null) {
            return null;
        }
        this.provider = dataProvider;
        TepraPrintFormDraw draw = new TepraPrintFormDraw(dataProvider);
        Object obj = null;
        int tapeWidth = 0;
        if (printParameter.containsKey("ParameterKeyTapeWidth") && (obj = printParameter.get("ParameterKeyTapeWidth")) instanceof Integer) {
            tapeWidth = (Integer)obj;
        }
        draw.setTapeWidth(tapeWidth);
        if (draw.getTapeWidth() < 1 || draw.getTapeWidth() > 12) {
            draw.setTapeWidth(5);
        }
        draw.setResolution(this.getResolution());
        draw.setModelNumber(this.getModelNumber());
        this._printController.setDrawCallback(draw);
        this._printController.setDelegate(this.listener);
        return this._printController.getPreviewImage(page);
    }

    public List<Bitmap> getLabelImages(TepraPrintDataProvider dataProvider, Map<String, Object> printParameter) {
        if (printParameter == null) {
            return null;
        }
        this.provider = dataProvider;
        TepraPrintFormDraw draw = new TepraPrintFormDraw(dataProvider);
        Object obj = null;
        int tapeWidth = 0;
        if (printParameter.containsKey("ParameterKeyTapeWidth") && (obj = printParameter.get("ParameterKeyTapeWidth")) instanceof Integer) {
            tapeWidth = (Integer)obj;
        }
        draw.setTapeWidth(tapeWidth);
        if (draw.getTapeWidth() < 1 || draw.getTapeWidth() > 12) {
            draw.setTapeWidth(5);
        }
        draw.setResolution(this.getResolution());
        draw.setModelNumber(this.getModelNumber());
        this._printController.setDrawCallback(draw);
        this._printController.setDelegate(this.listener);
        return this._printController.getPreviewImages();
    }

    public void doTapeFeed(int mode) {
        this._printController.setDelegate(this.listener);
        this._printController.doTapeFeed(mode);
    }

    public void resumeOfPrint() {
        this._printController.setDelegate(this.listener);
        this._printController.resumeOfPrint();
    }

    public void cancelPrint() {
        this._printController.setDelegate(this.listener);
        this._printController.cancelPrint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> fetchPrinterStatus() {
        TepraPrint tepraPrint = this;
        synchronized (tepraPrint) {
            return this._printController.fetchPrinterStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDeviceInformation() {
        TepraPrint tepraPrint = this;
        synchronized (tepraPrint) {
            return this._printController.getDeviceInformation();
        }
    }

    public int getTapeWidthFromStatus(Map<String, Integer> status) {
        int tapeWidth = -2;
        if (status != null && status.containsKey("StatusKeyTapeWidth") && status.get("StatusKeyTapeWidth") != null) {
            tapeWidth = status.get("StatusKeyTapeWidth");
        }
        if (tapeWidth < -1 || tapeWidth > 12) {
            tapeWidth = 0;
        }
        TepraPrintLogger.d(this.TAG, "getTapeWidthFromStatus(): " + tapeWidth);
        return tapeWidth;
    }

    public int getTapeKindFromStatus(Map<String, Integer> status) {
        int tapeKind = 0;
        if (this.isBigroll(status)) {
            if (status != null && status.containsKey("BTK") && status.get("BTK") != null) {
                tapeKind = TAPE_KIND_STATUS_TO_BIGROLL.get(status.get("BTK"));
            }
        } else if (status != null && status.containsKey("TR") && status.get("TR") != null && (tapeKind = status.get("TR").intValue()) == 255) {
            tapeKind = -1;
        }
        TepraPrintLogger.d(this.TAG, "getTapeKindFromStatus(): " + tapeKind);
        return tapeKind;
    }

    public int getDeviceErrorFromStatus(Map<String, Integer> status) {
        TepraPrintLogger.d(this.TAG, "getDeviceErrorFromStatus(): " + this._printController.getDeviceErrorFromStatus(status));
        return this._printController.getDeviceErrorFromStatus(status);
    }

    public List<Integer> getKindOfTape() {
        String mdl = "";
        if (this._printerInfo != null && this._printerInfo.containsKey("usbmdl") && this._printerInfo.get("usbmdl") != null) {
            mdl = this._printerInfo.get("usbmdl");
        }
        String tape = null;
        Map<String, String> productInfo = new TepraPrintProductInformation().getInformation(mdl);
        if (productInfo != null) {
            tape = productInfo.get("Kind of Tape");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (tape != null) {
            String[] array = tape.split(",");
            for (int i = 0; i < array.length; ++i) {
                try {
                    list.add(Integer.valueOf(array[i]));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public String getModelName() {
        String modelName = null;
        if (this._printerInfo != null) {
            modelName = this._printerInfo.get("usbmdl");
        }
        return modelName;
    }

    public int getResolution() {
        String resoluton;
        Map<String, String> productInfo;
        int result = 360;
        String mdl = "";
        if (this._printerInfo != null && this._printerInfo.containsKey("usbmdl") && this._printerInfo.get("usbmdl") != null) {
            mdl = this._printerInfo.get("usbmdl");
        }
        if ((productInfo = new TepraPrintProductInformation().getInformation(mdl)) != null && (resoluton = productInfo.get("Resolution")) != null) {
            try {
                result = Integer.parseInt(resoluton);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TepraPrintLogger.d(this.TAG, "getResolution(): " + result);
        return result;
    }

    public boolean isSupportHalfCut() {
        String halfCut;
        Map<String, String> productInfo;
        boolean type = false;
        String mdl = "";
        if (this._printerInfo != null && this._printerInfo.containsKey("usbmdl") && this._printerInfo.get("usbmdl") != null) {
            mdl = this._printerInfo.get("usbmdl");
        }
        if ((productInfo = new TepraPrintProductInformation().getInformation(mdl)) != null && (halfCut = productInfo.get("Halfcut")) != null && "YES".equalsIgnoreCase(halfCut)) {
            type = true;
        }
        TepraPrintLogger.d(this.TAG, "isSupportHalfCut(): " + type);
        return type;
    }

    public boolean isPrintSpeedSupport() {
        String speedSupport;
        Map<String, String> productInfo;
        boolean speed = false;
        String mdl = "";
        if (this._printerInfo != null && this._printerInfo.containsKey("usbmdl") && this._printerInfo.get("usbmdl") != null) {
            mdl = this._printerInfo.get("usbmdl");
        }
        if ((productInfo = new TepraPrintProductInformation().getInformation(mdl)) != null && (speedSupport = productInfo.get("LowSpeed")) != null && "YES".equalsIgnoreCase(speedSupport)) {
            speed = true;
        }
        TepraPrintLogger.d(this.TAG, "isPrintSpeedSupport(): " + speed);
        return speed;
    }

    public int getModelNumber() {
        String modelNumber;
        Map<String, String> productInfo;
        int number = 4;
        String mdl = "";
        if (this._printerInfo != null && this._printerInfo.containsKey("usbmdl") && this._printerInfo.get("usbmdl") != null) {
            mdl = this._printerInfo.get("usbmdl");
        }
        if ((productInfo = new TepraPrintProductInformation().getInformation(mdl)) != null && (modelNumber = productInfo.get("Model Number")) != null) {
            try {
                number = Integer.parseInt(modelNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TepraPrintLogger.d(this.TAG, "getModelNumber(): " + number);
        return number;
    }

    public Map<String, Integer> getTapeSwitchFromStatus(Map<String, Integer> status) {
        HashMap<String, Integer> switchInfo = null;
        if (status.containsKey("TS")) {
            Integer t8sw = status.get("TS");
            switchInfo = new HashMap<String, Integer>();
            switchInfo.put("TapeSwitchKeyMagnet", (t8sw & 0x20) == 0 ? 0 : 1);
            switchInfo.put("TapeSwitchKeyBigroll", (t8sw & 0x10) == 0 ? 0 : 1);
        }
        return switchInfo;
    }

    public Map<String, Integer> getTapeOptionFromStatus(Map<String, Integer> status) {
        HashMap<String, Integer> optionInfo = null;
        Boolean isBig = this.isBigroll(status);
        if (isBig.booleanValue()) {
            if (status.containsKey("BO") && status.containsKey("BPD") && status.containsKey("BPS")) {
                optionInfo = new HashMap();
                Integer option = status.get("BO");
                Integer density = status.get("BPD");
                Integer speed = status.get("BPS");
                optionInfo.put("TapeOptionKeyFullCut", (option & 4) == 0 ? 0 : 1);
                optionInfo.put("TapeOptionKeyHalfCut", (option & 2) == 0 ? 0 : 1);
                optionInfo.put("TapeOptionKeyDensity", density);
                Integer speedValue = speed == 0 ? Integer.valueOf(1) : (speed == 1 ? Integer.valueOf(2) : Integer.valueOf(0));
                optionInfo.put("TapeOptionKeyPrintSpeed", speedValue);
                optionInfo.put("TapeOptionKeyMirror", (option & 8) == 0 ? 0 : 1);
                optionInfo.put("TapeOptionKeyWinder", (option & 1) == 0 ? 0 : 1);
            }
        } else if (status.containsKey("T8O")) {
            optionInfo = new HashMap<String, Integer>();
            Integer t8 = status.get("T8O");
            optionInfo.put("TapeOptionKeyFullCut", (t8 & 0x20) == 0 ? 0 : 1);
            optionInfo.put("TapeOptionKeyHalfCut", (t8 & 0x10) == 0 ? 0 : 1);
            optionInfo.put("TapeOptionKeyDensity", (t8 & 8) == 0 ? 0 : 3);
            optionInfo.put("TapeOptionKeyMirror", (t8 & 2) == 0 ? 0 : 1);
            optionInfo.put("TapeOptionKeyWinder", (t8 & 1) == 0 ? 0 : 1);
            int tapeOptionPrintSpeed = t8 >> 2 & 1;
            if (tapeOptionPrintSpeed == 0 && (t8 >> 6 & 1) == 1) {
                tapeOptionPrintSpeed = 2;
            }
            optionInfo.put("TapeOptionKeyPrintSpeed", tapeOptionPrintSpeed);
        }
        return optionInfo;
    }

    public int getBatteryLevelFromStatus(Map<String, Integer> status) {
        if (status.containsKey("ER") && status.get("ER") == 34) {
            return 2;
        }
        if (status.containsKey("WA")) {
            return status.get("WA");
        }
        return 0;
    }

    public void setBatteryType(int batteryType) {
        int type = batteryType;
        this._printController.setBatteryType(type);
    }

    public int getBatteryType() {
        return this._printController.getBatteryType();
    }

    public boolean isBigroll(Map<String, Integer> status) {
        return status.containsKey("BR") && status.get("BR") == 1;
    }

    public boolean isTapeWinder(Map<String, Integer> status) {
        return status.containsKey("TWS") && status.get("TWS") == 1;
    }

    public int getBigrollTapeLengthFromStatus(Map<String, Integer> status) {
        if (status.containsKey("BTLM")) {
            return status.get("BTLM");
        }
        return 0;
    }

    public int getBigrollTapeUsageLengthFromStatus(Map<String, Integer> status) {
        if (status.containsKey("BTUL")) {
            return status.get("BTUL");
        }
        return 0;
    }

    public void setObjectType(Set<TepraPrintObjectType> type) {
        this._printController.setObjectType(type);
    }

    public int getPrintableSizeFromTape(int width) {
        return (int)TepraPrintProductInformation.getPrintableSize(width, this.getResolution(), this.getModelNumber());
    }

    static {
        System.loadLibrary("TepraPrint");
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 201);
        map.put(2, 202);
        map.put(3, 203);
        map.put(4, 204);
        map.put(100, 210);
        map.put(101, 211);
        map.put(102, 212);
        map.put(103, 213);
        TAPE_KIND_STATUS_TO_BIGROLL = Collections.unmodifiableMap(map);
    }
}

