//
//  ViewController.m
//  RoltoPrintSample
//
//  Copyright: (C) 2014 KING JIM CO.,LTD.
//

#import "ViewController.h"
#import "SelectPrinterTableViewController.h"

#import "RoltoPrint.h"

NSString * const RoltoLaunchURL = @"rolto:";
NSString * const RoltoClipboardPrintURL = @"rolto://clipboard";

@interface ViewController ()
{
    RoltoPrint *_roltoPrint;
    NSMutableArray *_printers;
    UIAlertView *_alert;
}
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    _roltoPrint = nil;
    self.printLabel.enabled = NO;
    self.requestStatusLabel.enabled = NO;
    self.launchRoltoLabel.enabled = NO;
    self.printing = NO;
  
    [self pushSelectPrinter];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}


#pragma mark - UITableView 

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(indexPath.section == 0)
    {
        [self pushSelectImage];
    }
    else if(indexPath.section == 1)
    {
        if(indexPath.row == 0)
        {
            [self pushSelectPrinter];
        }
        else if(indexPath.row == 1)
        {
            [self pushRequestStatus];
        }
        else
        {
            if(!self.printing) {
                [self pushPrint];
            } else {
                [self pushCancel];
            }
        }
    }
    else if(indexPath.section == 2)
    {
        [self launchRolto];
    }
    [self.tableView deselectRowAtIndexPath:indexPath animated:YES];

}

- (BOOL)tableView:(UITableView *)tableView shouldHighlightRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [self isEnableCell:indexPath];
}

- (NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self isEnableCell:indexPath])
    {
        return indexPath;
    }
    else
    {
        return nil;
    }
}



- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if([segue.identifier isEqualToString:@"SelectPrinter"])
    {
        SelectPrinterTableViewController *controller = segue.destinationViewController;
        controller.printers = _printers;
    }
}

- (IBAction)returnSelectPrinterForSegue:(UIStoryboardSegue *)segue
{
    _roltoPrint = _printers[self.selectedIndex];
    self.selectPrinterLabel.text = _roltoPrint.printerName;
    self.printLabel.enabled = YES;
    self.requestStatusLabel.enabled = YES;
}

#pragma mark - UIImagePicker delegate
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    self.imageView.image = info[UIImagePickerControllerOriginalImage];
    [picker dismissViewControllerAnimated:YES completion:nil];
    self.launchRoltoLabel.enabled = YES;
}

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker
{
    [picker dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - private
- (void)pushSelectPrinter
{
    if([self.selectPrinterLabel.text isEqualToString:@"Searching..."]) {
        return;
    }
    
    self.selectPrinterLabel.text = @"Searching...";
    self.printLabel.enabled = YES;
    [self.indicatorView startAnimating];
    
    _printers = [NSMutableArray array];
    
    RoltoPrintDiscover *dicover = [[RoltoPrintDiscover alloc] init];
    _roltoPrint = nil;
    self.printLabel.enabled = NO;
    self.requestStatusLabel.enabled = NO;
    [dicover searchPrintersWithCallback:^(RoltoPrint *print)
     {
         [_printers addObject:print];
     } comletion:^ {
         [self.indicatorView stopAnimating];
         if(_printers.count != 0)
         {
             if(_printers.count == 1)
             {
                 _roltoPrint = _printers[0];
                 self.selectPrinterLabel.text = _roltoPrint.printerName;
                 self.printLabel.enabled = YES;
                 self.requestStatusLabel.enabled = YES;
             }
             else
             {
                 [self performSegueWithIdentifier:@"SelectPrinter" sender:nil];
                 self.selectPrinterLabel.text = @"Search Printer";
             }
         }
         else
         {
             _alert = [[UIAlertView alloc] initWithTitle:@"Printer Not Found!"
                                                             message:nil
                                                            delegate:nil
                                                   cancelButtonTitle:nil
                                                   otherButtonTitles:@"OK", nil];
             [_alert show];
             self.selectPrinterLabel.text = @"Search Printer";
             
         }
     } duration:3.];
    
}

- (void)pushSelectImage
{
    UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    picker.delegate = self;
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    [self.navigationController presentViewController:picker animated:YES completion:nil];
}

- (void)pushRequestStatus
{
    if(_roltoPrint == nil) return;
    
    if(self.printing) {
        return;
    }
    
    [_roltoPrint requestPrinterStatus:^(BOOL result, RoltoPrinterStatus status) {
        if(result)
        {
            self.requestStatusLabel.text = [NSString stringWithFormat:@"Status = [%zi]", status];
        }
        else
        {
            _alert = [[UIAlertView alloc] initWithTitle:@"Request Printer Status Error!"
                                                            message:nil
                                                           delegate:nil
                                                  cancelButtonTitle:nil
                                                  otherButtonTitles:@"OK", nil];
            [_alert show];
        }
    }];
}

- (void)pushPrint
{
    if(_roltoPrint == nil) return;
    
    self.printLabel.text = @"Print Cancel";
    self.requestStatusLabel.enabled = NO;
    
    if(self.multipleImagesSwitch.on)
    {
        [self printImagePaths];
    }
    else
    {
        [self printImage];
    }
}

- (void)pushCancel
{
    [_roltoPrint cancelPrint];
}


- (void)printImage
{
    self.printing = YES;
    NSDictionary *params = @{RoltoPrintParameterBlockSize : @(0),
                             RoltoPrintParameterBinarizationOffset : @(0),
                             RoltoPrintParameterErrorDiffusion : @(YES)};
    [_roltoPrint performPrintImage:self.imageView.image params:params completion:^(RoltoPrintResult result) {
        self.printing = NO;
        self.printLabel.text = @"Print";
        self.requestStatusLabel.enabled = YES;
        [self showAlert:result];
    }];

}

- (void)printImagePaths
{
    self.printing = YES;
    NSDictionary *params = @{RoltoPrintParameterBlockSize : @(0.79),
                             RoltoPrintParameterBinarizationOffset : @(0.05),
                             RoltoPrintParameterErrorDiffusion : @(NO)};

    // make files
    NSMutableArray *images = [NSMutableArray array];
    NSString *tmpDirPath = NSTemporaryDirectory();
    NSString *fileNameBase = [tmpDirPath stringByAppendingPathComponent:@"TmpImage"];
    
    // title
    UIImage *titleImage = [self createImage];
    NSString *titlePath = [NSString stringWithFormat:@"%@-1.jpg", fileNameBase];
    NSData *titleImageData = UIImageJPEGRepresentation(titleImage, 1.);
    [titleImageData writeToFile:titlePath atomically:NO];
    [images addObject:titlePath];

    // Rolto
    NSString *roltoPath = [NSString stringWithFormat:@"%@-2.jpg", fileNameBase];
    NSData *roltoData = UIImageJPEGRepresentation([UIImage imageNamed:@"Image"], 1.);
    [roltoData writeToFile:roltoPath atomically:NO];
    [images addObject:roltoPath];

    // select image
    NSString *filePath = [NSString stringWithFormat:@"%@-3.jpg", fileNameBase];
    NSData *imageData = UIImageJPEGRepresentation(_imageView.image, 1.);
    [imageData writeToFile:filePath atomically:NO];
    [images addObject:filePath];
    
    [_roltoPrint performPrintImagePaths:images params:params completion:^(RoltoPrintResult result) {
        self.printing = NO;
        self.printLabel.text = @"Print";
        self.requestStatusLabel.enabled = YES;
        [self showAlert:result];

        // delete files
        NSFileManager *fileManager = [NSFileManager defaultManager];
        for(NSString *path in images)
        {
            [fileManager removeItemAtPath:path error:NULL];
        }
    }];

}

- (void)showAlert:(RoltoPrintResult)result
{
    NSString *title;
    NSString *message = nil;;
    if(result == RoltoPrintResultSuccess)
    {
        title = @"Print Complete!";
        
    }
    else
    {
        title = @"Print Error!";
        message = [NSString stringWithFormat:@"Result code = %zi", result];
    }

    _alert = [[UIAlertView alloc] initWithTitle:title
                                                    message:message
                                                   delegate:nil
                                          cancelButtonTitle:nil
                                          otherButtonTitles:@"OK", nil];
    [_alert show];

}

- (BOOL)isEnableCell:(NSIndexPath *)indexPath
{
    if(indexPath.section == 1)
    {
        if(indexPath.row == 1)
        {
            if(self.printing)
            {
                return NO;
            }
        }
        else if(indexPath.row == 3)
        {
            return NO;
        }
    }
    else if(indexPath.section == 2)
    {
        NSURL *url = [NSURL URLWithString:RoltoLaunchURL];
        return [[UIApplication sharedApplication] canOpenURL:url] & (_imageView.image != nil ? YES : NO);
    }
    return YES;
}

- (void)launchRolto
{
    
    CGFloat scale = _imageView.image.size.width / 384.;
    UIImage *image = [UIImage imageWithCGImage:_imageView.image.CGImage scale:scale orientation:_imageView.image.imageOrientation];
    
    UIPasteboard *gpBoard = [UIPasteboard generalPasteboard];
    gpBoard.image = image;
    
    NSURL *url = [NSURL URLWithString:RoltoClipboardPrintURL];
    [[UIApplication sharedApplication] openURL:url];
}

- (UIImage *)createImage
{
    NSInteger contextWidth = 384;
    NSInteger contextHeight = 80;
    
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceGray();
    CGContextRef context = CGBitmapContextCreate(NULL, contextWidth, contextHeight, 8, contextWidth, colorSpace, 0);    
    CGColorSpaceRelease(colorSpace);
    CGContextScaleCTM(context, 1, -1);
    CGContextTranslateCTM(context, 0, -contextHeight);
    
    CGContextSetRGBFillColor(context, 1.,1.,1.,1.);
    CGContextFillRect(context, CGRectMake(0., 0., contextWidth, contextHeight));
    
    UIGraphicsPushContext(context);
    
    CGContextSetAllowsAntialiasing(context, FALSE);
    CGContextSetShouldAntialias(context, FALSE);

    // frame
    CGRect rect = CGRectMake(0, 0, contextWidth, 60.);
    rect = CGRectInset(rect, 2., 2.);
    UIBezierPath *framePath = [UIBezierPath bezierPathWithRoundedRect:rect cornerRadius:10.];
    [[UIColor colorWithWhite:0 alpha:1.] setStroke];
    framePath.lineWidth = 1.;
    [framePath stroke];
    
    // title
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle.alignment = NSTextAlignmentCenter;
    
    NSString *str = [NSString stringWithFormat:@"Rolto Print Sample"];
    NSDictionary *attributeDict = @{NSFontAttributeName: [UIFont boldSystemFontOfSize:42.],
                                    NSParagraphStyleAttributeName: paragraphStyle};
    NSAttributedString *title = [[NSAttributedString alloc] initWithString:str attributes:attributeDict];
    [title drawInRect:rect];
    
    UIGraphicsPopContext();
    
    CGImageRef cgimage = CGBitmapContextCreateImage(context);
    CGContextRelease(context);
    UIImage *image = [UIImage imageWithCGImage:cgimage];
    CGImageRelease(cgimage);
    
    return image;
}
@end
