//
//  SelectPrinterTableViewController.m
//  RoltoPrintSample
//
//  Copyright: (C) 2014 KING JIM CO.,LTD.
//

#import "SelectPrinterTableViewController.h"
#import "ViewController.h"

#import "RoltoPrint.h"

@interface SelectPrinterTableViewController ()

@end

@implementation SelectPrinterTableViewController

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.printers.count;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"PrinterCell" forIndexPath:indexPath];
    
    RoltoPrint *print = self.printers[indexPath.row];
    
    cell.textLabel.text = print.printerName;
    cell.tag = indexPath.row;
    return cell;
}


#pragma mark - Navigation

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    if([segue.identifier isEqualToString:@"SelectPrinter"])
    {
        UITableViewCell *cell = sender;
        
        ViewController *controller = segue.destinationViewController;
        controller.selectedIndex = cell.tag;
    }
}

@end
