//
//  AppDelegate.m
//  RoltoPrintSample
//
//  Copyright: (C) 2014 KING JIM CO.,LTD.
//

#import "AppDelegate.h"
#import "ViewController.h"

@implementation AppDelegate
{
    UIBackgroundTaskIdentifier _bgTask;
    ViewController *_viewController;
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    UINavigationController *navigation = (UINavigationController *)self.window.rootViewController;
    _viewController = (ViewController *)navigation.topViewController;
    return YES;
}
							
- (void)applicationWillResignActive:(UIApplication *)application
{
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    if(!_viewController.printing)
    {
        return;
    }
    
    UIApplication*	app = [UIApplication sharedApplication];
	NSAssert(_bgTask == UIBackgroundTaskInvalid, nil);
	
	_bgTask = [app beginBackgroundTaskWithExpirationHandler:^{
		dispatch_async(dispatch_get_main_queue(), ^{
			if (_bgTask != UIBackgroundTaskInvalid)
            {
				[app endBackgroundTask:_bgTask];
				_bgTask = UIBackgroundTaskInvalid;
			}
		});
	}];
	
	dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
		
		while(_viewController.printing && _bgTask != UIBackgroundTaskInvalid) {
			[NSThread sleepForTimeInterval:2.];
		}
        
		dispatch_async(dispatch_get_main_queue(), ^{
			if (_bgTask != UIBackgroundTaskInvalid)
            {
				[app endBackgroundTask:_bgTask];
				_bgTask = UIBackgroundTaskInvalid;
				
			}
		});
	});
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    UIApplication*	app = [UIApplication sharedApplication];
	if (_bgTask != UIBackgroundTaskInvalid)
    {
		[app endBackgroundTask:_bgTask];
		_bgTask = UIBackgroundTaskInvalid;
	}
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
}

- (void)applicationWillTerminate:(UIApplication *)application
{
}

@end
