package jp.co.kingjim.rolto.printsdk.sample;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.kingjim.rolto.print.RoltoPrint;
import jp.co.kingjim.rolto.print.RoltoPrint.PrintParamKey;
import jp.co.kingjim.rolto.print.RoltoPrint.PrintResult;
import jp.co.kingjim.rolto.print.RoltoPrint.PrinterStatus;
import jp.co.kingjim.rolto.print.RoltoPrint.PrinterStatusCallback;
import jp.co.kingjim.rolto.printsdk.sample.PrinterSelectFragment.PrinterSelectedListener;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.Toast;

public class SampleMainFragment extends Fragment implements PrinterSelectedListener {
	private static int Request_GetImage = 100;

	private RoltoPrint mRoltoPrint;
	private ImageView mSelectedImageView;
	private Uri mSelectedImageUri;
	private Button mSearchButton;
	private Button mRequestStatusButton;
	private Button mPrintButton;
	private Switch mMultiImageSwitch;
	private View mProgressView;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View rootView = inflater.inflate(R.layout.fragment_sample_main, container, false);
		mSelectedImageView = (ImageView) rootView.findViewById(R.id.image_selected);
		mSearchButton = (Button) rootView.findViewById(R.id.button_search_printers);
		mRequestStatusButton = (Button) rootView.findViewById(R.id.button_request_status);
		mPrintButton = (Button) rootView.findViewById(R.id.button_print);
		mMultiImageSwitch = (Switch) rootView.findViewById(R.id.switch_multi_image);
		mProgressView = rootView.findViewById(R.id.layout_progress);
		
		mSelectedImageView.setOnClickListener(mOnImageViewClick);
		mSearchButton.setOnClickListener(mOnSearchClick);
		mRequestStatusButton.setOnClickListener(mOnRequestStatusClick);
		mPrintButton.setOnClickListener(mOnPrintClickListener);
		
		if ( mRoltoPrint != null )
		{
			mSearchButton.setText(mRoltoPrint.getPrinterName());
		}
		
		mSelectedImageView.setImageURI(mSelectedImageUri);
		
		return rootView;
	}
	
	@Override
	public void onDestroyView() {
		mSelectedImageView = null;
		mSearchButton = null;
		mRequestStatusButton = null;
		mPrintButton = null;
		
		super.onDestroyView();
	}

	private OnClickListener mOnImageViewClick = new OnClickListener() {		
		@Override
		public void onClick(View v) {
			Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
			intent.setType("image/*");
			startActivityForResult(intent, Request_GetImage);
		}
	};
	
	private OnClickListener mOnSearchClick = new OnClickListener() {
		@Override
		public void onClick(View v) {
			PrinterSelectFragment fragment = new PrinterSelectFragment();
			fragment.setPrinterSelectedListenerTag(SampleMainFragment.class.getName());
			String tag = fragment.getClass().getName();
			FragmentTransaction transaction = getFragmentManager().beginTransaction();
			transaction.replace(R.id.fragment_container, fragment, tag);
			transaction.addToBackStack(null);
			transaction.commit();
		}
	};
	
	private OnClickListener mOnRequestStatusClick = new OnClickListener() {	
		@Override
		public void onClick(View v) {
			if ( mRoltoPrint == null )
			{
				return;
			}
			
			mProgressView.setVisibility(View.VISIBLE);
			
			/* ステータスを取得 */
			mRoltoPrint.requestPrinterStatus(new PrinterStatusCallback() {				
				@Override
				public void onReceivePrinterStatus(PrinterStatus status, boolean isDirectMode) {
					String statusStr = "Printer status : " + status.toString();
					if ( isDirectMode )
					{
						statusStr += " (Direct)";
					}
					
					if ( mRequestStatusButton != null )
					{
						mRequestStatusButton.setText(statusStr);
					}
					mProgressView.setVisibility(View.GONE);
				}
			});
		}
	};
	
	private OnClickListener mOnPrintClickListener = new OnClickListener() {	
		@Override
		public void onClick(View v) {
			if ( mRoltoPrint == null || mSelectedImageUri == null )
			{
				return;
			}
			
			mProgressView.setVisibility(View.VISIBLE);
			
			/* コールバック用オブジェクトを作成 */
			RoltoPrint.PrintResultCallback callback = new RoltoPrint.PrintResultCallback() {				
				@Override
				public void onPrintComplete(PrintResult result) {
					Toast.makeText(getActivity(), result.toString(), Toast.LENGTH_SHORT).show();
					mProgressView.setVisibility(View.GONE);
				}
			};
			
			/* 一枚のみ印刷 */
			if ( !mMultiImageSwitch.isChecked() )
			{
				InputStream in = null;
				try {
					in = getActivity().getContentResolver().openInputStream(mSelectedImageUri);
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				}
				if ( in != null )
				{
					Bitmap bitmap = BitmapFactory.decodeStream(in);
					try {
						in.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
					
					/* 印刷 */
					Map<PrintParamKey, Object> params = new HashMap<RoltoPrint.PrintParamKey, Object>();
					params.put(PrintParamKey.UsesErrorDiffusion, false);
					params.put(PrintParamKey.BinarizationOffset, 0.05);
					params.put(PrintParamKey.BlockSize, 0.79);
					
					mRoltoPrint.performPrintImage(bitmap, params, callback);
				}
			}
			/* 複数イメージ印刷 */
			else
			{
				Map<PrintParamKey, Object> params = new HashMap<RoltoPrint.PrintParamKey, Object>();
				params.put(PrintParamKey.UsesErrorDiffusion, true);
				
				/* 3枚印刷する */
				List<Uri> imageUris = new ArrayList<Uri>();
				imageUris.add(mSelectedImageUri);
				imageUris.add(mSelectedImageUri);
				imageUris.add(mSelectedImageUri);
				
				mRoltoPrint.performPrintImageUris(getActivity(), imageUris, params, callback);
			}
		}
	};
	
	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		if ( requestCode == Request_GetImage )
		{
			if ( resultCode == Activity.RESULT_OK )
			{
				mSelectedImageUri = data.getData();
				mSelectedImageView.setImageURI(mSelectedImageUri);
			}
		}
		else
		{
			super.onActivityResult(requestCode, resultCode, data);
		}
	}

	@Override
	public void onPrinterSelected(RoltoPrint print) {
		mRoltoPrint = print;
	}
}
