package jp.co.kingjim.rolto.printsdk.sample;

import jp.co.kingjim.rolto.print.RoltoPrint;
import jp.co.kingjim.rolto.print.RoltoPrinterDiscover;
import jp.co.kingjim.rolto.print.RoltoPrinterDiscover.OnFindPrinterCallback;
import jp.co.kingjim.rolto.print.RoltoPrinterDiscover.SearchCompleteCallback;
import android.app.Fragment;
import android.app.ListFragment;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;

public class PrinterSelectFragment extends ListFragment {
	private RoltoPrinterDiscover mRoltoDiscover = new RoltoPrinterDiscover();
	private Button mRefreshButton;
	
	private static final String ListenerTagKey = PrinterSelectFragment.class.getName() + "_PrinterSelectedListenerTagKey";
	
	public interface PrinterSelectedListener {
		void onPrinterSelected(RoltoPrint print);
	}
	
	public PrinterSelectFragment() {
		setArguments(new Bundle());
	}
	
	public void setPrinterSelectedListenerTag(String tag) {
		getArguments().putString(ListenerTagKey, tag);
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		setListAdapter(new PrinterListAdapter(getActivity()));
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View rootView = inflater.inflate(R.layout.fragment_select_printer, container, false);
		mRefreshButton = (Button) rootView.findViewById(R.id.button_refresh);
		mRefreshButton.setOnClickListener(mOnRefreshClick);
		
		return rootView;
	}

	@Override
	public void onDestroyView() {
		mRefreshButton = null;
		
		super.onDestroyView();
	}

	@Override
	public void onResume() {
		super.onResume();
		
		mRefreshButton.performClick();
	}

	private OnClickListener mOnRefreshClick = new OnClickListener() {
		@Override
		public void onClick(View v) {
			final PrinterListAdapter adapter = (PrinterListAdapter) getListAdapter();
			adapter.clear();
			mRefreshButton.setEnabled(false);
			mRoltoDiscover.searchPrinters(new OnFindPrinterCallback() {
				@Override
				public void onFindPrinter(RoltoPrint print) {
					adapter.add(print);
				}
			}, new SearchCompleteCallback() {
				@Override
				public void onPrinterSearchComplete() {
					if ( mRefreshButton != null )
					{
						mRefreshButton.setEnabled(true);
					}
				}
			}, 10);
		}
	};
	
	@Override
	public void onListItemClick(ListView l, View v, int position, long id) {
		/* TODO コールバック呼んで画面閉じる */
		String listenerTag = getArguments().getString(ListenerTagKey);
		if ( !TextUtils.isEmpty(listenerTag) )
		{
			Fragment listenerFragment = getFragmentManager().findFragmentByTag(listenerTag);
			if ( listenerFragment instanceof PrinterSelectedListener )
			{
				PrinterSelectedListener listener = (PrinterSelectedListener) listenerFragment;
				PrinterListAdapter adapter = (PrinterListAdapter) getListAdapter();
				listener.onPrinterSelected(adapter.getItem(position));
			}
		}
		
		getFragmentManager().popBackStack();
	}

	private static class PrinterListAdapter extends ArrayAdapter<RoltoPrint> {
		private LayoutInflater mInflater;

		public PrinterListAdapter(Context context) {
			super(context, 0);
			mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			ViewHolder holder = null;
			if ( convertView == null )
			{
				convertView = mInflater.inflate(android.R.layout.simple_list_item_1, parent, false);
				holder = new ViewHolder();
				holder.textView = (TextView) convertView.findViewById(android.R.id.text1);
				convertView.setTag(holder);
			}
			else
			{
				holder = (ViewHolder) convertView.getTag();
			}
			
			RoltoPrint print = getItem(position);
			holder.textView.setText(print.getPrinterName());
			
			return convertView;
		}
	}
	
	private static class ViewHolder {
		public TextView textView;
	}
}