/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.rolto.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.kingjim.rolto.print.RoltoBitmapDrawer;
import jp.co.kingjim.rolto.print.RoltoCompositeDrawer;
import jp.co.kingjim.rolto.print.RoltoDrawer;
import jp.co.kingjim.rolto.print.RoltoDrawerForNative;
import jp.co.kingjim.rolto.print.RoltoPrint_Native;

public class RoltoPrint
implements Parcelable {
    private String mPrinterName;
    private String mModelId;
    private String mAddress;
    private RoltoPrint_Native mNativeInterface;
    public static final Parcelable.Creator<RoltoPrint> CREATOR = new Parcelable.Creator<RoltoPrint>(){

        public RoltoPrint createFromParcel(Parcel parcel) {
            return new RoltoPrint(parcel);
        }

        public RoltoPrint[] newArray(int n) {
            return new RoltoPrint[n];
        }
    };

    protected RoltoPrint(String string) {
        this.mAddress = string;
        this.mNativeInterface = new RoltoPrint_Native(string);
    }

    protected RoltoPrint(String string, String string2, String string3) {
        this(string3);
        this.mPrinterName = string;
        this.mModelId = string2;
    }

    public String getModelIdentifier() {
        return this.mModelId;
    }

    public String getPrinterName() {
        return this.mPrinterName;
    }

    public void performPrintImage(Bitmap bitmap, Map<PrintParamKey, Object> map, PrintResultCallback printResultCallback) {
        RoltoBitmapDrawer roltoBitmapDrawer = new RoltoBitmapDrawer(bitmap);
        this.performPrint(roltoBitmapDrawer, map, printResultCallback);
    }

    public void performPrintImagePaths(List<String> list, Map<PrintParamKey, Object> map, PrintResultCallback printResultCallback) {
        ArrayList<RoltoDrawer> arrayList = new ArrayList<RoltoDrawer>();
        for (String string : list) {
            RoltoBitmapDrawer roltoBitmapDrawer = new RoltoBitmapDrawer(string);
            arrayList.add(roltoBitmapDrawer);
        }
        RoltoCompositeDrawer roltoCompositeDrawer = new RoltoCompositeDrawer(arrayList);
        this.performPrint(roltoCompositeDrawer, map, printResultCallback);
    }

    public void performPrintImageUris(Context context, List<Uri> list, Map<PrintParamKey, Object> map, PrintResultCallback printResultCallback) {
        ArrayList<RoltoDrawer> arrayList = new ArrayList<RoltoDrawer>();
        for (Uri uri : list) {
            RoltoBitmapDrawer roltoBitmapDrawer = new RoltoBitmapDrawer(context, uri);
            arrayList.add(roltoBitmapDrawer);
        }
        RoltoCompositeDrawer roltoCompositeDrawer = new RoltoCompositeDrawer(arrayList);
        this.performPrint(roltoCompositeDrawer, map, printResultCallback);
    }

    public void cancelPrint() {
        this.mNativeInterface.cancelPrint();
    }

    public void requestPrinterStatus(final PrinterStatusCallback printerStatusCallback) {
        final Handler handler = new Handler();
        new Thread(){

            @Override
            public void run() {
                final RoltoPrint_Native.StatusHolder statusHolder = new RoltoPrint_Native.StatusHolder();
                RoltoPrint.this.mNativeInterface.requestPrinterStatus(statusHolder);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (printerStatusCallback != null) {
                            PrinterStatus printerStatus = null;
                            PrinterStatus[] printerStatusArray = PrinterStatus.values();
                            if (statusHolder.printerStatus >= 0 && statusHolder.printerStatus < printerStatusArray.length) {
                                printerStatus = printerStatusArray[statusHolder.printerStatus];
                            }
                            printerStatusCallback.onReceivePrinterStatus(printerStatus, statusHolder.isDirectMode);
                        }
                    }
                });
            }
        }.start();
    }

    private void performPrint(final RoltoDrawer roltoDrawer, final Map<PrintParamKey, Object> map, final PrintResultCallback printResultCallback) {
        AsyncTask<Void, Double, Integer> asyncTask = new AsyncTask<Void, Double, Integer>(){

            protected Integer doInBackground(Void ... voidArray) {
                Integer n;
                Number number;
                Object v;
                Boolean bl;
                RoltoDrawerForNative roltoDrawerForNative = new RoltoDrawerForNative(roltoDrawer);
                Boolean bl2 = (Boolean)map.get((Object)PrintParamKey.Rotates);
                if (bl2 == null) {
                    bl2 = false;
                }
                if ((bl = (Boolean)map.get((Object)PrintParamKey.UsesErrorDiffusion)) == null) {
                    bl = false;
                }
                if ((v = map.get((Object)PrintParamKey.BinarizationOffset)) instanceof Double) {
                    number = (Double)v;
                    n = (int)((Double)number * 100.0);
                } else {
                    n = 5;
                    Log.d((String)"RoltoPrint", (String)"Parameter Error! (Binarization Offset)");
                }
                Object v2 = map.get((Object)PrintParamKey.BlockSize);
                if (v2 instanceof Double) {
                    Double d = (Double)v2;
                    number = (int)Math.pow(10.0, (1.0 - d) * 3.0);
                } else {
                    number = 4;
                    Log.d((String)"RoltoPrint", (String)"Parameter Error! (Block size)");
                }
                Log.d((String)"RoltoPrint", (String)("binarizationOffset=" + n + ", blockSize=" + number));
                int n2 = RoltoPrint.this.mNativeInterface.performPrint(roltoDrawerForNative, bl2, bl, n, (Integer)number);
                return n2;
            }

            protected void onPostExecute(Integer n) {
                if (printResultCallback == null) {
                    return;
                }
                PrintResult[] printResultArray = PrintResult.values();
                PrintResult printResult = PrintResult.UnexpectedError;
                if (n < printResultArray.length) {
                    printResult = printResultArray[n];
                }
                printResultCallback.onPrintComplete(printResult);
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private RoltoPrint(Parcel parcel) {
        this.mPrinterName = parcel.readString();
        this.mModelId = parcel.readString();
        this.mAddress = parcel.readString();
        this.mNativeInterface = new RoltoPrint_Native(this.mAddress);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mPrinterName);
        parcel.writeString(this.mModelId);
        parcel.writeString(this.mAddress);
    }

    public static interface PrinterStatusCallback {
        public void onReceivePrinterStatus(PrinterStatus var1, boolean var2);
    }

    public static interface PrintResultCallback {
        public void onPrintComplete(PrintResult var1);
    }

    public static enum PrinterStatus {
        Idle,
        Printing,
        WritingFirmware,
        CoverOpen,
        PaperOut,
        Overheated;

    }

    public static enum PrintResult {
        Success,
        UserCancel,
        CommunicationError,
        PaperOutError,
        OverheatError,
        CoverOpenError,
        PrinterBusyError,
        UnexpectedError;

    }

    public static enum PrintParamKey {
        Rotates,
        UsesErrorDiffusion,
        BinarizationOffset,
        BlockSize;

    }
}

