/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.rolto.print;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import jp.co.kingjim.rolto.print.RoltoDrawer;

class RoltoPartialDrawer
extends RoltoDrawer {
    private RoltoDrawer mDrawer;
    private RectF mTargetRect;

    public RoltoPartialDrawer(RoltoDrawer roltoDrawer, RectF rectF) {
        this.mDrawer = roltoDrawer;
        this.mTargetRect = rectF;
    }

    @Override
    public float getContentWidth() {
        float f = 0.0f;
        if (this.mTargetRect != null) {
            f = this.mTargetRect.width();
        } else if (this.mDrawer != null) {
            f = this.mDrawer.getContentWidth();
        }
        return f;
    }

    @Override
    public float getContentHeight() {
        float f = 0.0f;
        if (this.mTargetRect != null) {
            f = this.mTargetRect.height();
        } else if (this.mDrawer != null) {
            f = this.mDrawer.getContentHeight();
        }
        return f;
    }

    @Override
    public void drawContent(Canvas canvas, RectF rectF) {
        canvas.save();
        Matrix matrix = new Matrix();
        matrix.setTranslate(-this.mTargetRect.left, -this.mTargetRect.top);
        canvas.concat(matrix);
        RectF rectF2 = new RectF(rectF);
        rectF2.offset(this.mTargetRect.left, this.mTargetRect.top);
        this.mDrawer.drawContent(canvas, rectF2);
        canvas.restore();
    }

    @Override
    public boolean isRotated() {
        boolean bl = false;
        bl = this.mDrawer != null ? this.mDrawer.isRotated() : super.isRotated();
        return bl;
    }
}

