/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.rolto.print;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jp.co.kingjim.rolto.print.RoltoDrawer;

final class RoltoDrawerForNative {
    private RoltoDrawer mDrawer;

    public RoltoDrawerForNative(RoltoDrawer roltoDrawer) {
        this.mDrawer = roltoDrawer;
    }

    protected int getContentWidth() {
        return (int)this.mDrawer.getContentWidth();
    }

    protected int getContentHeight() {
        return (int)this.mDrawer.getContentHeight();
    }

    protected boolean isRotated() {
        return this.mDrawer.isRotated();
    }

    protected void getImageData(ByteBuffer byteBuffer, int n, int n2, int n3, boolean bl) {
        float f;
        float f2 = this.getContentWidth();
        float f3 = this.getContentHeight();
        if (f2 == 0.0f || f3 == 0.0f) {
            return;
        }
        int n4 = 0;
        if (!bl) {
            f = (float)n2 / f2;
            n4 = (int)(f3 * f);
        } else {
            f = (float)n2 / f3;
            n4 = (int)(f2 * f);
        }
        Matrix matrix = new Matrix();
        float f4 = f2;
        float f5 = (float)n2 / f4;
        matrix.postScale(f5, f5);
        matrix.postTranslate(0.0f, (float)(-n));
        if (bl) {
            matrix.postRotate(-1.5707964f);
            matrix.postTranslate((float)(-n4), 0.0f);
            f4 = f3;
        }
        RectF rectF = null;
        if (!bl) {
            rectF = new RectF(0.0f, (float)n / f5, f4, (float)(n + n3) / f5);
        }
        Log.d((String)"RoltoPrint", (String)("startRow=" + n + ", bandHeight=" + n3 + ", scale=" + f5 + ", bottom=" + (float)(n + n3) / f5));
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.setMatrix(matrix);
        this.mDrawer.drawContent(canvas, rectF);
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
    }
}

