/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.rolto.print;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import jp.co.kingjim.rolto.print.RoltoDrawer;

class RoltoCompositeDrawer
extends RoltoDrawer {
    private List<RoltoDrawer> mDrawers;
    private float mContentWidth;
    private float mContentHeight;

    public RoltoCompositeDrawer(List<RoltoDrawer> list) {
        this.mDrawers = new ArrayList<RoltoDrawer>(list);
        this.mContentWidth = this.mDrawers.get(0).getContentWidth();
        this.mContentHeight = 0.0f;
        for (RoltoDrawer roltoDrawer : this.mDrawers) {
            float f = this.mContentWidth / roltoDrawer.getContentWidth();
            this.mContentHeight += roltoDrawer.getContentHeight() * f;
        }
    }

    @Override
    public float getContentWidth() {
        return this.mContentWidth;
    }

    @Override
    public float getContentHeight() {
        return this.mContentHeight;
    }

    @Override
    public void drawContent(Canvas canvas, RectF rectF) {
        float f = 0.0f;
        for (RoltoDrawer roltoDrawer : this.mDrawers) {
            float f2 = this.mContentWidth / roltoDrawer.getContentWidth();
            float f3 = this.mContentWidth;
            float f4 = (int)(roltoDrawer.getContentHeight() * f2);
            RectF rectF2 = new RectF(0.0f, f, f3, f + f4);
            if (RectF.intersects((RectF)rectF, (RectF)rectF2)) {
                canvas.save();
                canvas.translate(0.0f, f);
                canvas.scale(f2, f2);
                RectF rectF3 = new RectF(0.0f, 0.0f, roltoDrawer.getContentWidth(), roltoDrawer.getContentHeight());
                roltoDrawer.drawContent(canvas, rectF3);
                canvas.restore();
                Log.d((String)"RoltoPrint", (String)("currentY=" + f));
            }
            Log.d((String)"RoltoPrint", (String)("ratio=" + f2 + ", scaledWidth=" + f3 + ", scaledHeight=" + f4));
            f += f4;
        }
    }
}

