/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.rolto.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jp.co.kingjim.rolto.print.RoltoDrawer;

class RoltoBitmapDrawer
extends RoltoDrawer {
    private Bitmap mBitmap;
    private String mImagePath;
    private Context mContext;
    private Uri mImageUri;

    public RoltoBitmapDrawer(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public RoltoBitmapDrawer(String string) {
        this.mImagePath = string;
    }

    public RoltoBitmapDrawer(Context context, Uri uri) {
        this.mContext = context;
        this.mImageUri = uri;
    }

    @Override
    public float getContentWidth() {
        return this.getBitmap().getWidth();
    }

    @Override
    public float getContentHeight() {
        return this.getBitmap().getHeight();
    }

    @Override
    public void drawContent(Canvas canvas, RectF rectF) {
        Bitmap bitmap = this.getBitmap();
        canvas.drawBitmap(bitmap, new Matrix(), null);
    }

    private Bitmap getBitmap() {
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            if (this.mImagePath != null) {
                bitmap = BitmapFactory.decodeFile((String)this.mImagePath);
            } else if (this.mContext != null && this.mImageUri != null) {
                InputStream inputStream = null;
                try {
                    inputStream = this.mContext.getContentResolver().openInputStream(this.mImageUri);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                if (inputStream != null) {
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return bitmap;
    }
}

